function [beta_k, Pk]=CSKF_zero(beta_k0, Pk0, xb, Hk, Rk, Re, n_iterations,alpha)

% The CS-embedded Kalman filter (l_p norm variant). For more details see
% 'Methods for Sparse Signal Recovery Using Kalman Filtering with Embedded
% Pseudo-Measurement Norms and Quasi-Norms' by A. Carmi, P. Gurfil and D.
% Kanevsky, IEEE TRANSACTIONS ON SIGNAL PROCESSING, VOL. 58, NO. 4, APRIL 2010


m=size(Hk,2);

Pk=Pk0;
beta_k=beta_k0;

Kk=Pk*Hk'*inv(Hk*Pk*Hk'+Rk);
beta_k=beta_k+Kk*(xb-Hk*beta_k);
Pk=(eye(m)-Kk*Hk)*Pk*(eye(m)-Kk*Hk)'+Kk*Rk*Kk';

for i=1:n_iterations,
    
  %  s1=sum(abs(beta_k).^q);
    
  %  z=s1^(1/q);
    
    for j=1:m,
        if (beta_k(j) > 0)
           % xa1(i)=s1^(1/q-1)*beta_k(i)^(q-1);
           xa1(j) = -alpha*exp(-alpha*beta_k(j));
        else
           xa1(j) = alpha*exp(alpha*beta_k(j));
        end
    end
    
    Hk=xa1;
    
    Kk=Pk*Hk'/(Hk*Pk*Hk'+Re);
    l0_number = 0;
    for i=1:m
        l0_number = l0_number + exp(-alpha*abs(beta_k(i)));
    end,
    beta_k=beta_k-Kk*[m-l0_number];
    
    % The covariance update of the pseudo-measurement stage is not
    % mandatory. The algorithm runs faster when this stage is omitted.
    
    %   Pk=(eye(m)-Kk*Hk)*Pk*(eye(m)-Kk*Hk)'+Kk*Re*Kk';
end
