function [beta_k, Pk]=CSKF(beta_k0, Pk0, xb, Hk, Rk, Re, n_iterations)

% The CS-embedded Kalman filter. For more details see
% 'Methods for Sparse Signal Recovery Using Kalman Filtering with Embedded
% Pseudo-Measurement Norms and Quasi-Norms' by A. Carmi, P. Gurfil and D.
% Kanevsky, IEEE TRANSACTIONS ON SIGNAL PROCESSING, VOL. 58, NO. 4, APRIL 2010


m=size(Hk,2);

Pk=Pk0;
beta_k=beta_k0;

%y=pcg(Hk*Pk*Hk'+Rk, xb-Hk*beta_k);
Kk=Pk*Hk'*inv(Hk*Pk*Hk'+Rk);
beta_k=Kk*(xb-Hk*beta_k);
Pk=(eye(m)-Kk*Hk)*Pk*(eye(m)-Kk*Hk)'+Kk*Rk*Kk';

for i=1:n_iterations,
        
    Hk=sign(beta_k)';
    
    Kk=Pk*Hk'/(Hk*Pk*Hk'+Re);
    beta_k=beta_k-Kk*Hk*beta_k;
    
    % The covariance update of the pseudo-measurement stage is not
    % mandatory. The algorithm runs faster when this stage is omitted.
    
    %Pk=(eye(m)-Kk*Hk)*Pk*(eye(m)-Kk*Hk)'+Kk*Re*Kk';
end
