% daub1018.m
%
% Returns the filter coefficients for the popular Daubechies 10,18 wavelet
% set
% Usage : [h0,h1,g0,g1] = daub1018
% h0 - lowpass analysis
% h1 - highpass analysis
% g0 - lowpass synthesis
% g1 - highpass synthesis
% 
% Written by : Justin Romberg
% Created : 8/27/2001
function [h0, h1, g0, g1] = daub1018()

h0 = [0 0 0 0 0.02885256501123 0.00008244478228 -0.15752644690763 ,...
      0.07679048884692 0.75890772945376 0.75890772945376 ,...
      0.07679048884692 -0.15752644690763 0.00008244478228 ,...
      0.02885256501123 0 0 0 0];

h1 = [-0.00095441586824 -0.00000272719630 0.00945246299836 ,...
      -0.00252803729395 -0.03083373438534 -0.01376513483818 ,...
      0.08566118833165 0.16336854055699 -0.62335964103441 ,...
      0.62335964103441 -0.16336854055699 -0.08566118833166 ,...
      0.01376513483818 0.03083373438534 0.00252803729395 ,...
      -0.00945246299836 0.00000272719630 0.00095441586824];

g0 = [0.00095441586824 -0.00000272719630 -0.00945246299836 ,...
      -0.00252803729395 0.03083373438534 -0.01376513483818 ,...
      -0.08566118833165 0.16336854055699 0.62335964103441 ,...
      0.62335964103441 0.16336854055699 -0.08566118833166 ,...
      -0.01376513483818 0.03083373438534 -0.00252803729395 ,...
      -0.00945246299836 -0.00000272719630 0.00095441586824];

g1 = [0 0 0 0 0.02885256501123 -0.00008244478228 -0.15752644690763 ,...
      -0.07679048884692 0.75890772945376 -0.75890772945376 ,...
      0.07679048884692 0.15752644690763 0.00008244478228 ,...
      -0.02885256501123 0 0 0 0];

