#include "testAPS.h"


module testC {
  uses {
	interface Boot;
	interface Timer<TMilli> as periodicTimer;
//	interface Timer<TMilli> as HeartbeatTimer;
//#ifndef TOSSIM
	interface Init as SyncInit;
//	interface  GlobalTime<TMilli>;
//	interface StdControl as SyncStdControl;
/***************JINHONG-TimeSync*******************/	
	interface Tsync;
	interface OTime;
/***************************************************/	
	interface Leds;
	interface AMSend as AMSendSerial;
	interface SplitControl as SerialControl;
	interface SplitControl as RadioControl;	//++
	interface Receive as RadioReceive;

	 interface AMPacket;

//#endif  

	interface Random;

   interface StdControl as APSStdControl;
   interface Init as APSInit;

   interface APSSend as Send;    
   interface Receive;    
   interface Intercept;    
//   interface APSControl;
   interface APSInfo;	//routing tree info
   interface Packet as serialPacket;
   interface Packet as radioPacket;

//   interface Timer<TMilli> as roundTimer;
//   interface Timer<TMilli> as eventTimer;
   interface Timer<TMilli> as eventTimer;
  }
}
implementation {
  message_t packet, pktSerial;
  bool sendBusy = FALSE;
  bool serialBusy = FALSE;
  //uint32_t globleTimestamp;
  uint8_t cmdSeqNum;
  uint8_t dataSeqNum;

  RadioCmdMsg* radioCmdPkt;
  testMsg* message;
  logMsg* serialPkt;
  uint8_t iSeqNum;
  uint32_t iSycTime;

  uint8_t reptID;
  uint8_t ExperimentID;
  uint8_t topology;
  uint8_t protocol;
  uint8_t traffic;
  uint8_t latencyReq;
//  uint8_t counter;
   uint8_t lastTraffic;
   uint8_t lastLatency;

  bool isFirst;
  uint16_t pktInterval;
  uint16_t latencyReqValue;
//  uint32_t latencyReqValue;

  uint16_t eventInterval[] = {930, 1217, 780, 1014, 1447, 1306, 0, 1195, 1837, 1334, 840, 1843, 2224, 1669, 1079, 1472, 2059, 1793, 2119, 2376, 2057, 1956, 2202, 2361, 1794, 2118, 2954, 2754, 1921, 2115, 2263, 2518, 3098, 3127, 2754, 1871, 2380, 3034, 3210, 3039, 3352, 2966, 3101, 3270, 2910, 3093, 2730, 3343};
  uint8_t eventIndex;
 /*********************Jinhong Xu*******************************/
  uint32_t thisParent =0, tempParent; //for converge time checking
  bool isSync= FALSE;
  

  void logPacketElements(message_t* msg, uint8_t txORrx, uint8_t retranxNum);

  event void Boot.booted() {

	//start URAT, radio
	  if (call SerialControl.start() != SUCCESS)
	  {
		  call SerialControl.start() ;
	  }	   

	call RadioControl.start();
  }
  
  event void Tsync.synced() { 
    isSync = TRUE;
    } 
  
  
  
  
  event void RadioControl.startDone(error_t err) {
    if (err != SUCCESS)
      call RadioControl.start();
    else {
		//Initilize Sync and APS
		//call SyncInit.init();
	    call APSInit.init();
      //start APS and Sync
	  call APSStdControl.start();
	  //call SyncStdControl.start();

      if (TOS_NODE_ID == ROOT_NODE_ID) 
			call APSInfo.setRoot();

//    	counter = 0;
		lastTraffic = 0xFF;
		lastLatency = 0xFF;
    }
		dbg("testC", "Initialization success: serial and radio started, root set...........\n");
  }


 event void RadioControl.stopDone(error_t err) { }

/*----------------------------------------------receive info from radio------------------------------------------------ */
  event message_t* RadioReceive.receive(message_t* bufPtr, void* payload, uint8_t len) {	
	//call Leds.led0Toggle();//Qiao
	
	radioCmdPkt = (RadioCmdMsg*)payload;


	//sync
	cmdSeqNum = radioCmdPkt->iSeqNum;	
	iSycTime = (BROADCAST_TIMES -1 -iSeqNum) * BROADCAST_INTERVAL + SYNC_OFFSET;			

/*---------------------------------------------------------------------------------------------------------------------------*/	
	reptID = radioCmdPkt->reptID;
	topology = radioCmdPkt->topology;
	protocol = radioCmdPkt->protocol;
	traffic = radioCmdPkt->traffic;
	latencyReq = radioCmdPkt->latencyReq;
/*---------------------------------------------------------------------------------------------------------------------------*/
//compute traffic period and latency tolerence
//	pktInterval = ((call Random.rand16()) % 2501) + 500;			//uniform distribution over [500,3000]
//	latencyReqValue = 21000;
	if (traffic == 1)
	{
			pktInterval = ((call Random.rand16()) % 2501) + 500;			//uniform distribution over [500,3000]
			if ( latencyReq == 1)
					latencyReqValue = 1 * 1500;
			if (latencyReq == 2)
					latencyReqValue = 5 * 1500;
			if (latencyReq == 3)
					latencyReqValue = 9 * 1500;
			if (latencyReq == 4)
					latencyReqValue = 14 * 1500;		
			if (latencyReq == 5)
					latencyReqValue = 3 * 1500;
	}

	if (traffic == 2)
	{
			pktInterval = ((call Random.rand16()) % 5501) + 500;			//[500, 6000]
			if ( latencyReq == 1)
					latencyReqValue = 1 * 3000;
			if (latencyReq == 2)
					latencyReqValue = 5 * 3000;
			if (latencyReq == 3)
					latencyReqValue = 9 * 3000;
			if (latencyReq == 4)
					latencyReqValue = 14 * 3000;	
			if (latencyReq == 5)
					latencyReqValue = 3 * 3000;
	}	
	
	if (traffic == 3)
	{
			pktInterval = ((call Random.rand16()) % 8501) + 500;			//[500, 9000]
			if ( latencyReq == 1)
					latencyReqValue = 1 * 4500;
			if (latencyReq == 2)
					latencyReqValue = 5 * 4500;
			if (latencyReq == 3)
					latencyReqValue = 9 * 4500;
			if (latencyReq == 4)
					latencyReqValue = 14 * 4500;	
			if (latencyReq == 5)
					latencyReqValue = 3 * 4500;
	}
	
	if (traffic == 4)
	{
			eventIndex = (call Random.rand16()) % INTERVAL_NUM;			
			pktInterval = eventInterval[eventIndex];
			
			if ( latencyReq == 1)
					latencyReqValue = 3000;
			if (latencyReq == 2)
					latencyReqValue = 6000;
			if (latencyReq == 3)
					latencyReqValue = 9000;
			if (latencyReq == 4)
					latencyReqValue = 8000;							

//						latencyReqValue = 2000 * latencyReq;
//						latencyReqValue = 64000;
	}
		

//	Set APS	
		if ((lastLatency !=latencyReq)	|| (lastTraffic != traffic))//??????????????????????
		{
		//resetting estimator for t-Packing
								//jinhong RESETTING!! set parameter for APS
//			if(protocol == 3)
			call APSInfo.reInit();	
//			counter = ROUND_TIMER_COUNT;
			call APSInfo.setMaxPktInterval(latencyReqValue);					//set parameter for APS layer??????????
//			call roundTimer.startPeriodic(ROUND_TIMER_PERIOD);
		}
		lastLatency = latencyReq;
		lastTraffic = traffic;


		
//		if (TOS_NODE_ID != ROOT_NODE_ID)// && isSync == TRUE ) Depends on experiment 
		if ((TOS_NODE_ID != ROOT_NODE_ID) && (TOS_NODE_ID % 2 == 0))	// only nodes with even id generate element
		{
			dataSeqNum = 0;
			if (traffic != 4)
			{
//				call Timer.startPeriodicAt((call Timer.getNow()) + iSycTime, pktInterval);		//periodic traffic
				call periodicTimer.startOneShotAt((call periodicTimer.getNow()) + iSycTime, pktInterval);		//periodic traffic
			}
			else
			{
//				call sendTimer.startOneShotAt((call Timer.getNow()) + iSycTime, MAX_INTERVAL);		//event traffic 
				call eventTimer.startOneShotAt((call eventTimer.getNow()) + iSycTime, pktInterval);		//event traffic 
			}
					
		}
    return bufPtr;
  }


// event void eventTimer.fired() {
//if (dataSeqNum < SEND_PKT_NUM)
//{
//			call sendTimer.startOneShot(pktInterval); 
//}
//else
//{
//			call eventTimer.stop();
//}
//
//}

//send event traffic
 event void eventTimer.fired()
{

//   if (!sendBusy)
//	{
		message = (testMsg*)call  radioPacket.getPayload(&packet, sizeof(testMsg));
		//call GlobalTime.getGlobalTime(&globleTimestamp);
		message->source_id = TOS_NODE_ID;
		message->seqNum = dataSeqNum++;
		message->generatedTime = (call OTime.getGlobalTime32());

//		call Leds.led2Toggle();// send packets
		if (call Send.send(&packet, sizeof(testMsg), latencyReqValue) != SUCCESS) 
		{
				dbg("testC", "Packet sending failed \n");
		}
		else 
		{			
				dbg("testC", "Packet sending. \n");
//				sendBusy = TRUE;
		}
		
//	}

}

//  event void roundTimer.fired() { 		
//	  if (counter >0)
//	  {
//		  counter--;
//	  }
//	  else
//			call roundTimer.stop();
//}

  event void periodicTimer.fired() {

if (dataSeqNum < SEND_PKT_NUM)
{

////   if (!sendBusy)
//{
	   
		message = (testMsg*)call  radioPacket.getPayload(&packet, sizeof(testMsg));
		//call GlobalTime.getGlobalTime(&globleTimestamp);
		message->source_id = TOS_NODE_ID;
		message->seqNum = dataSeqNum++;
		message->generatedTime = (call OTime.getGlobalTime32());

//		call Leds.led2Toggle();// send packets
//    if (call Send.send(&packet, sizeof(testMsg), MAX_LATENCY) != SUCCESS) 
	if (call Send.send(&packet, sizeof(testMsg), latencyReqValue) != SUCCESS) 
	{
				dbg("testC", "Packet sending failed \n");
	}
	else 
	{			
				dbg("testC", "Packet sending. \n");
	}

	//compute traffic period and latency tolerence
//	pktInterval = ((call Random.rand16()) % 2501) + 500;			//uniform distribution over [500,3000]
	if (traffic == 1)
				pktInterval = ((call Random.rand16()) % 2501) + 500;			//uniform distribution over [500,3000]

	if (traffic == 2)
				pktInterval = ((call Random.rand16()) % 5501) + 500;			//[500, 6000]
	
	if (traffic == 3)
				pktInterval = ((call Random.rand16()) % 8501) + 500;			//[500, 9000]
	

		call periodicTimer.startOneShot( pktInterval);		//periodic traffic

}// if >
else
{
			call periodicTimer.stop();
}
}	//end fired



  event error_t Send.sendDone(message_t *m, error_t err) {   return err;}
  
  event error_t APSInfo.sendSignal(message_t* msg, error_t err, uint8_t retranxNum) {
			//call Leds.led2Toggle();
#ifndef TOSSIM
//			call Leds.led1Toggle();		//sending data
#endif

			logPacketElements(msg, 0, retranxNum);
#ifdef TOSSIM
			dbg_clear("URAT", "0 %d %d %d %d %d %d %d ", TOS_NODE_ID, call APSInfo.getParent(), call APSInfo.getEtx(),call APSInfo.getETX0(),call APSInfo.getHopCount(), retranxNum, call Timer.getNow());
			//payload
			dbg_clear("URAT", "%d %d \n", message->source_id, message->seqNum);
#endif
//	}
//			sendBusy = FALSE;
			return err;
  }
  
  event message_t*  Receive.receive(message_t* msg, void* payload, uint8_t len) {
#ifndef TOSSIM
//			call Leds.led1Toggle();		//receiving data
#endif

#ifndef TOSSIM
			logPacketElements(msg, 1, 0xff);
//			logPayload(msg, payload, len, 2);			
#else
			dbg_clear("URAT", "1 %d %d %d %d %d %d %d ", TOS_NODE_ID, call APSInfo.getParent(), 0,0,0,0, call Timer.getNow());
			dbg_clear("URAT1","\n");
#endif
			dbg("testC", "Packet reaching base station %d\n", TOS_NODE_ID); 	
			return msg;
  }

  event bool Intercept.forward(message_t *msg, void *payload, uint8_t len) {
#ifndef TOSSIM
//			call Leds.led1Toggle();		//forwarding data
#endif

#ifndef TOSSIM
			logPacketElements(msg, 2, 0xff);
//		logPayload(msg, payload, len);
#else
			dbg_clear("URAT", "1 %d %d %d %d %d %d %d ", TOS_NODE_ID, call APSInfo.getParent(), 0,0,0,0, call Timer.getNow());
			dbg_clear("URAT1","\n");
#endif
			dbg("testC", "Packet farwarded through intermediate node %d\n", TOS_NODE_ID);
			return TRUE;
}


/******************logPacketElements from Jinhong***************************************************/
//txORrx: 0 -- send   1 -- forward  2 --- receive    retranxNum: MAX_RETRIES + 10 ----- failure,  0xff ------------- invalid
void logPacketElements(message_t* pmsg, uint8_t txORrx, uint8_t retranxNum)
{
   	TOS_APSPayload * thisPayload;
	TOS_APSPE * thisPE;
	uint8_t PEOverallLen, i, peNumber, count;
	uint8_t * PEbase;
testMsg * testMsgPtr; 

	//load pkt 
    serialPkt = (logMsg*)(call serialPacket.getPayload(&pktSerial, sizeof(logMsg)));
   	atomic {
   		thisPayload = (TOS_APSPayload *)(&(pmsg->data[ALR_OVERHEAD]));
   		PEOverallLen = thisPayload->length;
   		PEbase = &thisPayload->data[0];
 		}

     	dbg("DBG_ERROR", "PEOverallLen = %d\n", PEOverallLen);
 //sanity check
 	if (PEOverallLen > MAX_APS_PE_LEN) {
   			dbg("DBG_ERROR", "error: corrupted thisPayload->length, = %d\n", PEOverallLen);
   			return;
 		}

 //iterate over all payload elements
 	i = 0;
 	peNumber=0;		//element number
 	count=0;
 
 	while (i < PEOverallLen) {
   		thisPE = (TOS_APSPE *)(&PEbase[i]);
   		if (thisPE->length > MAX_APS_PE_LEN - PE_OVERHEAD || thisPE->length < MIN_PAYLOAD_ELEMENT_LEN - PE_OVERHEAD) {
     	dbg("DBG_ERROR", "error: corrupted thisPE->length, = %d\n", thisPE->length);
     	break;
   		}
  			else
 		{
				
				message = (testMsg*)(&(thisPE->data[0]));
				
				testMsgPtr = (testMsg*)(&(serialPkt->data[peNumber*sizeof(testMsg)]));
				testMsgPtr->source_id = message->source_id;
				testMsgPtr->seqNum = message->seqNum; 
				testMsgPtr->generatedTime = message->generatedTime; 

/*
				serialPkt->elements[peNumber].source_id = message->source_id;
				serialPkt->elements[peNumber].seqNum = message->seqNum;
				serialPkt->elements[peNumber].generatedTime = message->generatedTime;	
				*/
				peNumber++;
				dbg("DBG_ERROR", "loading packet %d!!!!!!!!!!!!!!!!!!\n", peNumber);
 		}
			i += (thisPE->length + PE_OVERHEAD);
			
 	} //while
 	
	
	/*---------------------------------------------------------------------------------------------------------------------------*/
	//call GlobalTime.getGlobalTime(&globleTimestamp);
		//send to URAT
	serialPkt->my_node_id = TOS_NODE_ID;
	serialPkt->parent_id = call APSInfo.getParent();
	serialPkt->myETX = call APSInfo.getEtx();
	serialPkt->myLinkETX = call APSInfo.getETX0();
	serialPkt->myHopLen = call APSInfo.getHopCount();
	serialPkt->txORrx = txORrx;	 // send or receive
	serialPkt->thisTxCount = retranxNum;

	serialPkt->myETT = call APSInfo.getETT();
	serialPkt->myLinkETX = call APSInfo.getETT0() ;

	
//	currentTime = call LocalTime.get();
	serialPkt->actionTimestamp = (call OTime.getGlobalTime32());
	
	if(txORrx==0)
		serialPkt->child_id=0xff;
	else
		serialPkt->child_id = call AMPacket.source(pmsg);
	 
	serialPkt->topology = topology;
	serialPkt->protocol = protocol;
	serialPkt->traffic = traffic;
	serialPkt->latencyReq = latencyReq;
	serialPkt->reptID = reptID;
	dbg("DBG_ERROR", "element number: %d!!!!!!!!!!!!!!!!!!\n", peNumber);
		/*---------------------------------------------------------------------------------------------------------------------------*/
/*   
   if (peNumber >1 && TOS_NODE_ID == 0)
   {
		//	call Leds.led2On();				//not single packing
   }
  */
		//	 call AMSendSerial.send(AM_BROADCAST_ADDR, &pktSerial, sizeof(logMsg));
			if (!serialBusy)
			{
				if ( call AMSendSerial.send(AM_BROADCAST_ADDR, &pktSerial, LOG_HEADER_LEN + peNumber * sizeof(testMsg)) == SUCCESS)
					{
						serialBusy = TRUE;
					}
			}
//			   dbg_clear("UART", " %02X %02X %02X %02X %02X %02X %02X %02X", serialPkt->my_node_id, serialPkt->parent_id, serialPkt->myETX,serialPkt->myLinkETX,serialPkt->myHopLen, serialPkt->txORrx, serialPkt->thisTxCount,1);
//			   dbg_clear("UART", " %02X %02X %02X %02X %02X", serialPkt->topology, serialPkt->protocol,serialPkt->traffic,serialPkt->latencyReq,serialPkt->reptID);
//				   
//					//payload
//			   for(count=0;count<peNumber;count++)
//			   {
//			   dbg_clear("UART", " %02X %02X %04X", serialPkt->elements[count].source_id, serialPkt->elements[count].seqNum, serialPkt->elements[count].generatedTime);
//			   }
//			  dbg_clear("UART", "\n");
//			   serialBusy = TRUE;
			//if


}//logPacketElements


event void AMSendSerial.sendDone(message_t *msg, error_t error)  
{
	if (&pktSerial == msg) {
      serialBusy = FALSE;
    }
}
event void SerialControl.startDone(error_t error) {}
event void SerialControl.stopDone(error_t error) {}
  }//implement
