
/*
 * Modules for application-driven packet scheduling (APS)
 *
 * @author: Hongwei zhang
 *                 hzhang@motorola.com, zhangho@cse.ohio-state.edu
 *
 * @modified: July 29, 2005
 */



#include "APS.h"


module APSC {
  
  provides {
   interface StdControl;
   interface Init;
   interface APSSend[uint8_t id];    //QoS aware Send interface: for data transmission
   interface Receive[uint8_t id];    //for data reception
//   interface APSControl;
   interface APSInfo;
   interface Intercept;
  }

  uses {
    interface StdControl as ALRControl;
    interface Send;
	interface Retranx;
    interface Intercept as APSIntercept;
    interface Init as ALRInit;
    interface CtpInfo;
	interface RootControl;
    interface Packet;  
    //interface StdControl as TimerControl;
    interface Timer<TMilli> as Timer;
    interface Leds;
	interface Receive as ALRReceive;

//#ifdef TOSSIM
    interface LocalTime<TMilli> as SysTime;
//#else
    interface LocalTime<TMilli>;
 //   interface MacControl;
    //interface CC2420Control;
//#endif
		//interface SplitControl;
  }
}

implementation {
  /***********************************************************************/
    // event void SplitControl.startDone(error_t error) {}
	// event void SplitControl.stopDone(error_t error) {}
  /************************************************************************/

  
  /***********************************************************************
   * Variables
   ***********************************************************************/
  /* packet queue */
  bool qLock;//, busyQTxed;   
  APSQElement Q[QUEUE_SIZE];
  uint8_t busyQHead, busyQTail;  //busy buffers
  uint8_t busySpareQHead;             //head of unpacked packet buffers
  uint8_t freeQHead, freeQTail;                        //free buffers
  uint8_t numBusyBuffers;                  //number of busy buffers
  uint8_t elmentType;
  uint16_t lastTime = 0;
  bool toFlushQueue;               //whether to flush packet queue immediately
  
  /* parameter estimation */
  uint16_t expSendInterval, expRcvInterval;             //expected transmission and reception interval; milliseconds
  uint32_t lastSendTime, lastRcvTime;                      //time for the last transmission and reception operations
  uint8_t expSendSize, expRcvSize;                             //expected transmission and reception packet size; # of bytes
  bool passedSecondReception, passedSecondSend;
  uint32_t maxPktInterval;
  
  uint8_t meanPELen; //expected length a payload element; initialized to 0xff

  bool isFirstTime;

  /* miscl */
  bool toDecreaseLatency;                   //whether some packet has > 0 maxLatency
  bool pending;                                   //transmission control
  uint32_t meanPktTime;                 //expected time taken to transmit a packet 
  bool directlyForwarded;                   //whether a packet is directly forwarded without local buffering

  //uint8_t minPELen;                          //number of bytes, including PE_OVERHEAD
  
   /* stats */
  TOS_APS_Stats apsStats;
  

  /***********************************************************************
   * Initialization 
   ***********************************************************************/
  
  command error_t Init.init() {
    uint8_t i;
	TOS_APSPayload * thisPayload;

    atomic{
      /* initialize packet queues & related variables */
	qLock = FALSE;
	//busyQTxed = FALSE;
      for (i=0; i <= QUEUE_SIZE-1; i++) {
		  Q[i].length = Q[i].maxLatency = 0;		
	  //hongwei new add
	//  thisPayload = (TOS_APSPayload *)(&(Q[i].msg.data[ALR_OVERHEAD]));
	//  thisPayload->length = 0;  
	  //
	if (i == 0)
	  Q[i].prev = QUEUE_SIZE;
	else
	  Q[i].prev = i - 1;
	if (i == QUEUE_SIZE-1)
	  Q[i].next = QUEUE_SIZE;
	else 
	  Q[i].next = i + 1;
      }
      busyQHead = busyQTail = busySpareQHead = QUEUE_SIZE;  //busy buffers
      freeQHead = 0; freeQTail = QUEUE_SIZE - 1;                              //free buffers
      numBusyBuffers = 0;

      toFlushQueue = FALSE;

      /* parameter estimation */
      
      expSendInterval = expRcvInterval = maxPktInterval= DEFAULT_MAX_PKT_INTERVAL;   //DEFAULT SETTING OF maxPktInterval
      expSendSize = expRcvSize = MIN_PKT_SIZE;
      passedSecondReception = passedSecondSend = FALSE;
      lastSendTime = lastRcvTime = 0;

      meanPELen = 0xff;
      isFirstTime = TRUE;

      /* miscl */
      toDecreaseLatency = FALSE;
      pending = directlyForwarded = FALSE;
      meanPktTime = (uint32_t)-1;

      //minPELen = meanPELen;

      /* stats */
      apsStats.numReceptions = 0;
      apsStats.numQueueOverflows = 0;
    }  //atomic

    //reflect parameter value to ALR layer 
    call CtpInfo.setAPSParams(expSendInterval, expSendSize);

    return SUCCESS;  //TimerControl.init()
  } //end of StdControl.init()
  
  
  command error_t APSInfo.reInit()
  {
	  uint8_t i;
    atomic {
	 /* Reinitialize packet queues & related variables */
	qLock = FALSE;
	//busyQTxed = FALSE;
      for (i=0; i <= QUEUE_SIZE-1; i++) {
		  Q[i].length = Q[i].maxLatency = 0;		
	  //hongwei new add
	//  thisPayload = (TOS_APSPayload *)(&(Q[i].msg.data[ALR_OVERHEAD]));
	//  thisPayload->length = 0;  
	  //
	if (i == 0)
	  Q[i].prev = QUEUE_SIZE;
	else
	  Q[i].prev = i - 1;
	if (i == QUEUE_SIZE-1)
	  Q[i].next = QUEUE_SIZE;
	else 
	  Q[i].next = i + 1;
      }
      busyQHead = busyQTail = busySpareQHead = QUEUE_SIZE;  //busy buffers
      freeQHead = 0; freeQTail = QUEUE_SIZE - 1;                              //free buffers
      numBusyBuffers = 0;

      toFlushQueue = FALSE;

      //expSendInterval = expRcvInterval = maxPktInterval= DEFAULT_MAX_PKT_INTERVAL;   //DEFAULT SETTING OF maxPktInterval
      expSendSize = expRcvSize = MIN_PKT_SIZE;
      passedSecondReception = passedSecondSend = FALSE;
      lastSendTime = lastRcvTime = 0;

      meanPELen = 0xff;
      isFirstTime = TRUE;

      /* miscl */
      toDecreaseLatency = FALSE;
      pending = directlyForwarded = FALSE;
      //meanPktTime = (uint32_t)-1;

      //minPELen = meanPELen;
    }  //atomic
    //reflect parameter value to ALR layer 
    //call CtpInfo.setAPSParams(expSendInterval, expSendSize);

  } //end of reInit()
  
  

  command error_t APSInfo.setMaxPktInterval(uint16_t value)   //please setMaxPktInterval after Init and reInit
   {
       
   	expSendInterval = expRcvInterval = maxPktInterval = value;
   	
   	call CtpInfo.setAPSParams(expSendInterval, expSendSize);
   
   	return SUCCESS;
   
   }//end of APSInfo.setMaxPktInterval


  command error_t StdControl.start() {

  //call SplitControl.start() ;

  if (call ALRControl.start() != SUCCESS)
  {
		call ALRControl.start();
  }
    
//	call RouteControl.setUpdateInterval(MintRoute_BEACON_INTERVAL);   //Caution!!!
//#ifdef TOSSIM
 //   call MacControl.isAutoAckEnabled() ;   //enable ACK


//    if ( call SplitControl.start() == FAIL)
//    {
//		return FAIL;
//    }                     //call CC2420Control.SetRFPower(TRANSMIT_POWER);  Modified By Jinhong
//#endif


	call Timer.startPeriodic(APS_TIMER_INTERVAL);   // Timer will be fired every APS_TIMER_INTERVAL, No return value for this function, Modified By Jinhong

	return SUCCESS;
  } //end of StdControl.start()


  command error_t StdControl.stop() {
    
	call Timer.stop();
    return call ALRControl.stop();

  } //end of StdControl.stop()



  /***********************************************************************
   * Internal functions
   ***********************************************************************/
  #include "APS_queuing.c"
  #include "APS_txrx.c"



  /***********************************************************************
   * Commands
   ***********************************************************************/

  /** 
   * Send a payload from an upper layer 
   */
  /*********************Xiaohui***************************/
 // command void *APSSend.getPayload[uint8_t id](message_t *msg, uint8_t len)		{	return call Send.getPayload(msg, len);	 }
   /*********************Xiaohui***************************/


  command error_t APSSend.send[uint8_t id](message_t *pMsg, uint16_t payloadLen, uint16_t maxLatency) {


	uint16_t slatency;
    uint32_t ETT;
	uint16_t HopCount;
	uint16_t i;
//	TOS_APSPE *thisPE;
//	thisPE = &(pMsg->data[0]);
	TOS_APSPE* msg =
     (TOS_APSPE*)call Packet.getPayload(pMsg, payloadLen);

	//am_addr_t &*parentptr = malloc(sizeof(am_addr_t));
	am_addr_t parentptr;
	TOS_APSPE *thisPE;
	
    /****** Caculating SL  ******/	
	ETT =  (call CtpInfo.getETT());
	if(ETT > 50000)
		; //Qiao
		  //call Leds.led0Toggle(); //Qiao
	HopCount =(call CtpInfo.getHopCount());
	if(maxLatency<=ETT)
	   slatency = 0;
	   else
	slatency = (maxLatency - ETT)/HopCount;
//
//	 /******************dEBUG*******************************/
//	 dbg("DBG_ERROR", "creating new PE! : %d\n", payloadlen); 
//   /******************************************************/
//	
//	/*******Creating a new APS payload element*********/
////	thisPE->length = payloadLen-ALR_OVERHEAD+PE_OVERHEAD;
//	thisPE->length = payloadLen;
//	thisPE->type = id;
//	thisPE->maxLatency = maxLatency;
//	thisPE->SLatency = slatency;
// /******************dEBUG*******************************/
//	 dbg("DBG_ERROR", "creating process!\n"); 
//   /******************************************************/
//
//	for(i=0;i<payloadLen ;i++)
//	{
//		thisPE->data[i] = pMsg->data[i];
//	}
//	
//	 /******************dEBUG*******************************/
//	 dbg("DBG_ERROR", "PE created!\n"); 
//   /******************************************************/
	
	
	//call Leds.led1Toggle();  //GREEN

    //dbg("DBG_TEMP", "busyQHead = %d, Q[%d].length = %d\n", busyQHead, busyQHead, Q[busyQHead].length);

    /*
    atomic {
      if (minPELen > payloadLen + PE_OVERHEAD)
	minPELen = payloadLen + PE_OVERHEAD;
    }
    */
      

    //check if connected
    if ((call CtpInfo.getParent(&parentptr)) != SUCCESS) {
    //  call Leds.led2Toggle(); //yellow
      dbg("DBG_ERROR", "warning: does not have parent yet\n");
      return FAIL;
    }
	      

	
    //put in packet queue
    if (enqueue(id, &(pMsg->data[0]),payloadLen, maxLatency, slatency) == SUCCESS) { //success    
      dbg("DBG_USR1", "enqueued successfully, to issue sendDone(...)\n"); 
	  //elementType = id;
     //signal APSSend.sendDone[id](pMsg, SUCCESS);
      //call Leds.yellowToggle();
      return SUCCESS;
    }
    else {                                                                                                                          //fail
      //no senddone, if fail: signal APSSend.sendDone[id](pMsg, FAIL);
     // call Leds.led1Toggle();
      return FAIL;
    }
  } //end of APSSend.send


  /* get statistics of APS */
//  command error_t APSControl.getStats(TOS_APS_Stats * stats) {
//
//    atomic {
//      stats->numReceptions = apsStats.numReceptions;
//      stats->numQueueOverflows = apsStats.numQueueOverflows;
//    }
//
//    return SUCCESS;
//  } //end of APSControl.getStats()
//
//
//  /* flush packet queue */
//  command void APSControl.flushQueue() {
//    atomic toFlushQueue = TRUE;
//  }




  /***********************************************************************
   * Events
   ***********************************************************************/

  /** 
   *------ Intercept packets from ALR layer ------ 
   */
  event bool APSIntercept.forward(message_t *pmsg, void* payload, uint8_t payloadLen)
  {
    
	
//  TOS_APSPayload * thisPayload;
//  TOS_APSPE * thisPE;
//  uint8_t PEOverallLen, i;
//  uint8_t * PEbase;
  
	
	dbg("DBG_USR1", "------>APS: the intermediate node is receiving packets\n");
 /*****************Xiaohui*****************/
	// signal Intercept.forward(pmsg, payload, payloadLen);
 /*****************~Xiaohui****************/
//	bool isBase;



    //call Leds.greenToggle();

    atomic apsStats.numReceptions++;

//    isBase = call CtpInfo.isBase();

//    if (call CtpInfo.isBase() == TRUE) //is the base station
//#ifndef DEMO_ONLY
 //     receive(pmsg, payload, payloadLen);
//#else 
 //     ;
//#endif
 //   else                                //otherwise

     dbg("DBG_ERROR", "thisPayload->length, = %d\n", payloadLen);
  /****************Not a base-node, forward the packet**********************************************************/    
  	 forward(pmsg, payload, payloadLen);
     

//  /****************Seperate the packet and Intercept for the user***************************************************/
//  
//  atomic {
//    thisPayload = (TOS_APSPayload *)(&(pmsg->data[ALR_OVERHEAD]));
//    PEOverallLen = thisPayload->length;
//    PEbase = &thisPayload->data[0];
//  }
//      dbg("DBG_ERROR", "PEOverallLen = %d\n", PEOverallLen);
//  //sanity check
//  if (PEOverallLen > MAX_APS_PE_LEN) {
//    dbg("DBG_ERROR", "error: corrupted thisPayload->length, = %d\n", PEOverallLen);
//    return;
//  }
//
//  //iterate over all payload elements: signal the reception
//  i = 0;
//  while (i < PEOverallLen) {
//    thisPE = (TOS_APSPE *)(&PEbase[i]);
//    if (thisPE->length > MAX_APS_PE_LEN - PE_OVERHEAD || thisPE->length < MIN_PAYLOAD_ELEMENT_LEN - PE_OVERHEAD) {
//      dbg("DBG_ERROR", "error: corrupted thisPE->length, = %d\n", thisPE->length);
//      break;
//    }
//    else 
      signal Intercept.forward(pmsg, payload, payloadLen);
//
//      i += (thisPE->length + PE_OVERHEAD);
//    //dbg(DBG_TEMP, "receive packet: PEOverallLen = %d,   lenSignaled = %d \n", PEOverallLen, i);
//  }

//#ifndef DEMO_ONLY
//    return FALSE; //so that this packet will not be forwarded by ALR layer
//#else 
//    if (TOS_NODE_ID == APS_BASE_STATION_ID) { //TOS_LOCAL_ADDRESS
//      call Leds.led2Toggle(); //red
//      return TRUE; //so that ALR layer will forward to UART
//    }
//    else
      return TRUE; //so that ALR layer will not forward to UART
//#endif
  } //end of Intercept.intercept

  /** 
   *------ Receive packets from ALR layer ------ 
   */


   event message_t*  ALRReceive.receive(message_t *pmsg, void* payload, uint8_t payloadLen)
  {
       TOS_APSPayload * thisPayload;
	   TOS_APSPE * thisPE;
//		uint8_t PEOverallLen, i;
	    uint8_t * PEbase;
  
        dbg("DBG_USR1", "------>APS: the base node is receiving packets\n");
   
        atomic apsStats.numReceptions++;
   
         atomic {
    			thisPayload = (TOS_APSPayload *)(&(pmsg->data[ALR_OVERHEAD]));
//    PEOverallLen = thisPayload->length;
    			PEbase = &(thisPayload->data[0]);
  				}

//  //sanity check
//  if (PEOverallLen > MAX_APS_PE_LEN) {
//    dbg("DBG_ERROR", "error: corrupted thisPayload->length, = %d\n", PEOverallLen);
//    return;
//  }

  //iterate over all payload elements: signal the reception
//  i = 0;
//  while (i < PEOverallLen) {
    thisPE = (TOS_APSPE *)(&PEbase[0]);
//    if (thisPE->length > MAX_APS_PE_LEN - PE_OVERHEAD || thisPE->length < MIN_PAYLOAD_ELEMENT_LEN - PE_OVERHEAD) {
//      dbg("DBG_ERROR", "error: corrupted thisPE->length, = %d\n", thisPE->length);
//      break;
//    }
//    else {
      signal Receive.receive[thisPE->type](pmsg, payload, payloadLen);
//       dbg("DBG_ERROR", "packet received. thisPE->length= %d, thisPE->type=%d, thisPE->maxLatency = %d, thisPE->SLatency = %d, thisPE->data =%x \n", thisPE->length,thisPE->type,thisPE->maxLatency,thisPE->SLatency, thisPE->data[0]);
//	}
//      i += (thisPE->length + PE_OVERHEAD);
//   }
   
   return pmsg;

  }

  

  /** 
   * ------ Timer fires ------ 
   */
  event void Timer.fired()
  {
    uint8_t i;
    uint32_t curTime, thisInterval;
	//bool EST;
	
    //am_addr_t parentptr = malloc(sizeof(am_addr_t));
	am_addr_t parentptr;
    TOS_APSPayload * testPayload;


	//dbg("DBG_ERROR", "Timer fied1!\n");


#ifdef SCHEDULE_PACKING
    uint32_t ett, ett0;
    uint16_t t_f;
    uint8_t s_f;
	
	/*if (lastTime == 0)
	{
		EST = TRUE;
		lastTime  = call Timer.getNow();
	}
	else
	{
		if ((call Timer.getNow() -lastTime) > 8000)
		{
			EST = TRUE;
			lastTime  = call Timer.getNow();
		}
		else
		{
			EST = FALSE;
		}
	}*/
#endif

#ifdef SL_PACKING    
	uint16_t thisSLatency;
	uint16_t tempSL;
	if (Q[busyQHead].SLatency <= APS_TIMER_INTERVAL)
		thisSLatency = 0;
	else 
		thisSLatency=Q[busyQHead].SLatency-APS_TIMER_INTERVAL;
	decreaseAllSLatency(APS_TIMER_INTERVAL);	
#endif
   //dbg("DBG_ERROR", "Timer fied2!\n");


// dbg("info", "TOSH_DATA_LENGTH: %d\n", TOSH_DATA_LENGTH);
#ifdef TOSSIM
    curTime = (call SysTime.get()); // TICKS_PER_MILLISECOND;
#else
    curTime = (call LocalTime.get()); // TICKS_PER_MILLISECOND;
#endif
    //self-stabilization
    atomic { 
      //variable "pending"
      	if (pending) { 
			if (curTime > lastSendTime  
                     &&(curTime - lastSendTime) > MAX_PKT_TIME_DEVIATION_RATIO * meanPktTime //modified by jinhong 
                    ) {
	 				 dbg("DBG_ERROR", "warning: pending hanging in APS\n");
	  					pending = FALSE; 
	  						if (directlyForwarded) 
	    						directlyForwarded = FALSE;
						} 
      		} 

      //variable "toFlushQueue"
      	if (toFlushQueue && busyQHead >= QUEUE_SIZE)
					toFlushQueue = FALSE;
    } //atomic


#ifdef SCHEDULE_PACKING
    //adjust MaxLatency
    if (busyQHead < QUEUE_SIZE && toDecreaseLatency
         // && Q[busyQHead].maxLatency <= MAX_PKT_INTERVAL  //simulate NON-INTELLIGENT PACKING
        )
      decreaseAllMaxLatency(APS_TIMER_INTERVAL);     
#endif

    //check whether there is packet in queue, or if there is a parent
	if (busyQHead >= QUEUE_SIZE)
      goto done;
    else if  ((call CtpInfo.getParent(&parentptr)) != SUCCESS ) {
      dbg("DBG_ERROR", "error: packet buffered, but no parent ----> numBusyBuffers =%d\n", numBusyBuffers);
     // call Leds.led0Toggle(); //red
     // call Leds.led1Toggle(); //green 
	//  free(parentptr);
      goto done;
    }
/*                    //modified by jinhong, no simulating in this experiment
    else if (Q[busyQHead].maxLatency > MAX_PKT_INTERVAL) { //simulate NON-INTELLIGENT PACKING
#ifdef SCHEDULE_PACKING 
      ett0 = (call CtpInfo.getETT0());
#endif
      dbg("DBG_USR1", "simulate NON-INTELLIGENT packing\n");
      goto transmit;
    }
*/
#ifdef SL_PACKING         //by jinhong
	if (thisSLatency >0)
		goto done;
		else
	    goto transmit;
#endif

#ifdef SCHEDULE_PACKING 
    //check whether to flush queue
    if (toFlushQueue) {
      ett0 = (call CtpInfo.getETT0());
	  if(ett0==0)
			; //Qiao
		  //call Leds.led1Toggle(); //Qiao
      goto transmit;
    }
    //get ETT & ETT0
    ett = (call CtpInfo.getETT());
		if(ett > 50000)
			; //Qiao
		  //call Leds.led0Toggle(); //Qiao
    ett0 = (call CtpInfo.getETT0());
	 if(ett0==0)
		;//Qiao
		  //call Leds.led1Toggle();//Qiao
    if (ett >= TIME_INVALID || ett0 >= TIME_INVALID) 
      dbg("DBG_TEMP", "error: has route, but ETT or ETT0 >= TIME_INVALID; ETT = %d,      ETT0 = %d \n", ett, ett0); 
//    ett /= TICKS_PER_MILLISECOND;
//    ett0 /= TICKS_PER_MILLISECOND;
    /*
    ett >>= ETT_SCALE_FACTOR;
    ett0 >>= ETT_SCALE_FACTOR;
    */

    /* Check whether some packet that is not fully packed has ~0 flextime;
     * if yes, put it in the head if the current head has > APS_TIMER_INTERVAL flextime, and not waiting for sendDone. */
    if (busySpareQHead < QUEUE_SIZE && !pending && ett + APS_TIMER_INTERVAL < Q[busyQHead].maxLatency)
      pickUrgentPkt(ett);

    /* Hold the head packet if 
     * (0) # of busy queue buffer is below certain threshold
     * (1) the flextime > 0, and
     * (2) it is not fully packed, and 
     * (3) it is beneficial to hold it. */
    if (Q[busyQHead].maxLatency > ett + APS_TIMER_INTERVAL)
      t_f = Q[busyQHead].maxLatency - (ett + APS_TIMER_INTERVAL);
    else
      t_f = 0;
    dbg("DBG_TEMP", "t_f = %d,   ETT = %d,   ETT0 = %d\n", t_f, ett,ett0);
    s_f = MAX_APS_PAYLOAD_LEN - Q[busyQHead].length;
    if (numBusyBuffers <= WAITING_BUFFERS_THRESHOLD &&  
         t_f > 0 && 
         s_f >= meanPELen && 
#ifdef  TWOHOP
		isBeneficialToHold2Hop(t_f,s_f)
#else
         isBeneficialToHold(t_f, s_f)
#endif
       )
	  {
	 // call Leds.led0Toggle();  //red light
	  testPayload=(TOS_APSPayload *)(&Q[busyQHead].msg.data[0]);
	  dbg("Jinhong", "Good to hold!!!APS Packet Holding information: Q[busyQHead].length =%d   , real len: %d\n", Q[busyQHead].length,testPayload->length);
      goto done;
	  }
//	  else
//		call Leds.led2Toggle();  //blue light

#endif   //SCHEDULE_PACKING


    /* Otherwise, try to transmit the head packet of busyQ */
    transmit:
    if (!pending && !qLock) { //lower layer is idle, and there is packet to be transmitted
      dbg("DBG_ERROR", "transmit start!\n");
      atomic {
	pending = TRUE;
	qLock = TRUE;
      }
#ifdef SCHEDULE_PACKING
      //adjust maxLatency
      if (Q[busyQHead].maxLatency <= maxPktInterval)
	decreasePktMaxLatency(busyQHead, ett0);
#endif
      //send it
      if ((call Send.send(&Q[busyQHead].msg, Q[busyQHead].length)) != SUCCESS) { //failure
		/*if ((call Send.send(&Q[busyQHead].msg, Q[busyQHead].length)) == FAIL){
			call Leds.led2Toggle() ;
		}
		if ((call Send.send(&Q[busyQHead].msg, Q[busyQHead].length)) == EBUSY){
			call Leds.led1Toggle() ;
		}*/
	dbg("DBG_ERROR", "APS Packet sending error: Q[busyQHead].length =%d, and is > MAX_APS_PAYLOAD_LEN\n", Q[busyQHead].length);
#ifdef SCHEDULE_PACKING
	if (Q[busyQHead].maxLatency <= maxPktInterval)
	  increasePktMaxLatency(busyQHead, ett0);
#endif

   	//miscl.
	atomic {
	  pending = FALSE;
	  qLock = FALSE;
	}
	//call Leds.redToggle();
	dbg("DBG_ERROR", "warning: failed to send packet to ALR layer\n");
	if (Q[busyQHead].length > MAX_APS_PAYLOAD_LEN)
	  dbg("DBG_ERROR", "error: Q[busyQHead].length =%d, and is > MAX_APS_PAYLOAD_LEN , real len: %d \n    ", Q[busyQHead].length, sizeof(Q[busyQHead]));
      }
      else {                                              //success       
	testPayload=(TOS_APSPayload *)(&Q[busyQHead].msg.data[0]);
	dbg("Jinhong", "APS Packet sending information: Q[busyQHead].length =%d   , real len: %d\n", Q[busyQHead].length,testPayload->length);

	atomic{
	  i = busyQHead;
	  if (i >= QUEUE_SIZE) {
	    dbg("DBG_ERROR", "warning: received sendDone() when busyQHead = %d\n", busyQHead);
	    goto done2; 
	  }
	  /*
	  else if (msg != &Q[busyQHead].msg) {
	    dbg("DBG_ERROR", "warning: receive a sendDone() NOT pointing to Q[busyQHead].msg\n");
	    goto done2;
	  }
	  */
	  //remove the buffer from busyQ and update pointers
	  if (numBusyBuffers > 0)
	    {
	      numBusyBuffers--;
	    }
	  else 
	    dbg("DBG_ERROR", "error: receive sendDone when numBusyBuffers (=%d)\n", numBusyBuffers);
	  if (busySpareQHead == busyQHead)
	    busySpareQHead = Q[busyQHead].next;
	  busyQHead = Q[busyQHead].next;
	  if (busyQHead >= QUEUE_SIZE)
	    busyQTail = QUEUE_SIZE;
	  else 
	    Q[busyQHead].prev = QUEUE_SIZE;
	  //reset certain buffer parameters
	  Q[i].length = Q[i].maxLatency = 0;
	  Q[i].prev = Q[i].next = QUEUE_SIZE;
	  //hongwei new add
	  //thisPayload = (TOS_APSPayload *)(&(Q[i].msg.data[ALR_OVERHEAD]));
	  //thisPayload->length = 0;  
	  //append the buffer in the freeQ
	  if (freeQTail >= QUEUE_SIZE) //no free buffer before
	    freeQHead = freeQTail = i;
	  else {
	    Q[freeQTail].next = i;
	    Q[i].prev = freeQTail;
	    freeQTail = i;
	  }
	
	done2:
	  qLock = FALSE;
	}
	/*********************Xiaohui***************************/
	dbg("DBG_ERROR", "APS Packet sent.\n");
	/*********************Xiaohui***************************/ 		
	
	/* for parameter estimation: transmission */
	//EWMA style estimation

	atomic {
	  		if (lastSendTime ==0) {//the first time to receive an packet to process
	    			lastSendTime = curTime;
	    			expSendSize = Q[busyQHead].length;
	  			}
	  		else {                                //otherwise
	    		//interval
	    			thisInterval = curTime - lastSendTime;
	    			if (thisInterval < maxPktInterval) {//"reasonable"
	      					if (!passedSecondSend) {
									passedSecondSend = TRUE;
									expSendInterval = thisInterval;
	      						}
	      						else
								expSendInterval = (expSendInterval - (expSendInterval >> compPastW)) + (thisInterval >> compPastW);	
	    				}
	    	lastSendTime = curTime;
	    //size
	   		 expSendSize = (expSendSize - (expSendSize >> compPastW)) + (Q[busyQHead].length >> compPastW);
	  			}
		}//atomic
	//reflect to ALR layer
	
	call CtpInfo.setAPSParams(expSendInterval, expSendSize);
	
	//call Leds.greenToggle();
      }
    }

  done:
    ;
    //queue sanity checking
    /*
    if (!queueSanity()) { 
      call Leds.redToggle(); 
      call Leds.yellowToggle(); 
      call Leds.greenToggle(); 
    } 
    */ 
    //return SUCCESS;    //void function
  } //end of Timer.fired()


  /**
   * ------ sendDone ------ 
   */
  event void Send.sendDone(message_t *pmsg, error_t success)
  {
    uint8_t i;
    uint32_t curTime;
	    TOS_APSPayload * thisPayload;

#ifdef TOSSIM
    curTime = (call SysTime.get());// TICKS_PER_MILLISECOND;
#else
    curTime = (call LocalTime.get()); // TICKS_PER_MILLISECOND;
#endif

	//signal APSSend.sendDone[elementType](pmsg, success);   //the parameter has been set up to TOS_NODE_ID which is different from the  payloadElement->type

    //if (pending)
     // call Leds.led1Toggle();  //red
   
	/*****************Sent information for upper layer*************************/
  // signal APSInfo.sendSignal(pmsg, success);     //Doing this in Retranx

    /*
    if (success)
      call Leds.greenToggle();
    else
      call Leds.redToggle(); 
    */
    if (success!=SUCCESS)
      dbg("DBG_ERROR", "sendDone: the previous transmission to ALR failed\n"); //reliability should be controlled at a layer similar to QueuedSend

    atomic {
      pending = FALSE;
      if (curTime > lastSendTime) { //sanity check
	if (meanPktTime == (uint32_t)-1)
	  meanPktTime = curTime - lastSendTime;
	else 
	  meanPktTime = meanPktTime - (meanPktTime >> compPastW) + ((curTime - lastSendTime) >> compPastW);
//	call RouteControl.setPktTime(meanPktTime);  //Caution Modified By Jinhong Xu
	dbg("DBG_TEMP", "meanPktTime = %d ticks\n", meanPktTime);///TICKS_PER_MILLISECOND);
      }

      if (directlyForwarded) { //if it is for a directly forwarded packet
	directlyForwarded = FALSE;
      }
    }//atomic

#ifdef DEBUG_APS_ONLY
    if (!queueSanity())
      dbg("DBG_ERROR", "APS ---> Send.sendDone(): QUEUE ERROR\n");
#endif

    // return SUCCESS; no return value for Send.SendDone() in tinyOS 2.x
  } //end of Send.sendDone()

/**************************************************************
                               Retransmition Number
**************************************************************/

	event  void Retranx.sendRetranxDone(message_t* msg, error_t error, uint8_t retranxNum){
          
				signal APSInfo.sendSignal(msg, error, retranxNum); 
               
		}








  /***********************************************************************
   * Default event handlers for the events signalled in this component
   ***********************************************************************/

 default event error_t APSSend.sendDone[uint8_t id](message_t *pMsg, error_t success) {
   return SUCCESS;
 }   //uint8




 default event message_t* Receive.receive[uint8_t id](message_t *msg, void* payload, uint8_t payloadLen) {   //uint8
    
        return msg;

 }

 default event error_t APSInfo.sendSignal(message_t *, error_t, uint8_t){
         
		 return SUCCESS;
         
  }
 

#ifndef TOSSIM
// event void SplitControl.startDone(error_t error){
// 
// } 
//
// event void SplitControl.stopDone(error_t error){
// 
// } 
#endif
   /********************************************************************
         Rounting Commands for upper layer
   ***********************************************************************/
   command error_t APSInfo.setRoot(){
	   return (call RootControl.setRoot());
   }
  
   command am_addr_t APSInfo.getParent(){
	   am_addr_t result;
      if( (call CtpInfo.getParent(&result))!=SUCCESS)
        return ROUTE_INVALID;
		else
        return result;
   }
  
  command uint16_t APSInfo.getEtx(){
		uint16_t etx;
        if((call CtpInfo.getEtx(&etx))!=SUCCESS)
        return ROUTE_INVALID;
        else
		return etx;
  }
  
  command uint16_t APSInfo.getETX0(){
		uint16_t etx0;
		etx0 = (call CtpInfo.getETX0());
		if(etx0 == ROUTE_INVALID)
			return ROUTE_INVALID;
		else
			return etx0;
  }
  
  command uint16_t APSInfo.getHopCount(){
        uint16_t HopCount;
        HopCount = (call CtpInfo.getHopCount());
        if(HopCount == HOPCOUNT_INVALID)
        	return HOPCOUNT_INVALID;
        else
			return HopCount;
  }
  
  command uint32_t APSInfo.getETT0(){
  		uint32_t ETT0;
  		ETT0 = (call CtpInfo.getETT0());
  		if(ETT0 == TIME_INVALID)		//xh
  		return TIME_INVALID;
  		else
        return	ETT0;
  }
  
  command uint32_t APSInfo.getETT(){
  		uint32_t ETT;
  		ETT = (call CtpInfo.getETT());
  		if(ETT == TIME_INVALID)
  		return TIME_INVALID;
  		else
        return	ETT;
  }


default event bool Intercept.forward(message_t* msg, void* payload, uint8_t len){
         return TRUE;
 }

}
