/*
 * Configuration for application-driven packet scheduling (APS)
 *
 * @author: Hongwei zhang
 *                 zhangho@cse.ohio-state.edu
 *
 * @modified: July 29, 2005
 */



#include "APS.h"

//#define TOSSIM


configuration APSAppC{
  
  provides {
    interface StdControl;
	interface Init;
    interface APSSend[uint8_t id]; //QoS aware Send interface: for data transmission
    interface Receive[uint8_t id];    //for data reception
//    interface APSControl;
	interface APSInfo;
	interface Intercept;
  }  
} 
implementation {
  components    APSC, LedsC as Leds;
//#ifdef TOSSIM
  components LocalTimeMilliC;
//#endif
  components  ActiveMessageC;//

  components  CollectionC  as ALR, new CollectionSenderC(AM_APS_PKT) as Sender;    // new AMReceiverC(AM_APS_PKT) as Comm;
  components  new TimerMilliC() as TimerC;
  StdControl = APSC.StdControl;
  APSSend = APSC.APSSend;
  Receive = APSC.Receive;
//  APSControl = APSC.APSControl;
  Init = APSC.Init;
  APSInfo = APSC.APSInfo;
  Intercept = APSC.Intercept;

 // MainC.Boot -> APS;
//#ifdef TOSSIM
  APSC.Packet -> ALR;  //ActiveMessageC   ALR
//#endif
  APSC.ALRControl -> ALR.StdControl;
  APSC.Send ->Sender.Send; //APS.Send -> ALR.Send[AM_APS_PKT];
  APSC.Retranx-> ALR.Retranx;
  APSC.APSIntercept -> ALR.Intercept[AM_APS_PKT];
  APSC.CtpInfo -> ALR.CtpInfo;
  APSC.RootControl -> ALR.RootControl;
  APSC. ALRReceive -> ALR.Receive[AM_APS_PKT];

//ALR.Receive[AM_APS_PKT]-> Comm.Receive[AM_APS_PKT];

//#ifdef TOSSIM
  APSC.SysTime -> LocalTimeMilliC.LocalTime;
//#else
  APSC.LocalTime -> LocalTimeMilliC.LocalTime;
  //APS.MacControl -> CC2420ControlC.CC2420Config;
//  APSC.SplitControl -> ActiveMessageC.SplitControl;
//#endif

/*********************Xiaohui***************************/
//APSC.SplitControl -> ActiveMessageC.SplitControl;
/*********************Xiaohui***************************/

  //APS.TimerControl -> TimerC.Timer;
  APSC.Timer -> TimerC.Timer; 
  APSC.Leds -> Leds;  
}
