/*
 * @ author: Xiaohui Liu (whulxh@gmail.com)
 * @ updated: 07/02/2012 
 * @ description: store all active links
 */
#include "Util.h"

module UtilC {
 	provides {
		interface Util;
	}
}

implementation {
//#warning a few links to debug
#ifndef HETER_TX_POWER
// neteye
// 19 links: 5 * 5
//link_t activeLinks[] = {{12, 29}, {13, 14}, {14, 15}, {26, 28}, {28, 13}, {30, 15}, {42, 11}, {43, 44}, {57, 42}, {58, 11}, {60, 45}, {71, 72}, {72, 71}, {73, 44}};	// 14 links
//link_t activeLinks[] = {{11, 28}, {12, 29}, {13, 14}, {14, 15}, {26, 28}, {28, 13}, {30, 15}, {42, 11}, {43, 44}, {44, 45}, {45, 44}, {56, 28}, {57, 42}, {58, 11}, {60, 45}, {71, 72}, {72, 71}, {73, 44}}; //, {75, 43}}; // deteriorate and become very unreliable
// some links removed to reduce MAX_INCIDENT_LINK_SIZE from 5 to 4
// removed since it is dead after groundtruth measurement
//link_t activeLinks[] = {{1, 16}, {2, 47}, {3, 47}, {5, 21}, {7, 23}, {8, 39}, {10, 12}, {11, 28}, {12, 29}, {13, 14}, {14, 15}, {16, 46}, {17, 33}, {18, 17}, {19, 3}, {20, 22}, {21, 7}, {22, 38}, {23, 8}, {24, 23}, {26, 28}, {28, 13}, {29, 10}, {30, 15}, {31, 46}, {32, 17}, {34, 36}, {35, 51}, {36, 22}, {37, 36}, {38, 54}, {39, 8}, {40, 10}, {42, 11}, {43, 44}, {44, 45}, {45, 44}, {46, 32}, {47, 48}, {48, 47}, {49, 124}, {50, 35}, {51, 35}, {52, 51}, {54, 53}, {55, 26}, {56, 28}, {57, 42}, {58, 11}, {60, 45}, {61, 62}, {63, 78}, {65, 66}, {66, 37}, {67, 96}, {68, 83}, {69, 86}, {70, 101}, {71, 72}, {72, 71}, {73, 44}, {75, 43}, {76, 62}, {77, 114}, {79, 95}, {80, 82}, {81, 79}, {83, 124}, {84, 101}, {85, 86}, {86, 71}, {87, 101}, {88, 104}, {89, 105}, {90, 89}, {91, 115}, {93, 92}, {94, 96}, {95, 97}, {96, 65}, {97, 95}, {99, 127}, {100, 105}, {101, 89}, {103, 88}, {104, 88}, {105, 103}, {106, 110}, {108, 113}, {110, 111}, {111, 110}, {113, 108}, {115, 91}, {118, 116}, {121, 92}, {122, 125}, {124, 83}, {125, 124}, {127, 125}, {128, 105}};
#ifndef LINK_SET_PDR_99
#ifndef MULTIHOP
// olama
//#warning 16 links: 5 * 5
//link_t activeLinks[] = {{13, 11}, {14, 13}, {26, 23}, {27, 40}, {28, 26}, {29, 28}, {41, 29}, {42, 43}, {43, 30}, {44, 45}, {56, 60}, {57, 42}, {58, 57}, {71, 56}, {72, 71}, {73, 72}};
// 14 links to test SCREAM
//link_t activeLinks[] = {{13, 11}, {14, 13}, {26, 23}, {27, 40}, {28, 26}, {29, 28}, {41, 29}, {42, 43}, {43, 30}, {44, 45}, {56, 60}, {57, 42}, {58, 57}, {71, 56}};
link_t activeLinks[] = {{1, 2}, {2, 1}, {3, 5}, {4, 7}, {5, 3}, {6, 7}, {8, 9}, {9, 8}, {10, 27}, {11, 10}, {13, 11}, {14, 13}, {15, 14}, {16, 17}, {17, 6}, {18, 16}, {19, 18}, {20, 19}, {21, 4}, {22, 20}, {23, 22}, {26, 23}, {27, 40}, {28, 26}, {29, 28}, {30, 15}, {31, 32}, {32, 31}, {33, 34}, {34, 21}, {35, 49}, {38, 39}, {39, 38}, {40, 41}, {41, 29}, {42, 43}, {43, 30}, {44, 45}, {45, 44}, {46, 47}, {47, 33}, {48, 46}, {49, 35}, {50, 66}, {51, 50}, {52, 51}, {53, 48}, {54, 53}, {55, 54}, {56, 60}, {57, 42}, {58, 57}, {60, 58}, {61, 62}, {62, 52}, {63, 77}, {65, 66}, {67, 65}, {68, 67}, {69, 55}, {70, 69}, {71, 56}, {72, 71}, {73, 72}, {75, 73}, {76, 61}, {77, 63}, {78, 79}, {79, 78}, {80, 81}, {81, 80}, {83, 68}, {91, 93}, {92, 76}, {93, 92}, {94, 95}, {95, 96}, {96, 97}, {99, 97}, {100, 99}, {101, 86}, {103, 88}, {104, 88}, {105, 85}, {108, 91}, {110, 117}, {111, 116}, {113, 107}, {114, 108}, {115, 117}, {116, 110}, {118, 119}, {119, 118}, {122, 103}, {123, 84}, {124, 70}, {125, 124}, {126, 127}, {127, 84}, {129, 126}};

//#warning Indriya
//// w/ olama constraint MAX_INCIDENT_LINK_SIZE = 2 and node id <= 130 
//// 57 links to compare concurrency against iOrder
//link_t activeLinks[] = {{1, 3}, {2, 3}, {6, 1}, {8, 15}, {10, 2}, {11, 6}, {12, 10}, {14, 22}, {15, 5}, {16, 17}, {17, 11}, {19, 22}, {20, 4}, {40, 42}, {41, 40}, {42, 44}, {44, 41}, {45, 46}, {46, 45}, {47, 54}, {51, 53}, {52, 57}, {53, 51}, {54, 47}, {57, 52}, {59, 55}, {63, 64}, {64, 63}, {65, 66}, {66, 65}, {67, 72}, {68, 67}, {69, 78}, {73, 79}, {74, 76}, {75, 82}, {76, 74}, {77, 79}, {78, 69}, {82, 75}, {83, 73}, {115, 117}, {116, 117}, {118, 115}, {119, 121}, {120, 122}, {121, 118}, {122, 120}, {123, 126}, {126, 129}, {129, 116}};
// 59 links in total
//link_t activeLinks[] = {{1, 3}, {2, 10}, {3, 1}, {4, 8}, {5, 15}, {6, 11}, {7, 26}, {8, 4}, {10, 2}, {11, 6}, {12, 18}, {13, 37}, {14, 19}, {15, 5}, {16, 17}, {17, 16}, {19, 14}, {20, 7}, {25, 28}, {27, 31}, {28, 25}, {31, 24}, {32, 34}, {34, 32}, {36, 38}, {38, 36}, {40, 27}, {41, 40}, {42, 41}, {43, 45}, {45, 42}, {48, 43}, {50, 54}, {52, 54}, {53, 58}, {55, 48}, {56, 50}, {58, 53}, {59, 56}, {63, 64}, {64, 63}, {65, 66}, {66, 65}, {72, 78}, {73, 75}, {74, 81}, {75, 73}, {76, 78}, {81, 74}, {82, 72}, {83, 85}, {85, 83}, {115, 116}, {116, 115}, {117, 118}, {118, 117}, {119, 121}, {120, 122}, {122, 120}};
// w/o olama
//link_t activeLinks[] = {{1, 3}, {2, 10}, {3, 1}, {4, 8}, {5, 11}, {6, 15}, {7, 26}, {8, 4}, {9, 8}, {10, 18}, {11, 5}, {12, 10}, {13, 37}, {14, 17}, {15, 6}, {16, 17}, {17, 16}, {18, 10}, {20, 15}, {21, 11}, {22, 19}, {25, 28}, {26, 7}, {27, 24}, {30, 27}, {36, 26}, {37, 62}, {38, 36}, {39, 38}, {40, 45}, {41, 45}, {42, 45}, {43, 45}, {46, 52}, {47, 56}, {48, 55}, {50, 54}, {52, 41}, {53, 59}, {54, 50}, {55, 48}, {57, 61}, {59, 53}, {60, 62}, {61, 57}, {62, 60}, {63, 71}, {64, 68}, {65, 67}, {66, 68}, {67, 65}, {68, 64}, {69, 78}, {71, 63}, {72, 64}, {73, 79}, {74, 66}, {75, 82}, {76, 66}, {77, 79}, {78, 69}, {79, 77}, {82, 75}, {83, 74}, {84, 77}, {87, 91}, {88, 100}, {89, 90}, {90, 89}, {91, 92}, {92, 91}, {93, 94}, {94, 93}, {96, 109}, {97, 88}, {98, 100}, {99, 108}, {100, 107}, {101, 90}, {102, 103}, {103, 102}, {104, 87}, {105, 106}, {106, 105}, {107, 100}, {109, 97}, {110, 104}, {111, 114}, {113, 104}, {115, 117}, {116, 130}, {117, 118}, {118, 117}, {120, 122}, {122, 120}, {123, 130}, {124, 131}, {125, 135}, {126, 130}, {127, 131}};

#else	// MULTIHOP
//#ifdef MULTIHOP
//// collection tree: root is not a source and thus no outgoing link in activeLinks
//// long-term reliable links
////SM_SIZE = 46,	//128
////MAX_ACTIVE_LINK_SIZE = 45,	//100,
////MAX_INCIDENT_LINK_SIZE = 4, //4,
//link_t activeLinks[] = {{11, 15}, {12, 11}};
link_t activeLinks[] = {{2, 106}, {3, 20}, {5, 22}, {7, 23}, {11, 15}, {12, 11}, {17, 51}, {18, 3}, {20, 50}, {22, 23}, {23, 38}, {24, 23}, {30, 15}, {35, 50}, {36, 22}, {37, 7}, {38, 40}, {40, 11}, {44, 15}, {45, 30}, {50, 54}, {51, 50}, {53, 54}, {54, 40}, {67, 83}, {69, 11}, {77, 78}, {78, 82}, {82, 67}, {83, 54}, {84, 53}, {86, 44}, {87, 86}, {96, 20}, {100, 83}, {101, 40}, {106, 110}, {108, 77}, {110, 112}, {112, 96}, {114, 78}, {116, 110}, {122, 53}, {123, 53}, {129, 100}};
#endif

#else // LINK_SET_PDR_99
#warning olama with >= 99% pdr consistently
//link_t activeLinks[] = {{7, 23}, {8, 23}, {9, 39}, {11, 13}, {13, 14}, {14, 13}, {17, 33}, {20, 35}, {21, 7}, {23, 7}, {26, 42}, {27, 42}, {28, 14}, {29, 42}, {34, 35}, {36, 35}, {40, 39}, {41, 9}, {44, 28}, {45, 44}, {47, 63}, {50, 51}, {53, 52}, {54, 53}, {56, 43}, {57, 43}, {59, 43}, {62, 63}, {64, 33}, {65, 52}, {71, 72}, {76, 114}, {77, 63}, {80, 81}, {83, 39}, {84, 85}, {85, 70}, {86, 70}, {88, 103}, {89, 88}, {90, 104}, {91, 92}, {93, 78}, {94, 92}, {95, 96}, {99, 100}, {100, 70}, {101, 103}, {103, 88}, {104, 89}, {105, 104}, {108, 114}, {114, 76}, {115, 91}, {116, 92}, {118, 121}, {119, 121}, {122, 124}, {124, 125}, {125, 124}, {126, 127}, {127, 99}, {128, 105}}; // only 49 out of these 63 tx
// 49 links
link_t activeLinks[] = {{7, 23}, {8, 23}, {9, 39}, {11, 13}, {13, 14}, {17, 33}, {20, 35}, {21, 7}, {26, 42}, {27, 42}, {34, 35}, {40, 39}, {41, 9}, {44, 28}, {45, 44}, {47, 63}, {50, 51}, {53, 52}, {54, 53}, {56, 43}, {57, 43}, {62, 63}, {64, 33}, {65, 52}, {71, 72}, {76, 114}, {80, 81}, {84, 85}, {85, 70}, {86, 70}, {88, 103}, {89, 88}, {90, 104}, {91, 92}, {93, 78}, {94, 92}, {95, 96}, {99, 100}, {101, 103}, {104, 89}, {108, 114}, {115, 91}, {118, 121}, {119, 121}, {122, 124}, {124, 125}, {126, 127}, {127, 99}, {128, 105}};
#endif


#else
// neteye
// TODO: save space by removing receiver since at most one outgoing link
// olama
link_t activeLinks[] = {{1, 2, 3}, {2, 1, 3}, {3, 5, 4}, {4, 7, 4}, {5, 3, 4}, {6, 7, 3}, {8, 9, 3}, {9, 8, 3}, {10, 27, 3}, {11, 10, 3}, {13, 11, 3}, {14, 13, 3}, {15, 14, 3}, {16, 17, 3}, {17, 6, 4}, {18, 16, 3}, {19, 18, 3}, {20, 19, 4}, {21, 4, 8}, {22, 20, 3}, {23, 22, 4}, {26, 23, 6}, {27, 40, 4}, {28, 26, 4}, {29, 28, 3}, {30, 15, 3}, {31, 32, 3}, {32, 31, 3}, {33, 34, 3}, {34, 21, 3}, {35, 49, 4}, {38, 39, 3}, {39, 38, 3}, {40, 41, 3}, {41, 29, 3}, {42, 43, 3}, {43, 30, 3}, {44, 45, 3}, {45, 44, 3}, {46, 47, 3}, {47, 33, 3}, {48, 46, 3}, {49, 35, 4}, {50, 66, 3}, {51, 50, 3}, {52, 51, 3}, {53, 48, 4}, {54, 53, 3}, {55, 54, 3}, {56, 60, 3}, {57, 42, 3}, {58, 57, 3}, {60, 58, 3}, {61, 62, 3}, {62, 52, 4}, {63, 77, 3}, {65, 66, 3}, {67, 65, 3}, {68, 67, 3}, {69, 55, 3}, {70, 69, 6}, {71, 56, 4}, {72, 71, 3}, {73, 72, 4}, {75, 73, 5}, {76, 61, 3}, {77, 63, 3}, {78, 79, 5}, {79, 78, 4}, {80, 81, 3}, {81, 80, 3}, {83, 68, 3}, {91, 93, 3}, {92, 76, 3}, {93, 92, 3}, {94, 95, 3}, {95, 96, 3}, {96, 97, 3}, {99, 97, 3}, {100, 99, 3}, {101, 86, 3}, {103, 88, 3}, {104, 88, 3}, {105, 85, 3}, {108, 91, 3}, {110, 117, 3}, {111, 116, 3}, {113, 107, 3}, {114, 108, 3}, {115, 117, 4}, {116, 110, 4}, {118, 119, 3}, {119, 118, 3}, {122, 103, 3}, {123, 84, 3}, {124, 70, 4}, {125, 124, 3}, {126, 127, 3}, {127, 84, 3}, {129, 126, 3}};
// lama
//link_t activeLinks[] = {{2, 3, 4}, {3, 2, 4}, {4, 19, 9}, {5, 3, 5}, {6, 5, 8}, {7, 6, 3}, {8, 7, 10}, {9, 22, 3}, {10, 25, 3}, {11, 12, 3}, {15, 14, 3}, {16, 17, 4}, {17, 2, 10}, {18, 3, 3}, {19, 6, 9}, {20, 5, 7}, {21, 20, 3}, {22, 6, 5}, {23, 8, 3}, {24, 39, 3}, {25, 10, 3}, {27, 10, 5}, {29, 13, 4}, {30, 29, 3}, {31, 16, 3}, {32, 17, 3}, {34, 6, 6}, {35, 5, 6}, {36, 20, 3}, {37, 36, 3}, {38, 24, 3}, {39, 9, 3}, {40, 54, 4}, {41, 42, 21}, {42, 12, 3}, {43, 27, 23}, {44, 11, 5}, {45, 11, 5}, {48, 34, 4}, {49, 34, 3}, {50, 35, 3}, {51, 37, 3}, {52, 20, 6}, {53, 54, 3}, {54, 39, 4}, {55, 10, 5}, {56, 40, 8}, {57, 40, 3}, {58, 57, 3}, {60, 44, 3}, {62, 47, 3}, {63, 49, 5}, {64, 49, 3}, {65, 7, 11}, {66, 65, 3}, {68, 82, 5}, {69, 52, 3}, {70, 40, 6}, {71, 57, 3}, {73, 60, 5}, {74, 44, 3}, {75, 44, 8}, {76, 114, 3}, {77, 76, 3}, {79, 20, 11}, {80, 81, 3}, {81, 80, 3}, {82, 81, 3}, {83, 99, 7}, {84, 69, 3}, {85, 56, 11}, {86, 71, 3}, {88, 103, 3}, {89, 104, 3}, {90, 74, 3}, {93, 63, 31}, {94, 49, 3}, {97, 82, 5}, {99, 83, 6}, {100, 84, 5}, {101, 71, 15}, {103, 74, 3}, {104, 89, 3}, {105, 86, 31}, {111, 116, 5}, {113, 108, 3}, {114, 76, 3}, {115, 114, 3}, {116, 110, 3}, {117, 110, 3}, {118, 114, 12}, {120, 79, 3}, {121, 120, 3}, {122, 99, 23}, {123, 122, 3}, {124, 86, 11}, {125, 124, 3}, {126, 100, 16}, {127, 82, 11}, {128, 99, 3}};
#endif

#ifdef SET_PDR_REQ_BY_LINK
#warning max node id 130
// save space: node w/o outgoing link with pdr req of 10%
//uint8_t link_pdr_req_vector[] = {98, 97, 54, 26, 84, 56, 10, 98, 99, 77, 92, 10, 74, 99, 98, 94, 26, 78, 97, 94, 10, 98, 58, 10, 10, 54, 74, 24, 100, 99, 98, 97, 46, 98, 10, 10, 10, 72, 86, 78, 57, 86, 98, 92, 99, 92, 69, 70, 69, 98, 98, 92, 75, 99, 62, 10, 71, 89, 10, 10, 77, 16, 97, 10, 100, 10, 99, 81, 92, 10, 65, 97, 10, 10, 38, 91, 98, 29, 89, 98, 99, 10, 97, 10, 10, 10, 10, 10, 10, 10, 81, 82, 96, 92, 98, 74, 10, 10, 59, 94, 70, 10, 99, 65, 35, 10, 10, 80, 10, 87, 96, 10, 90, 95, 45, 79, 10, 100, 98, 10, 10, 85, 69, 33, 99, 98, 47, 10, 89, 10};
//uint8_t link_pdr_req_vector[] = {98, 95, 26, 10, 85, 61, 10, 99, 97, 10, 49, 79, 98, 96, 81, 81, 76, 86, 78, 98, 90, 80, 50, 10, 10, 91, 48, 99, 91, 98, 100, 94, 89, 97, 78, 96, 58, 98, 54, 55, 35, 84, 100, 98, 92, 95, 99, 35, 98, 38, 92, 80, 97, 30, 38, 73, 56, 96, 79, 67, 83, 82, 41, 97, 99, 100, 88, 78, 72, 49, 55, 10, 10, 10, 77, 68, 99, 91, 100, 78, 87, 82, 82, 57, 78, 88, 10, 99, 91, 81, 60, 91, 100, 95, 85, 58, 41, 10, 77, 98, 68, 10, 98, 10, 10, 99, 87, 87, 10, 98, 63, 90, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
// to compare against RIDB in indriya
uint8_t link_pdr_req_vector[] = {96, 83, 99, 76, 100, 37, 100, 55, 10, 100, 100, 88, 93, 10, 60, 89, 100, 10, 10, 100, 10, 10, 10, 10, 18, 10, 73, 54, 10, 10, 10, 10, 10, 10, 10, 100, 10, 100, 10, 100, 100, 98, 10, 10, 10, 10, 10, 87, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 100, 100, 76, 81, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 88, 100, 100, 99, 94, 10, 100, 10, 10, 10, 10, 10, 10, 10, 10};
// <10%, 1 = 128>, <20%, 1.3 = 167>, <30%, 1.6 = 205>, <40%, 1.8 = 231>, <50%, 2.2 = 282>, <60%, 2.4 = 308>, <70%, 2.8 * 128 = 359> <80%, 3.2 * 128 = 410> <90%, 4 * 128 = 512>, <95%, 4.5 * 128 = 576>
//int16_t pdr_2_snr_table[] = {128, 167, 205, 231, 282, 308, 359, 410, 512, 576};
// scaled 10X
uint8_t pdr_2_snr_table[] = {10, 13, 16, 18, 22, 24, 28, 32, 40, 45};
//uint8_t link_pdr_req_vector[][2] = {{1, 98}, {2, 97}, {3, 54}, {4, 26}, {5, 84}, {6, 56}, {8, 98}, {9, 99}, {10, 77}, {11, 92}, {13, 74}, {14, 99}, {15, 98}, {16, 94}, {17, 26}, {18, 78}, {19, 97}, {20, 94}, {21, 10}, {22, 98}, {23, 58}, {26, 54}, {27, 74}, {28, 24}, {29, 100}, {30, 99}, {31, 98}, {32, 97}, {33, 46}, {34, 98}, {35, 10}, {38, 72}, {39, 86}, {40, 78}, {41, 57}, {42, 86}, {43, 98}, {44, 92}, {45, 99}, {46, 92}, {47, 69}, {48, 70}, {49, 69}, {50, 98}, {51, 98}, {52, 92}, {53, 75}, {54, 99}, {55, 62}, {56, 10}, {57, 71}, {58, 89}, {61, 77}, {62, 16}, {63, 97}, {65, 100}, {67, 99}, {68, 81}, {69, 92}, {70, 10}, {71, 65}, {72, 97}, {73, 10}, {75, 38}, {76, 91}, {77, 98}, {78, 29}, {79, 89}, {80, 98}, {81, 99}, {83, 97}, {91, 81}, {92, 82}, {93, 96}, {94, 92}, {95, 98}, {96, 74}, {99, 59}, {100, 94}, {101, 70}, {103, 99}, {104, 65}, {105, 35}, {108, 80}, {110, 87}, {111, 96}, {113, 90}, {114, 95}, {115, 45}, {116, 79}, {118, 100}, {119, 98}, {122, 85}, {123, 69}, {124, 33}, {125, 99}, {126, 98}, {127, 47}, {129, 89}};
#endif

//#warning kansei: change log format to use UtilsInt16Id!!
//link_t activeLinks[] = {{103, 135}, {105, 104}, {109, 141}, {115, 116}, {119, 135}, {121, 120}, {125, 141}, {132, 116}, {134, 166}, {136, 152}, {140, 139}, {142, 126}, {144, 116}, {149, 134}, {151, 167}, {155, 157}, {159, 158}, {161, 210}, {166, 182}, {169, 170}, {179, 196}, {181, 213}, {183, 152}, {195, 180}, {197, 181}, {199, 183}, {207, 224}, {209, 225}, {213, 214}, {215, 183}, {224, 207}, {229, 230}, {231, 248}, {233, 250}, {235, 251}, {239, 255}, {241, 240}, {243, 241}, {245, 229}, {247, 215}, {249, 250}, {251, 235}, {255, 256}, {257, 256}, {259, 289}, {261, 248}, {263, 280}, {267, 268}, {269, 268}, {271, 287}, {274, 273}, {276, 290}, {278, 262}, {283, 267}, {285, 286}, {287, 271}, {289, 274}, {291, 292}, {293, 261}, {295, 309}, {299, 313}, {301, 302}, {303, 287}, {306, 290}, {308, 307}, {310, 309}, {314, 313}, {316, 317}, {318, 302}, {321, 320}, {323, 292}, {328, 294}, {330, 297}, {332, 315}, {334, 368}, {336, 335}, {338, 337}, {340, 339}, {344, 360}, {348, 365}, {350, 365}, {353, 369}, {356, 339}, {358, 373}, {360, 343}, {362, 361}, {365, 334}, {368, 334}, {370, 369}, {374, 359}, {376, 377}, {378, 379}, {380, 381}, {382, 380}, {385, 386}, {389, 390}, {391, 423}, {395, 411}, {405, 406}, {407, 408}, {411, 427}, {422, 421}, {424, 408}, {426, 425}, {428, 444}, {438, 437}, {440, 456}, {442, 441}, {444, 427}, {456, 440}, {472, 471}};
//	SLOT_MASK = 0xFF, //0x7F,
//	SM_SIZE = 64,	//128
//	SM_SIZE_MODULAR = 0x3F,	// x % SM_SIZE == x & SM_SIZE_MODULAR
//	MAX_ACTIVE_LINK_SIZE = 221,	//100,
//	MAX_INCIDENT_LINK_SIZE = 4,
//link_t activeLinks[] = {{103, 135}, {104, 121}, {105, 104}, {106, 121}, {109, 141}, {110, 125}, {115, 116}, {116, 132}, {119, 135}, {120, 170}, {121, 120}, {122, 140}, {125, 141}, {126, 142}, {132, 116}, {133, 134}, {134, 166}, {135, 119}, {136, 152}, {139, 141}, {140, 139}, {141, 157}, {142, 126}, {143, 142}, {144, 116}, {145, 142}, {149, 134}, {150, 103}, {151, 167}, {152, 135}, {155, 157}, {158, 157}, {159, 158}, {160, 161}, {161, 210}, {162, 161}, {166, 182}, {167, 183}, {169, 170}, {170, 139}, {179, 196}, {180, 179}, {181, 213}, {182, 166}, {183, 152}, {184, 185}, {195, 180}, {196, 179}, {197, 181}, {198, 182}, {199, 183}, {200, 185}, {207, 224}, {208, 209}, {209, 225}, {210, 161}, {213, 214}, {214, 213}, {215, 183}, {223, 239}, {224, 207}, {225, 240}, {229, 230}, {230, 229}, {231, 248}, {232, 248}, {233, 250}, {234, 250}, {235, 251}, {236, 252}, {239, 255}, {240, 256}, {241, 240}, {242, 241}, {243, 241}, {244, 259}, {245, 229}, {246, 229}, {247, 215}, {248, 232}, {249, 250}, {250, 235}, {251, 235}, {252, 235}, {255, 256}, {256, 240}, {257, 256}, {258, 210}, {259, 289}, {260, 226}, {261, 248}, {262, 278}, {263, 280}, {264, 247}, {267, 268}, {268, 267}, {269, 268}, {270, 269}, {271, 287}, {272, 271}, {274, 273}, {275, 306}, {276, 290}, {277, 246}, {278, 262}, {280, 262}, {283, 267}, {284, 267}, {285, 286}, {286, 302}, {287, 271}, {288, 287}, {289, 274}, {290, 306}, {291, 292}, {292, 291}, {293, 261}, {294, 295}, {295, 309}, {297, 313}, {299, 313}, {300, 299}, {301, 302}, {302, 318}, {303, 287}, {305, 304}, {306, 290}, {307, 308}, {308, 307}, {309, 310}, {310, 309}, {313, 297}, {314, 313}, {315, 332}, {316, 317}, {317, 316}, {318, 302}, {320, 321}, {321, 320}, {322, 337}, {323, 292}, {324, 308}, {328, 294}, {329, 299}, {330, 297}, {331, 314}, {332, 315}, {333, 332}, {334, 368}, {335, 304}, {336, 335}, {337, 338}, {338, 337}, {339, 355}, {340, 339}, {343, 360}, {344, 360}, {347, 379}, {348, 365}, {349, 333}, {350, 365}, {352, 368}, {353, 369}, {355, 339}, {356, 339}, {357, 358}, {358, 373}, {359, 374}, {360, 343}, {361, 377}, {362, 361}, {364, 365}, {365, 334}, {367, 368}, {368, 334}, {369, 370}, {370, 369}, {373, 358}, {374, 359}, {375, 359}, {376, 377}, {377, 376}, {378, 379}, {379, 380}, {380, 381}, {381, 380}, {382, 380}, {383, 381}, {385, 386}, {386, 369}, {389, 390}, {390, 389}, {391, 423}, {392, 390}, {395, 411}, {396, 379}, {405, 406}, {406, 405}, {407, 408}, {408, 407}, {411, 427}, {421, 422}, {422, 421}, {423, 407}, {424, 408}, {425, 426}, {426, 425}, {427, 411}, {428, 444}, {437, 422}, {438, 437}, {439, 455}, {440, 456}, {441, 422}, {442, 441}, {443, 411}, {444, 427}, {455, 440}, {456, 440}, {471, 456}, {472, 471},};


async command link_t *Util.getActiveLinks(uint8_t *size) {
	*size = sizeof(activeLinks) / sizeof(activeLinks[0]);
	return activeLinks;
}

// is the link <sender, receiver> active
async command bool Util.isActiveLink(am_addr_t sender, am_addr_t receiver) {
	uint8_t i;
	
	for (i = 0; i < sizeof(activeLinks) / sizeof(activeLinks[0]); i++) {
		if (activeLinks[i].sender == sender && activeLinks[i].receiver == receiver)
			return TRUE;
	}
	return FALSE;
}

async command uint8_t Util.findLinkIdx(am_addr_t sender, am_addr_t receiver) {
	uint8_t i;
	
	for (i = 0; i < sizeof(activeLinks) / sizeof(activeLinks[0]); i++) {
		if (activeLinks[i].sender == sender && activeLinks[i].receiver == receiver)
			return i;
	}
	return i;
}

// return receiver, at most one for each node
async command am_addr_t Util.getReceiver() {
	uint8_t i;
	
	for (i = 0; i < sizeof(activeLinks) / sizeof(activeLinks[0]); i++) {
		if (activeLinks[i].sender == TOS_NODE_ID)
			return activeLinks[i].receiver;
	}
	return INVALID_ADDR;
}

#ifdef HETER_TX_POWER
// return tx power level of a node
async command uint8_t Util.getNodeTxPowerLevel(am_addr_t node) {
	uint8_t i;
	
	for (i = 0; i < sizeof(activeLinks) / sizeof(activeLinks[0]); i++) {
		if (activeLinks[i].sender == node)
			return activeLinks[i].tx_power_level;
	}
	return CC2420X_DEF_RFPOWER;
}
#endif

#ifdef SET_PDR_REQ_BY_LINK
// return outgoing link's pdr req
async command uint8_t Util.getLocalLinkPdrReq(am_addr_t sender) {
	uint8_t i, link_pdr_req;
	
	//i = TOS_NODE_ID - 1;
	i = sender - 1;
	if (i < sizeof(link_pdr_req_vector) / sizeof(link_pdr_req_vector[0])) {
//	#warning higher PDR req
////		return (link_pdr_req_vector[i] - PRKS_PDR_OVERSHOOT);
//		link_pdr_req = link_pdr_req_vector[i] + PRKS_PDR_OVERSHOOT;
//		if (link_pdr_req > 100)
//			link_pdr_req = 100;
	#warning lower PDR req
		link_pdr_req = link_pdr_req_vector[i];
		if (link_pdr_req > PRKS_PDR_OVERSHOOT)
			link_pdr_req -= PRKS_PDR_OVERSHOOT;
		return link_pdr_req;
	}
	
//	uint8_t i;
//	
//	for (i = 0; i < sizeof(link_pdr_req_vector) / sizeof(link_pdr_req_vector[0]); i++) {
//		if (link_pdr_req_vector[i][0] == TOS_NODE_ID)
//			return link_pdr_req_vector[i][1] - PRKS_PDR_OVERSHOOT;
//	}
	// default
	//return (REFERENCE_DATA_PDR - PRKS_PDR_OVERSHOOT);
	return REFERENCE_DATA_PDR;
}

// convert pdr to snr
async command int16_t Util.pdr2Snr(uint8_t pdr) {
	uint8_t i, size;
	
	i = pdr / 10;
	if (!(pdr % 10)) {
		if (i > 1)
			i--;
	}
	size = sizeof(pdr_2_snr_table) / sizeof(pdr_2_snr_table[0]);
	if (i >= size)
		i = size - 1;
	return ((int16_t)pdr_2_snr_table[i] * 128 / 10);
}
#endif

}
