/**
 * Copyright (c) 2003 - The University of Texas at Austin and
 *                      The Ohio State University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement
 * is hereby granted, provided that the above copyright notice, the following
 * two paragraphs, and the author attribution appear in all copies of this
 * software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF TEXAS AT AUSTIN AND THE OHIO STATE
 * UNIVERSITY BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL,
 * INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS
 * SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF TEXAS AT AUSTIN
 * AND THE OHIO STATE UNIVERSITY HAVE BEEN ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * THE UNIVERSITY OF TEXAS AT AUSTIN AND THE OHIO STATE UNIVERSITY
 * SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND
 * THE UNIVERSITY OF TEXAS AT AUSTIN AND THE OHIO STATE UNIVERSITY HAS NO
 * OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 * MODIFICATIONS.
 */

/*
 *  Author/Contact: Young-ri Choi
 *                  yrchoi@cs.utexas.edu
 *
 *  This implementation is based on the design
 *  by Mohamed G. Gouda, Young-ri Choi, Anish Arora and Vinayak Naik.
 *
 */

includes AM;
includes global;

interface Routing {

  command result_t send(TOS_MsgPtr msg,uint8_t size);
  event result_t sendDone(TOS_MsgPtr msg, result_t success);
  event TOS_MsgPtr receive(TOS_MsgPtr msg);

  command uint8_t getNumofTableRegeneration();

#ifdef LOF_ROUTING	
  command uint8_t getCurrentParent();
  command uint8_t getCurrentBufferSize();
  command uint8_t getCurrentTableSize();
  command uint8_t getSwitchCount();
  command uint8_t getPktSwitchBefore();
  command uint8_t getNumofDeadNeighbors();

  event result_t reportValue(uint8_t* data,uint8_t flag,uint8_t size);

#ifdef DEBUG_ONLY 
  command uint16_t getNumProbeReplySent(); 
  command uint16_t getNumRouteWithdrawalSent(); 
  command uint16_t getNumReplyBasedNgbrRevitalization(); 
  command uint16_t getNumSendButNoParent(); 
  command uint16_t getNumFwdButNoParent(); 
  command uint8_t getNumChildren();
  command uint8_t getNumSH();
  command uint8_t getNumSH2();
#endif

#endif

}
