
#include "LOF.h" 

uint8_t myGxTb[]={244,238,232,226,220,214,208,202,196,190,184,178,172,166,160,154,149,143,137,131,126,120,114,109,103,97,92,86,81,75,70,64,59,54,49,43,38,33,28,23,18,13,8,3,254,249,245,240,235,231,226,222,217,213,208,204,200,196,192,188,184,180,176,172,168,164,161,157,153,150,146,143,140,136,133,130,127,124,121,118,115,112,109,106,103,101,98,95,93,90,88,86,83,81,79,77,74,72,70,68,66,64,63,61,59,57,55,54,52,51,49,47,46,45,43,42,40,39,38,37,35,34,33,32,31,30,29,28,27,26,25,24,23,23,22,21,20,19,19,18,17,17,16,15,15,14,14,13,13,12,12,11,11,10,10,10,9,9,8,8,8,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,4,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1}; //A) 201 elements with x ranging from 0 to 3, with an interval of 0.015;   B) the values of elements myGxTb[0-43] has been deducted by 256 (so that we can use uint8_t instead of uint16_t in the definition, shoulld be added back when used 
#define GXTB_SIZE (sizeof(myGxTb)/sizeof(myGxTb[0])) //it is 201

uint32_t LOF_pow(uint32_t x2, uint8_t pw)
{
  uint8_t i;
  uint32_t r = 1;
  uint32_t x = x2;

  for (i=0; i< pw; i++)
    r *= x; 

  return r;
} //end of LOF_pow()


uint32_t  LOF_sqrt(uint32_t x2)
{
  uint32_t r;
  uint32_t x = x2;

  x = (x+1) >> 1;
  for(r=0; x>r; x-=r++ )
    ;

  return r;
} //end of LOF_sqrt()


int32_t LOF_log(uint32_t x) //on base e (instead of 2)
{
  uint32_t r = 0;
  uint32_t y = x;
  uint32_t p = 1;
  uint32_t s0, s1, s2, s3;
  uint32_t a;
  uint8_t i;
	
  if (x <= 0)
    return -0xffffff;

  if (x == 1)
    return 0;
			
  for (i = 0; i < 32 && y != 0; i++) {
    y = y>>1;
    r++;
    p = p<<1;
  }

  if (p == 0) 
    goto done;

  s0 = (p-x)*SCALE_HUNDRED/p;
  s1 = s0*s0/SCALE_HUNDRED;
  s2 = s1*s0/SCALE_HUNDRED;
  s3 = s2*s0/SCALE_HUNDRED;
  a = s0+s1/2+s2/3+s3/4; 

  r = r*100/144 - a/SCALE_HUNDRED; 

 done:
  return r; 
} //end of LOF_log()


/* return value is SCALED UP by a factor of 10
 */
uint32_t distance(loc_t* locationA, loc_t* locationB)
{
  uint32_t x, y;
#ifndef USE_GRID_HOP_DIST
  x = LOF_pow((locationA->x > locationB->x ? (locationA->x - locationB->x) : (locationB->x - locationA->x)), 2);
  y = LOF_pow((locationA->y > locationB->y ? (locationA->y - locationB->y) : (locationB->y - locationA->y)), 2);
  return LOF_sqrt((x+y)*100);  //return with a scale of ten
#else
  x = locationA->x > locationB->x ? (locationA->x - locationB->x) : (locationB->x - locationA->x); 
  y = locationA->y > locationB->y ? (locationA->y - locationB->y) : (locationB->y - locationA->y);
  return ((x + y) * 10);
#endif
}


/*
 * Check whether locationA is closer/equal/farther to the base station than locationB
 * 2: closer      1: equal-distant         0: farther
 */ 
#ifndef ID_BASED_ROUTE_SELECTION
uint8_t distanceCmp(loc_t* baseLocation, loc_t* locationA, loc_t* locationB)
{
  uint32_t distanceA = distance(baseLocation, locationA);
  uint32_t distanceB = distance(baseLocation, locationB); 

  if (distanceA < distanceB)
    return 2;
  else if (distanceA == distanceB)
    return 1;
  else
    return 0;
}
#else //ID_BASED_ROUTE_SELECTION
bool is_parent_candidate(node_id_t id)
{
  if (id+1 == my_node_id)
    return TRUE;
  else 
    return FALSE;
}
#endif


/* Compute the probability of one normal variable x1(u1, delta1^2) being greater than the other x2(u2, delta2^2)
 *
 * Return value is scaled up by 1000
 * 
 * Used in: new_pairprob(), update_head_prob()
 */
uint32_t prob_greater(uint32_t u1, uint32_t delta1, uint32_t u2, uint32_t delta2)
{  
  uint32_t x, r;

  uint32_t enumerator;
  uint32_t denomenator;
  uint8_t negativeEnumerator = 0; 

  uint32_t delta11  = (delta1 <= 0 ? 1*SCALE_HUNDRED : delta1);//for sanity checking 
  uint32_t delta22  = (delta2 <= 0 ? 1*SCALE_HUNDRED : delta2); //for sanity checking 
  
  if (u1 == u2)
    return 500; 

  //enumarator
  if (u1 > u2) {
    negativeEnumerator = 1;
    enumerator = u1 - u2;
  }
  else 
    enumerator = u2 - u1;
  //denomenator
  denomenator = LOF_sqrt( LOF_pow(delta11, 2) + LOF_pow(delta22, 2) ); 
  //x
  x = enumerator * SCALE_THOUSAND / denomenator; //scaled up by a factor of 1000
  x /= 15; //the G(x) table provides data for x in [0, 3], with an interval of 0.015

  //search for the probability
  if (x > GXTB_SIZE-1)
    r = 0;
  else if (x > 43)
    r = myGxTb[x];
  else if (x >=0)
    r = myGxTb[x] + 256;

  if (negativeEnumerator == 1) //negative x-axis
    r = 1 * SCALE_THOUSAND - r; //1 - tail-prob.

  dbg(KEY_DEBUG, "<x, G(x)> = <%s%d, %d>   (note: scaled up by 1000)\n", negativeEnumerator == 1? "-" : "+", x, r);

  return r; //tail prob.

} //end of prob_greater(...)
