
includes global;
includes LOF; 

configuration LOFC
{ 
  provides{
    interface StdControl;
    interface Routing;
  } 
}
implementation
{
  components LOFM, TimerC, QueuedSend, GenericComm as Comm,
#if defined(D_V_SNOOPING) || defined(SNOOPING_BASED_RCVER_EST)
    RadioCRCPacket,
#endif
    RandomLFSR,
    LedsC as Leds;

  StdControl = LOFM;
  Routing = LOFM;

  LOFM.CONTROL_Send -> QueuedSend.SendMsg[AM_LOF_CONTROL];
  LOFM.CONTROL_Receive -> Comm.ReceiveMsg[AM_LOF_CONTROL];
#if defined(D_V_SNOOPING) || defined(SNOOPING_BASED_RCVER_EST)
  LOFM.snoop -> RadioCRCPacket.Receive;
#endif

  LOFM.DATA_Send -> QueuedSend.SendMsg[AM_APP_DATA_CHANNEL];
  LOFM.DATA_Receive -> Comm.ReceiveMsg[AM_APP_DATA_CHANNEL];

  LOFM.QueueControl ->QueuedSend;

  LOFM.TimerControl ->TimerC;
  LOFM.Timer -> TimerC.Timer[unique("Timer")];

  LOFM.Random -> RandomLFSR;

  LOFM.Leds -> Leds;
}
