%For mica2 radios

function routingMetricInDynamics

clear
clc
close all


%%Analysis based on Qiu model
traffic_demands = [0.01 0.04 0.07  0.1:0.3:1];% 0.1:0.3:1.0];%0.3;

%%Stand-alone analysis
ds = 1:0.5:20; %distances
i_noise = -70:-10:-110 %interference noise; dB
No_noise = -100000;
i_noise = [No_noise i_noise];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Network topology: no more than 52 nodes due to Matlab constraint
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global x_dim y_dim grid_hop_len;
x_dim = 17;%17, 10, 7
y_dim = 3;%3, 5, 7
sender_rcvers = 26:34;%%26:34 for 17*3 grid middle
                       %18:34 for 17*3 grid
                       %21:30 for 10*5 grid;
                       %22:28 for 7*7 grid; 
                       %4:6 for 3*3 grid
grid_hop_len = 1; %meters
nodes = 1:(x_dim*y_dim);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%   Per-link/radio parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%For Bhaskar's model
global P_t d0 PL_d0 n sigma;
P_t = -14;  %tx power; [dBm power-level]: [-14 3], [-17 2], [-20 1]
d0 = 1; %reference distance; meter
PL_d0 = 55; %dBm
n = 4.7; %4.7,3.3; %pass loss exponent: 3.3 for indoor; 4.7 for outdoor
sigma = 5.5; %std of Guassian noise
P_n = -105; %typical noise floor; dBm

global B_N R;
B_N = 30; %kHz; noise bandwidth
R = 19.2; %kbps; radio 

global f l;
f = 39; %frame size in bytes
l = 8; %preamble size in bytes

%find gamma_0e, gamma_1e, gamma_A, gamma_B
global gamma_0e gamma_1e gamma_A gamma_B;
gamma_0e = pdrToGamma(0.001)
gamma_1e = pdrToGamma(0.999)
gamma_A = pdrToGamma(0.1)
gamma_B = pdrToGamma(0.9)

%%For Qiu Model
CCA_threshold = -103;%-100,-102.7; %CCA threshold; dBm;  
                                     %-100 for 7*7 grid, -102 for outdoor
                                     %-101 for 17*3-middle, -103 for outdoor
                                     %-102.7 for 10*5 and 17*3. -104 for outdoor
                                   
delta_n = 12; %dB

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Miscl. constants
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
savedFile = [num2str(x_dim) '_' num2str(y_dim) '_' num2str(P_t) '.mat'];

lineSpec{1} = '-+r';
lineSpec{2} = '--.g';
lineSpec{3} = ':xb';
lineSpec{4} = '-.sc';
lineSpec{5} = '-^b';
lineSpec{6} = ':ob';
lineSpec{7} = ':vm';
lineSpec{8} = ':^y';
lineSpec{9} = ':*m';


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Analysis based on Qiu interference model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
R = {}; %R{m, n} format: [mean  var] in regular value (not in dBm)
d = []; %d{m} format: [d_mn  n(i.e., destination of m)]
%R{m, n} and R{n, m}
for m=1:(x_dim*y_dim)-1
    for nn=m+1:x_dim*y_dim
        R{m, nn} = [dbToRegular_mean(mu_rx_power(distance(m, nn)), sigma * sigma) ...
                    dbToRegular_var(mu_rx_power(distance(m, nn)), sigma * sigma) ...
                  ];
        R{nn, m} = R{m, nn};
    end
end
%d{m}
for m=1:(x_dim*y_dim)
    d{m}(2) = ceil(rand * x_dim*y_dim); %initialize destination
    while d{m}(2) == m
        d{m}(2) = ceil(rand * x_dim*y_dim);
    end
end
%%%
dists = [];
for ind=2:length(sender_rcvers)
    dists = [dists  distance(sender_rcvers(1), sender_rcvers(ind))];
end
%
pdr_to_present = [];
ETDs_to_present = [];
legends = {};
pdr_no_interfer = [];
for ind=1:length(dists)
    pdr_no_interfer(ind) = E_pdr(dists(ind), P_n);
end
ETDs_no_interfer = (1 ./ pdr_no_interfer) ./ dists;
pdr_no_interfer
ETDs_no_interfer
pdr_to_present(1, :) = pdr_no_interfer;
ETDs_to_present(1, :) = ETDs_no_interfer;
legends{1} = 'no traffic';
%
for ind_traffic=1:length(traffic_demands)
    disp(['Processing traffic_demand = ' num2str(traffic_demands(ind_traffic)) ' ...']);
    for m=1:(x_dim*y_dim)
        d{m}(1) = traffic_demands(ind_traffic);
    end
    %run Qiu's model
    %pi(i, :): format: [real-state-i  stationary-prob.-of-state-i]
    %L(m): packet loss rate from node m to its destination
    [pi L]=Qiu_Interference_Model(R, d, [dbToRegular_mean(P_n, sigma*sigma) dbToRegular_var(P_n, sigma*sigma)], dbToRegular(CCA_threshold), dbToRegular(delta_n), x_dim*y_dim);
    pi
    L
    %save(savedFile, 'pi', 'L');
    %yun=hongwei
    %%%extract interference data 
    interfer_signal_dists = zeros(1, length(dists));
    focus_sender = sender_rcvers(1)
    interfering_states = [];
    for ind_i=1:size(pi, 1)
        i = pi(ind_i, 1);
        tx_nodes = nodesOfAState(i, x_dim*y_dim);
        if length(tx_nodes) == 1 || isempty(intersect(tx_nodes, focus_sender))
            continue
        else
            tx_nodes = setdiff(tx_nodes, [focus_sender]);
            interfering_states = [interfering_states; ...
                pi(ind_i, :) ...
                ];
        end
        %
        for ind=2:length(sender_rcvers) %for each receiver
            for ind_tx=1:length(tx_nodes) %for each interferer
                if tx_nodes(ind_tx) ~= sender_rcvers(ind)
                    interfer_signal_dists(ind-1) = interfer_signal_dists(ind-1) + pi(ind_i, 2) * mu_rx_power_regular(distance(tx_nodes(ind_tx), sender_rcvers(ind)));
                end
            end
        end
    end
    interfer_signal_dists = 10 * log10(interfer_signal_dists)
    interfering_states
    if ~isempty(interfering_states)
        interfering_states_probOnly = interfering_states(:, 2)
    end
    %
    pdr_interfer = [];
    for ind=1:length(dists)
        if interfer_signal_dists(ind) ~= 0
            pdr_interfer(ind) = E_pdr(dists(ind), aggSignal([P_n  interfer_signal_dists(ind)]));
        else
            pdr_interfer(ind) = pdr_no_interfer(ind);
        end
    end
    ETDs_interfer = (1 ./ pdr_interfer) ./ dists;
    pdr_interfer
    ETDs_interfer
    pdr_to_present(ind_traffic+1, :) = pdr_interfer;
    ETDs_to_present(ind_traffic+1, :) = ETDs_interfer;
    legends{ind_traffic+1} = ['d = ' num2str(traffic_demands(ind_traffic))];
    
    disp(['Done with processing traffic_demand =' num2str(traffic_demands(ind_traffic)) '.']);
end %for each traffic scenario
save(savedFile, 'pdr_to_present', 'ETDs_to_present');
%present data
pdr_to_present
figure('Name', [num2str(x_dim) 'x' num2str(y_dim) ': E_pdr vs. distance']);
for ind=1:size(pdr_to_present, 1)
    plot(dists, pdr_to_present(ind, :), lineSpec{ind});
    hold on;
end
set(gca, 'YGrid', 'on', 'FontSize', 30);
xlabel('Distance (meter)');
ylabel('Mean PDR');
legend(legends);
%
ETDs_to_present
figure('Name', [num2str(x_dim) 'x' num2str(y_dim) ': ETD vs. Neighbor distance progress']);
for ind=1:size(ETDs_to_present, 1)
    plot(dists, ETDs_to_present(ind, :), lineSpec{ind});
    hold on;
end
set(gca, 'YGrid', 'on', 'XGrid', 'on', 'FontSize', 30, 'YScale', 'log');
xlabel('Neighbor distance progress (meter)');
ylabel('ETD metric');
legend(legends);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  Standalone analysis by considering artificial interference
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure('Name', 'mean rx power (dBm)');
plot(ds, mu_rx_power(ds));
set(gca, 'YGrid', 'on', 'XGrid', 'on', 'FontSize', 30);
xlabel('Distance (meter)');
ylabel('Mean received signal strength (dBm)');

%
figure('Name', 'E_pdr vs. distance');
E_pdrs = {};
legends = {};
for ind=1:length(i_noise)
    E_pdrs{ind} = [];
    for indDist=1:length(ds)
        if i_noise(ind) == No_noise
            E_pdrs{ind} = [E_pdrs{ind} E_pdr(ds(indDist), P_n)];
        else
            E_pdrs{ind} = [E_pdrs{ind} E_pdr(ds(indDist), aggSignal([P_n i_noise(ind)]))];
        end
    end
    plot(ds, E_pdrs{ind}, lineSpec{ind});
    hold on;
    if i_noise(ind) == No_noise
        legends{ind} = 'no interference';
    else
        legends{ind} = ['i\_noise = ' num2str(i_noise(ind)) 'dB'];
    end
end
set(gca, 'YGrid', 'on', 'FontSize', 30);
xlabel('Distance (meter)');
ylabel('Mean PDR');
legend(legends);

%
figure('Name', 'ETD vs. Neighbor distance progress');
ETDs = {};
legends = {};
for ind=1:length(i_noise)
    ETDs{ind} = (1 ./ E_pdrs{ind}) ./ ds;
    plot(ds, ETDs{ind}, lineSpec{ind});
    hold on;
    if i_noise(ind) == No_noise
        legends{ind} = 'no interference';
    else
        legends{ind} = ['i\_noise = ' num2str(i_noise(ind)) 'dB'];
    end
end
set(gca, 'YGrid', 'on', 'XGrid', 'on', 'FontSize', 30, 'YScale', 'log');
xlabel('Neighbor distance progress (meter)');
ylabel('ETD metric');
legend(legends);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Subfunctions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function meanPdr=E_pdr(d, P_n)
global P_t d0 PL_d0 n sigma gamma_0e gamma_1e gamma_A gamma_B;
mu_d = P_t - PL_d0 - 10 * n * log10(d/d0) - P_n;
m_ge = (normpdf(gamma_1e, mu_d, sigma) - normpdf(gamma_0e, mu_d, sigma)) / (gamma_1e - gamma_0e);
b_ge = (normpdf(gamma_0e, mu_d, sigma) * gamma_1e - normpdf(gamma_1e, mu_d, sigma) * gamma_0e) / (gamma_1e - gamma_0e);
m_e = (0.9 -0.1) / (gamma_B - gamma_A);
b_e = (0.1 * gamma_B - 0.9 * gamma_A) / (gamma_B - gamma_A);
Q = normcdf((mu_d - gamma_1e) / sigma, 0, 1);
meanPdr = ((m_e*m_ge)*realpow(gamma_1e, 3)/3 + (b_e*m_ge+b_ge*m_e)*realpow(gamma_1e, 2)/2 + b_e*b_ge*gamma_1e) - ...
          ((m_e*m_ge)*realpow(gamma_0e, 3)/3 + (b_e*m_ge+b_ge*m_e)*realpow(gamma_0e, 2)/2 + b_e*b_ge*gamma_0e) + ...
          normcdf((mu_d - gamma_1e) / sigma, 0, 1);
if meanPdr > 1
    meanPdr = 1;
end

%
function meanRxPower_dBm=mu_rx_power(d)
global P_t d0 PL_d0 n;
meanRxPower_dBm = P_t - PL_d0 - 10 * n * log10(d/d0);

%
function meanRxPower=mu_rx_power_regular(d)
global P_t d0 PL_d0 n;
meanRxPower_dBm = P_t - PL_d0 - 10 * n * log10(d/d0);
meanRxPower = realpow(10, meanRxPower_dBm/10);

%
function gamma_dB=pdrToGamma(pdr)
global B_N R f l;
gamma = -1 * log(2 - 2 * realpow(pdr, 1 / (16 * f - 8 * l))) * (2 * R / B_N);
gamma_dB = 10 * log10(gamma);

%
function aggSignal_dB=aggSignal(signals_dB)
aggSignal = 0;
for ind=1:length(signals_dB)
    aggSignal = aggSignal + realpow(10, signals_dB(ind)/ 10);
end
aggSignal_dB = 10 * log10(aggSignal);

%
function regularValue=dbToRegular(dbValue)
regularValue = realpow(10, dbValue/10);

%
function regularValue_mean=dbToRegular_mean(dbValue_mean, dbValue_var)
regularValue_mean = realpow(10, (dbValue_mean/10) + (dbValue_var/200));

%
function regularValue_var=dbToRegular_var(dbValue_mean, dbValue_var)
regularValue_var = realpow(10, (dbValue_mean/5) + (dbValue_var/50)) - realpow(10, (dbValue_mean/5) + (dbValue_var/100));

%
function dist=distance(node1, node2)
global x_dim y_dim grid_hop_len;
x1 = mod(node1-1, x_dim);
y1 = (node1-1 -x1)/x_dim;
x2 = mod(node2-1, x_dim);
y2 = (node2-1 -x1)/x_dim;
dist = grid_hop_len * sqrt(realpow(x1-x2, 2) + realpow(y1-y2, 2));

%
function nodes=nodesOfAState(state, totalNumNodes)
tp = state;
nodes = [];
if bitand(tp, 1) == 1
    nodes = [1];
end
for nodeToCheck=2:totalNumNodes
    tp = bitshift(tp, -1);
    if bitand(tp, 1) == 1
        nodes = [nodes nodeToCheck];
    end
end
