%%              An example of how to use "comp_bound" function
%       Written by Hooshang Ghasemi,

clear;
clc;

N       =   3;                  %   Number of files
K       =   3;                  %   Number of users

M_rng   =   0 : N / 100 : N;    %   Range of cache size
Len_M_rng   =   length(M_rng);
R_l     =   zeros(Len_M_rng, 1);%   Lower bound proposed by our method

for M = 1 : Len_M_rng
    
    R_l(M)  =   comp_bound(N, K, M_rng(M));
    
end

plot(M_rng, R_l);
title(['Lower bound for N = ', num2str(N), ' and K = ', num2str(K)]);
xlabel('Cache Size');
ylabel('Lower Bound');
grid on;