%%      Computing Nsat(alpha, beta, K)
function [Nsat, Nsat_last]   =   ComputeNsat(alpha, beta, K)

%   Definition
TreeDepth   =   nextpow2(alpha+beta);
LeavesNum   =   alpha+beta+mod(alpha+beta,2);
Alpha       =   zeros(TreeDepth, LeavesNum);
Beta        =   zeros(TreeDepth, LeavesNum);

%   Initialization
Alpha(TreeDepth, 1)     =   alpha;
Beta(TreeDepth, 1)      =   beta;
NumNode                 =   1;
%   Splitting
for nS  =   1 : TreeDepth-1
    for nI = 1 : NumNode
        Alpha(TreeDepth-nS, 2*nI-1) =   ceil(Alpha(TreeDepth-nS+1, nI) / 2);
        Alpha(TreeDepth-nS, 2*nI)   =   floor(Alpha(TreeDepth-nS+1, nI) / 2);
        Beta(TreeDepth-nS, 2*nI-1)  =   floor(Beta(TreeDepth-nS+1, nI) / 2);
        Beta(TreeDepth-nS, 2*nI)  =   ceil(Beta(TreeDepth-nS+1, nI) / 2);
    end
    NumNode     =   2*NumNode;
end
NsatTmp     =   zeros(TreeDepth, LeavesNum);
NumNode     =   LeavesNum;
for nI = 1 : NumNode
    alpha_l         =   Alpha(1, nI);
    beta_l          =   Beta(1, nI);
    NsatTmp(1, nI) =   alpha_l * min(beta_l,K) ;
end
NumNode     =   ceil((alpha + beta)/2);
for nS  =   2 : TreeDepth
    for nI = 1 : NumNode
        CommonBeta      =   max(Beta(nS, nI) - K, 0);
        alpha_l         =   Alpha(nS-1, 2*nI-1);
        beta_l          =   Beta(nS-1, 2*nI-1);
        alpha_r         =   Alpha(nS-1, 2*nI);
        beta_r          =   Beta(nS-1, 2*nI);
        NsatTmp(nS, nI) =   alpha_l * max(beta_r - CommonBeta, 0) + alpha_r * max(beta_l - CommonBeta, 0) + max(NsatTmp(nS-1, 2*nI-1), NsatTmp(nS-1, 2*nI));
    end
    NumNode     =   ceil(NumNode / 2);
end

Nsat        =   NsatTmp(TreeDepth, 1);
if(TreeDepth == 1)
    Nsat_last   =   0;
else
    Nsat_last   =   max(NsatTmp(TreeDepth-1, 1:2));
end
