`timescale 1ns/1ns

module tutorial2(number1, number2, sum1, sum2);
  input [7:0] number1, number2;
  output reg [7:0] sum1;
  output [7:0] sum2;
  
  always @(number1 or number2) begin
    sum1 <= number1 + number2;
  end
  
  adder adder0(number1[0], number2[0], 0'b0,   carry1,   sum2[0]);
  adder adder1(number1[1], number2[1], carry1, carry2,   sum2[1]);
  adder adder2(number1[2], number2[2], carry2, carry3,   sum2[2]);
  adder adder3(number1[3], number2[3], carry3, carry4,   sum2[3]);
  adder adder4(number1[4], number2[4], carry4, carry5,   sum2[4]);
  adder adder5(number1[5], number2[5], carry5, carry6,   sum2[5]);
  adder adder6(number1[6], number2[6], carry6, carry7,   sum2[6]);
  adder adder7(number1[7], number2[7], carry7, overflow, sum2[7]);

endmodule

module adder(a, b, c, s1, s0);
  input a, b, c;
  output s1, s0;
  
  assign s1 = (a & b) | (c & (a ^ b));
  assign s0 = a ^ b ^ c;
    
endmodule