/*****************************
 * Bradley S. Koch
 * David Waszgis
 * Jason Michl
 * Stephen Choi
 * Com Sci 401
 * 12/4/07
 *****************************/


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace GuitarTeachingApplication
{
    //Enum for different states of the main timer
    public enum TimerStates { start, resultSameTab, resultStepForwardOneTab, stop, stopReset, msg }
    //Enum for different states of the sequence timer
    public enum SequenceTimerStates { normal, stop }

    public partial class MainWindow : Form
    {
        #region Variable Declaration
        AddATabWindow addATabWindow;
        RemoveATabWindow removeATabWindow;
        private TimerStates timerState;
        private bool gotTab, gotResultTab, result, alteredList;
        private static int eString = 0;
        private static int BString = 1;
        private static int GString = 2;
        private static int DString = 3;
        private static int AString = 4;
        private static int EString = 5;
        private List<Tab> tabList;
        private Tab t;
        private static Tab inputTab;
        private int count, speed, right, wrong;

        // THESE DECLARATIONS ARE FROM SOUNDVIEWER
        private SoundViewer.WaveInRecorder _recorder;
        private byte[] _recorderBuffer;
        private SoundViewer.WaveOutPlayer _player;
        private byte[] _playerBuffer;
        private SoundViewer.FifoStream _stream;
        private SoundViewer.WaveFormat _waveFormat;
        private SoundViewer.AudioFrame _audioFrame;
        private int _audioSamplesPerSecond = 44100;
        private int _audioFrameSize = 16384;
        private byte _audioBitsPerSample = 16;
        private byte _audioChannels = 2;
        private bool _isPlayer = false;
        private bool _isTest = false;
        #endregion

        #region Constructors and Initialization Methods
        public MainWindow()
        {
            InitializeComponent();
            speed = 4000;
            MyInitMethod();
        }

        private void MyInitMethod()
        {
            result = false;
            alteredList = false;
            tabList = new List<Tab>();
            count = 0;
            right = 0;
            wrong = 0;
            resetMainForm();
            resetTabSelect();
        }
        #endregion

        #region Event Handler Methods
        private void MainWindow_Load(object sender, EventArgs e)
        {
            if (SoundViewer.WaveNative.waveInGetNumDevs() == 0)
            {
                Console.WriteLine(DateTime.Now.ToString() + " : There are no audio devices available\r\n");
            }
            else
            {
                if (_isPlayer == true)
                    _stream = new SoundViewer.FifoStream();
                _audioFrame = new SoundViewer.AudioFrame(_isTest);
                Start();
            }
        }

        private void quitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (alteredList == true && tabList.Count != 0)
            {
                DialogResult userChoice = MessageBox.Show("TabList has been altered, do you want to save?", "", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation);
                if (userChoice == DialogResult.Yes)
                    saveTabListToolStripMenuItem_Click(sender, e);
                else if (userChoice == DialogResult.Cancel)
                    return;       
            }
            Application.Exit();
        }

        private void clearCurrentTabsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MyInitMethod();
            changeResultLabel("TabList cleared", Color.Black, true);
            setTimer(1500, TimerStates.msg);
        }

        private void addATabToolStripMenuItem_Click(object sender, EventArgs e)
        {
            addATabWindow = new AddATabWindow();
            addATabWindow.AddButton.Click += new System.EventHandler(AddButton_click);
            addATabWindow.ShowDialog(this);
        }

        private void removeTabToolStripMenuItem_Click(object sender, EventArgs e)
        {
            removeATabWindow = new RemoveATabWindow(tabList);
            removeATabWindow.RemoveButton.Click += new System.EventHandler(RemoveButton_click);
            removeATabWindow.ShowDialog(this);
        }

        private void saveTabListToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //If tabList contains tabs, output them to file using .tbs format
            if (tabList.Count > 0)
            {
                if (sfd.ShowDialog() == DialogResult.OK)
                {
                    writeTabsToFile(sfd.FileName);
                    changeResultLabel("TabList saved", Color.Black, true);
                    setTimer(1500, TimerStates.msg);
                }
            }
            else
                MessageBox.Show("Tab list contains no tabs!", "", MessageBoxButtons.OK, MessageBoxIcon.Error);
        }

        private void loadTabsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (ofd.ShowDialog() == DialogResult.OK)
            {
                MyInitMethod();
                pbTabsDisplay.Invalidate();

                readTabsFromFile(ofd.FileName);
                changeResultLabel("TabList Loaded", Color.Black, true);
                setTimer(1500, TimerStates.msg);
            }
        }

        private void pbTabsDisplay_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            Pen pWSmoke = new Pen(Color.WhiteSmoke, 2);
            Pen pBlack = new Pen(Color.Black, 2);

            //Draw in vertical gray lines for the frets
            g.DrawLine(pBlack, 1, 0, 1, 200);
            for (int i = 1; i < 25; i++)
            {
                g.DrawLine(pWSmoke, 32 * i, 0, 32 * i, 200);
            }
            g.DrawLine(pBlack, 799, 0, 799, 200);

            //Draw in horizontal black lines for strings
            for (int i = 0; i < 6; i++)
            {
                g.FillRectangle(Brushes.Black, 0, 40 * i, 800, 5);
            }

            //Draw in gray circles for markers on guitar neck
            for (int i = 1; i < 5; i++)
            {
                g.FillEllipse(Brushes.WhiteSmoke, (32 * (2 * i)) + 11, 98, 10, 10);
            }
            g.FillEllipse(Brushes.WhiteSmoke, (32 * 11) + 11, 58, 10, 10);
            g.FillEllipse(Brushes.WhiteSmoke, (32 * 11) + 11, 138, 10, 10);
            for (int i = 7; i < 11; i++)
            {
                g.FillEllipse(Brushes.WhiteSmoke, (32 * (2 * i)) + 11, 98, 10, 10);
            }

            //Print out the current Tab stored in t in blue
            if (gotTab)
            {
                if ((count + 1) < tabList.Count && displayNextTabCheckBox.Checked == true && (runTypeComboBox.SelectedIndex == 0 || runTypeComboBox.SelectedIndex == 1))
                    printTab(g, tabList[count + 1], Brushes.PowderBlue);

                printTab(g, t, Brushes.Blue);

                //If an input comparison tab is present, print that in addition
                //If the input was correct, print the tab in Green, if the input was incorrect, print the tab in Red
                if (gotResultTab)
                {
                    if (result)
                        printTab(g, t, Brushes.Green);
                    else
                        printTab(g, t, Brushes.Red);
                }
            }
        }

        private void buttonStart_Click(object sender, EventArgs e)
        {
            if (runTypeComboBox.SelectedIndex == 0)
            {
                if (tabList.Count == 0)
                    changeResultLabel("No tabs in list! Add or load some before running", Color.Black, true);
                else
                {
                    changeResultLabel("Play the chord", Color.Black, true);
                    setTimer(100, TimerStates.start);
                    stepForwardOneTab();
                }
            }
            else if (runTypeComboBox.SelectedIndex == 1)
            {
                if (tabList.Count == 0)
                    changeResultLabel("No tabs in list! Add or load some before running", Color.Black, true);
                else
                {
                    right = 0;
                    wrong = 0;
                    changeResultLabel("Play the chord", Color.Black, true);
                    setTimer(100, TimerStates.start);
                    setSequenceTimer(SequenceTimerStates.normal);
                    stepForwardOneTab();
                }
            }
            else if (runTypeComboBox.SelectedIndex == 2)
            {
                if (tabSelectComboBox.SelectedIndex == -1)
                    MessageBox.Show("No measure selected!");
                else
                {
                    changeResultLabel("Play the chord", Color.Black, true);

                    //Start timer in start state
                    setTimer(100, TimerStates.start);
                }
            }
        }

        private void buttonStop_Click(object sender, EventArgs e)
        {
            clearInputTab();
            if (runTypeComboBox.SelectedIndex != 2)
            {
                gotTab = false;
                measureLabel.Text = "";
            }
            resultLabel.Visible = false;
            pbTabsDisplay.Invalidate();
            setTimer(250, TimerStates.stop);
            setSequenceTimer(SequenceTimerStates.stop);
            count = 0;
        }

        private void nextTabButton_Click(object sender, EventArgs e)
        {
            count++;
            setTimer(100, TimerStates.start);
            changeResultLabel("Play the chord", Color.Black, true);
            stepForwardOneTab();
            pbTabsDisplay.Invalidate();
        }

        private void tabSelectComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            t = tabList[tabSelectComboBox.SelectedIndex];
            gotTab = true;
            pbTabsDisplay.Invalidate();
            measureLabel.Text = t.Measure.ToString();
            changeResultLabel("Press 'Run' to begin", Color.Black, true);
        }

        private void runTypeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            changeResultLabel("", Color.Black, false);
            resetMainForm();
            if (runTypeComboBox.SelectedIndex == 0)
            {
                //Display step by step tabs
                tabTimer.Stop();
                resetTabSelect();
                skillLabel.Visible = false;
                skillComboBox.Visible = false;
                displayNextTabCheckBox.Visible = true;
                nextTabButton.Visible = true;
                count = 0;
                changeResultLabel("Press 'Run' to begin", Color.Black, true);
            }
            else if (runTypeComboBox.SelectedIndex == 1)
            {
                //Sequence of tabs
                tabTimer.Stop();
                resetTabSelect();
                count = 0;
                skillLabel.Visible = true;
                skillComboBox.Visible = true;
                displayNextTabCheckBox.Visible = true;
                nextTabButton.Visible = false;
            }
            else if (runTypeComboBox.SelectedIndex == 2)
            {
                //Display specific tab
                tabTimer.Stop();
                skillLabel.Visible = false;
                skillComboBox.Visible = false;
                displayNextTabCheckBox.Visible = false;
                nextTabButton.Visible = false;
                count = 0;
                tabSelectComboBox.Items.Clear();
                foreach (Tab tab in tabList)
                {
                    tabSelectComboBox.Items.Add(tab.Measure);
                }
                tabSelectComboBox.Visible = true;
                changeResultLabel("Select a measure to begin", Color.Black, true);
            }
        }

        private void tabTimer_Tick(object sender, EventArgs e)
        {
            switch (timerState)
            {
                case TimerStates.start:
                    //Start (Default) State
                    if (inputTab != null)
                        if (compareTabs(t, inputTab))
                        {
                            //Take action for correct note played
                            changeResultLabel("Correct!", Color.Green, true);
                            gotResultTab = true;
                            result = true;
                            pbTabsDisplay.Invalidate();
                            count++;
                            right++;
                            if (count < tabList.Count)
                            {
                                if (runTypeComboBox.SelectedIndex == 0 || runTypeComboBox.SelectedIndex == 1)
                                    setTimer(250, TimerStates.resultStepForwardOneTab);
                                else if (runTypeComboBox.SelectedIndex == 2)
                                    setTimer(250, TimerStates.stopReset);
                            }
                            else
                            {
                                changeResultLabel("", Color.Black, false);
                                if (runTypeComboBox.SelectedIndex == 1)
                                    displayResults();
                                setSequenceTimer(SequenceTimerStates.stop);
                                setTimer(250, TimerStates.stop);
                            }
                        }
                        else
                        {
                            //Take action for incorrect note played
                            //Set new timer state
                            if (count < tabList.Count)
                                setTimer(50, TimerStates.resultSameTab);
                            else
                            {
                                changeResultLabel("", Color.Black, false);
                                if (runTypeComboBox.SelectedIndex == 1)
                                    displayResults();
                                setSequenceTimer(SequenceTimerStates.stop);
                                setTimer(250, TimerStates.stop);
                            }
                        }
                    break;
                case TimerStates.resultSameTab:
                    //Clear input and revert to start state
                    clearInputTab();
                    changeResultLabel("Play the chord", Color.Black, true);
                    pbTabsDisplay.Invalidate();
                    setTimer(100, TimerStates.start);
                    break;
                case TimerStates.resultStepForwardOneTab:
                    //Advance to next note, clear input, and revert to start state
                    clearInputTab();
                    changeResultLabel("Play the chord", Color.Black, true);
                    stepForwardOneTab();
                    pbTabsDisplay.Invalidate();
                    setTimer(10, TimerStates.start);
                    if (runTypeComboBox.SelectedIndex == 1)
                    {
                        setSequenceTimer(SequenceTimerStates.stop);
                        setSequenceTimer(SequenceTimerStates.normal);
                    }
                    break;
                case TimerStates.stop:
                    //Clear input and rever to start-like state, stop timer
                    clearInputTab();
                    pbTabsDisplay.Invalidate();
                    tabTimer.Stop();
                    break;
                case TimerStates.stopReset:
                    //Clear input and revert to start-like state, printing message, stop timer
                    clearInputTab();
                    changeResultLabel("Press 'Run' to begin", Color.Black, true);
                    pbTabsDisplay.Invalidate();
                    tabTimer.Stop();                    
                    break;
                case TimerStates.msg:
                    //For clearing temporary displayed messages
                    changeResultLabel("", Color.Black, false);
                    tabTimer.Stop();
                    break;
            }
        }
        
        private void sequenceTimer_Tick(object sender, EventArgs e)
        {
            wrong++;
            count++;
            changeResultLabel("Missed", Color.Red, true);
            setSequenceTimer(SequenceTimerStates.stop);
            setTimer(250, TimerStates.resultStepForwardOneTab);
        }

        private void AddButton_click(object sender, EventArgs e)
        {
            Tab temp = new Tab();
            int resulte, resultB, resultG, resultD, resultA, resultE;
            //Try parsing ints from all the text fields, if any fail, print a message and return unsuccessfully
            //Also make sure all results are in the range [-1, 25], if any aren't, display the error message
            if (!int.TryParse(addATabWindow.EHighText, out resulte) ||
                !int.TryParse(addATabWindow.BText, out resultB) ||
                !int.TryParse(addATabWindow.GText, out resultG) ||
                !int.TryParse(addATabWindow.DText, out resultD) ||
                !int.TryParse(addATabWindow.AText, out resultA) ||
                !int.TryParse(addATabWindow.ELowText, out resultE) ||
                (resulte < -1 || resulte > 25) ||
                (resultB < -1 || resultB > 25) ||
                (resultG < -1 || resultG > 25) ||
                (resultD < -1 || resultD > 25) ||
                (resultA < -1 || resultA > 25) ||
                (resultE < -1 || resultE > 25))
            {
                MessageBox.Show("Not all fields contain valid input! \n\nPlease fill in all fields with values in the range of -1 to 25!", "", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                //Setup the new Tab object and add it to the tabList
                temp.e = resulte;
                temp.B = resultB;
                temp.G = resultG;
                temp.D = resultD;
                temp.A = resultA;
                temp.E = resultE;
                temp.Measure = 0;
                foreach (Tab t in tabList)
                {
                    if (t.Measure > temp.Measure)
                        temp.Measure = t.Measure;
                }
                temp.Measure++;

                tabList.Add(temp);

                if (runTypeComboBox.SelectedIndex == 2)
                    reloadTabSelect();

                //Display success message and close AddATabWindow
                changeResultLabel("Tab added successfully!", Color.Black, true);
                setTimer(1500, TimerStates.msg);
                addATabWindow.Close();

                alteredList = true;
            }
        }

        private void RemoveButton_click(object sender, EventArgs e)
        {
            //If a tab is selected in the RemoveATabWindow, remove it from the TabList
            if (removeATabWindow.Measure != -1)
            {
                int index = 0;
                foreach (Tab t in tabList)
                {
                    if (t.Measure == removeATabWindow.Measure)
                    {
                        tabList.RemoveAt(index);
                        removeATabWindow.Close();

                        //Cleanup Main Window
                        resetMainForm();
                        if (runTypeComboBox.SelectedIndex == 2)
                            reloadTabSelect();

                        //Display success message and close RemoveATabWindow
                        changeResultLabel("Measure " + removeATabWindow.Measure + " removed from list", Color.Black, true);
                        setTimer(1500, TimerStates.msg);
                        alteredList = true;
                        return;
                    }
                    index++;
                }
            }
            else
                MessageBox.Show("No measure selected!", "", MessageBoxButtons.OK, MessageBoxIcon.Error);
        }
        #endregion

        #region Helper Methods
        private void resetMainForm()
        {
            gotTab = false;
            gotResultTab = false;
            measureLabel.Text = "";
            resultLabel.Visible = false;
            runTypeComboBox.Text = "Select how to display tabs";
            pbTabsDisplay.Invalidate();
        }

        private void resetTabSelect()
        {
            tabSelectComboBox.Visible = false;
            tabSelectComboBox.Items.Clear();
            tabSelectComboBox.Text = "Select Measure";
        }

        private void stepForwardOneTab()
        {
            //Loop until the tabList is exhausted of tabs to display
            //For each tab, wait until user plays the correct note before moving on
            if (count < tabList.Count)
            {
                //Display the current tab
                t = tabList[count];
                gotTab = true;
                gotResultTab = false;
                measureLabel.Text = t.Measure.ToString();
                pbTabsDisplay.Invalidate();
            }
            else
            {
                resetMainForm();
                clearInputTab();
                setTimer(250, TimerStates.stop);
                setSequenceTimer(SequenceTimerStates.stop);
                pbTabsDisplay.Invalidate();
            }
        }

        // Starts the tabTimer with the specified interval and state of operation
        private void setTimer(int interval, TimerStates state)
        {
            tabTimer.Interval = interval;
            timerState = state;
            tabTimer.Start();
        }

        // Starts the sequenceTimer with the specified state of operation
        private void setSequenceTimer(SequenceTimerStates state)
        {
            switch (state)
            {
                case SequenceTimerStates.normal:
                    sequenceTimer.Interval = speed;
                    sequenceTimer.Start();
                    break;
                case SequenceTimerStates.stop:
                    sequenceTimer.Stop();
                    break;
            }
        }

        private void writeTabsToFile(string fileName)
        {
            StreamWriter re = new StreamWriter(fileName);
            foreach (Tab t in tabList)
                re.Write(t.ToString());
            re.Close();
        }

        private void readTabsFromFile(string fileName)
        {            
            StreamReader re = File.OpenText(fileName);

            // our variables 
            
            int first = 0;
            int measure;
            char chr;
            char test;
            char temp;
            string s;
            string s2;
            string newchars;
            int[] str = new int[6];

            // read in characters from file
            while (re.EndOfStream == false)
            {
                char[] chars = new char[5000];
                re.Read(chars, first, 1);
                newchars = new string(chars);
                chr = newchars[first];

                if (chr == '|')
                {
                    first++;
                    re.Read(chars, first, 1);
                    newchars = new string(chars);
                    chr = newchars[first];
                    s = new string(chr, 1);
                    measure = int.Parse(s);

                    // we need to check if its past the 9th measure
                    first++;
                    re.Read(chars, first, 1);
                    newchars = new string(chars);
                    temp = newchars[first];

                    if (temp != ':') // if it is : 
                    {
                        s2 = new string(temp, 1);
                        s = s + s2;
                        measure = int.Parse(s);

                        //after the measure the next character is ":" which we need to skip
                        first++;
                        re.Read(chars, first, 1);
                    }

                   
                    // we need to read in the next 6 characters into our Tablist 
                    for (int count = 0; count < 6; count++)
                    {

                        first++;
                        re.Read(chars, first, 1);
                        newchars = new string(chars);
                        chr = newchars[first];
                        s = new string(chr, 1);

                        if (chr == '-')
                        {
                            str[count] = -1;
                            // next char is going to be ":"
                            first++;
                            re.Read(chars, first, 1);
                        }
                        else
                        {
                            // read in the next char to see if it is 2 digit
                            first++;
                            re.Read(chars, first, 1);
                            newchars = new string(chars);
                            test = newchars[first];
                            // if our next char is ":" then add string s
                            if (test == ':')
                            {
                                str[count] = int.Parse(s);
                                first--;
                            }
                            else
                            {
                                s2 = new string(test, 1);
                                string s3 = s + s2;
                                str[count] = int.Parse(s3);
                                // next char is going to be ":"
                                first++;
                                re.Read(chars, first, 1);
                            }
                        }

                    }

                    tabList.Add(new Tab(measure, str[0], str[1], str[2], str[3], str[4], str[5]));
                }

                first++;
            } // end while

            re.Close();
        }

        private bool compareTabs(Tab t, Tab inputTab)
        {                //Compare input with current tab
            if ((inputTab.e != -1 && inputTab.e == t.e) || (inputTab.B != -1 && inputTab.B == t.B) ||
                (inputTab.G != -1 && inputTab.G == t.G) || (inputTab.D != -1 && inputTab.D == t.D) ||
                (inputTab.A != -1 && inputTab.A == t.A) || (inputTab.E != -1 && inputTab.E == t.E))
                return true;
            else
                return false;
        }

        private void clearInputTab()
        {
            inputTab = null;
            gotResultTab = false;
        }

        private void printTab(Graphics g, Tab t, Brush b)
        {
            int size = 20;
            int offset_x = (int)(size * 0.3);
            int offset_y = (int)(size * 0.4);
            //Print tab t using the brush b
            if (t.e >= 0)
            {
                if (t.e == 0)
                    g.FillRectangle(b, 0, 40 * eString, 800, 5);
                else
                    g.FillEllipse(b, (32 * (t.e - 1)) + offset_x, (40 * eString) - offset_y, size, size);
            }
            if (t.B >= 0)
            {
                if (t.B == 0)
                    g.FillRectangle(b, 0, 40 * BString, 800, 5);
                else
                    g.FillEllipse(b, (32 * (t.B - 1)) + offset_x, (40 * BString) - offset_y, size, size);
            }
            if (t.G >= 0)
            {
                if (t.G == 0)
                    g.FillRectangle(b, 0, 40 * GString, 800, 5);
                else
                    g.FillEllipse(b, (32 * (t.G - 1)) + offset_x, (40 * GString) - offset_y, size, size);
            }
            if (t.D >= 0)
            {
                if (t.D == 0)
                    g.FillRectangle(b, 0, 40 * DString, 800, 5);
                else
                    g.FillEllipse(b, (32 * (t.D - 1)) + offset_x, (40 * DString) - offset_y, size, size);
            }
            if (t.A >= 0)
            {
                if (t.A == 0)
                    g.FillRectangle(b, 0, 40 * AString, 800, 5);
                else
                    g.FillEllipse(b, (32 * (t.A - 1)) + offset_x, (40 * AString) - offset_y, size, size);
            }
            if (t.E >= 0)
            {
                if (t.E == 0)
                    g.FillRectangle(b, 0, 40 * EString, 800, 5);
                else
                    g.FillEllipse(b, (32 * (t.E - 1)) + offset_x, (40 * EString) - offset_y, size, size);
            }
        }

        private void changeResultLabel(string msg, Color c, bool visible)
        {
            resultLabel.Text = msg;
            resultLabel.ForeColor = c;
            if (visible)
                resultLabel.Visible = true;
            else
                resultLabel.Visible = false;
        }

        private void reloadTabSelect()
        {
            tabSelectComboBox.Items.Clear();
            foreach (Tab tab in tabList)
            {
                tabSelectComboBox.Items.Add(tab.Measure);
            }
            tabSelectComboBox.Text = "Select Measure";
        }

        private void displayResults()
        {
            changeResultLabel("Results: " + right + " correct  --  " + wrong + " missed  ::  " + ((right * 100 ) / (right + wrong)) + "% accuracy", Color.Black, true);
        }
        #endregion
/* SoundViewer is the open-source program we use to process sound.
 * In order to integrate it with our program, we had to copy these
 * helper methods into MainWindow.cs
*/
        #region Sound Viewer Helper Methods
        private void Start()
        {
            Stop();
            try
            {
                _waveFormat = new SoundViewer.WaveFormat(_audioFrameSize, _audioBitsPerSample, _audioChannels);
                _recorder = new SoundViewer.WaveInRecorder(0, _waveFormat, _audioFrameSize * 2, 3, new SoundViewer.BufferDoneEventHandler(DataArrived));
                if (_isPlayer == true)
                    _player = new SoundViewer.WaveOutPlayer(-1, _waveFormat, _audioFrameSize * 2, 3, new SoundViewer.BufferFillEventHandler(Filler));
                Console.WriteLine(DateTime.Now.ToString() + " : Audio device initialized\r\n");
                Console.WriteLine(DateTime.Now.ToString() + " : Audio device polling started\r\n");
                Console.WriteLine(DateTime.Now + " : Samples per second = " + _audioSamplesPerSecond.ToString() + "\r\n");
                Console.WriteLine(DateTime.Now + " : Frame size = " + _audioFrameSize.ToString() + "\r\n");
                Console.WriteLine(DateTime.Now + " : Bits per sample = " + _audioBitsPerSample.ToString() + "\r\n");
                Console.WriteLine(DateTime.Now + " : Channels = " + _audioChannels.ToString() + "\r\n");
            }
            catch (Exception ex)
            {
                Console.WriteLine(DateTime.Now + " : Audio exception\r\n" + ex.ToString() + "\r\n");
            }
        }

        private void Stop()
        {
            if (_recorder != null)
                try
                {
                    _recorder.Dispose();
                }
                finally
                {
                    _recorder = null;
                }
            if (_isPlayer == true)
            {
                if (_player != null)
                    try
                    {
                        _player.Dispose();
                    }
                    finally
                    {
                        _player = null;
                    }
                _stream.Flush(); // clear all pending data
            }
        }

        private void Filler(IntPtr data, int size)
        {
            if (_isPlayer == true)
            {
                if (_playerBuffer == null || _playerBuffer.Length < size)
                    _playerBuffer = new byte[size];
                if (_stream.Length >= size)
                    _stream.Read(_playerBuffer, 0, size);
                else
                    for (int i = 0; i < _playerBuffer.Length; i++)
                        _playerBuffer[i] = 0;
                System.Runtime.InteropServices.Marshal.Copy(_playerBuffer, 0, data, size);
            }
        }

        private void DataArrived(IntPtr data, int size)
        {
            if (_recorderBuffer == null || _recorderBuffer.Length < size)
                _recorderBuffer = new byte[size];
            if (_recorderBuffer != null)
            {
                System.Runtime.InteropServices.Marshal.Copy(data, _recorderBuffer, 0, size);
                if (_isPlayer == true)
                    _stream.Write(_recorderBuffer, 0, _recorderBuffer.Length);
                _audioFrame.Process(ref _recorderBuffer);
                _audioFrame.RenderFrequencyDomain();//(ref pictureBox2);
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            System.Console.Beep(500, 1000);
        }

        public static void setInputTab(Tab tab)
        {
            inputTab = tab;
        }
        #endregion

        private void skillComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (skillComboBox.SelectedIndex == 0)
                speed = 8000;
            else if (skillComboBox.SelectedIndex == 1)
                speed = 4000;
            else if (skillComboBox.SelectedIndex == 2)
                speed = 1500;
        }
    }
}