/* Copyright (C) 2007 Jeff Morton (jeffrey.raymond.morton@gmail.com)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/*****************************
 * This program has been modified for 
 * the CS401 Guitar Teaching Application.
 * 
 * Jason Michl
 * Stephen Choi
 * Com Sci 401
 * 12/4/07
 *****************************/

using System;
using System.Drawing;
using System.Windows.Forms;

namespace SoundViewer
{
    class AudioFrame
    {
/* CS401
 * We added these seven public members for the GUI to interact with.
*/
        public int string_1E;
        public int string_2B;
        public int string_3G;
        public int string_4D;
        public int string_5A;
        public int string_6E;
        public GuitarTeachingApplication.Tab tab;

        private double[] _waveLeft;
        private double[] _waveRight;
        private double[] _fftLeft;
        private double[] _fftRight;
        private SignalGenerator _signalGenerator;
        private bool _isTest = false;

        public AudioFrame(bool isTest)
        {
            _isTest = isTest;
        }
        public bool NoteTest(int low, int high, int freq, string note)
        {
            if (low <= freq && freq <= high)
            {
                Console.WriteLine(note);
                return true;
            }
            else
                return false;
        }
        /// <summary>
        /// Process 16 bit sample
        /// </summary>
        /// <param name="wave"></param>
        public void Process(ref byte[] wave)
        {
            _waveLeft = new double[wave.Length / 4];
            _waveRight = new double[wave.Length / 4];

            if (_isTest == false)
            {
                // Split out channels from sample
                int h = 0;
                for (int i = 0; i < wave.Length; i += 4)
                {
                    _waveLeft[h] = (double)BitConverter.ToInt16(wave, i);
                    _waveRight[h] = (double)BitConverter.ToInt16(wave, i + 2);
                    h++;
                }
            }
            else
            {
                // Generate artificial sample for testing
                _signalGenerator = new SignalGenerator();
                _signalGenerator.SetWaveform("Sine");
                _signalGenerator.SetSamplingRate(44100);
                _signalGenerator.SetSamples(16384);
                _signalGenerator.SetFrequency(5000);
                _signalGenerator.SetAmplitude(32768);
                _waveLeft = _signalGenerator.GenerateSignal();
                _waveRight = _signalGenerator.GenerateSignal();
            }

            // Generate frequency domain data in decibels
            _fftLeft = FourierTransform.FFTDb(ref _waveLeft);
            _fftRight = FourierTransform.FFTDb(ref _waveRight);
        }

/*
 * CS401:
 * This function was heavily modified for our project.
 * The original function ran an FFT whose parameters 
 * were defined by the graphical interface originally
 * supplied with the program.
 * We modified this function so that it was no longer
 * coupled to the graphical interface (which has
 * been removed from the integrated program).
 * For testing purposes, this function outputs the
 * frequency and approximate finger positioning to
 * the console, but it also writes to the public
 * members that the GUI references.
 * 
 * Several other functions follow this one in the 
*/
        public void RenderFrequencyDomain()//ref PictureBox pictureBox)
        {
            // Determine channnel boundries
//            int width = 8350;
//            int width = 4175;
//            int width = 4000;
            int width = 1300;

            int leftLeft = 0;
            int leftRight = width;


            // Draw left channel
            for (int xAxis = leftLeft; xAxis < leftRight; xAxis++)
            {
//                double amplitude = (int)_fftLeft[(int)(((double)(_fftLeft.Length) / (double)(width)) * xAxis)];
                double amplitude = (int)_fftLeft[(int)(((double)(xAxis*0.5)))];
                if (amplitude < 0) // Drop negative values
                    amplitude = 0; // Multiply leftbotton-lefttop by 6
// CS401: Everything past this point is our code exclusively.
                if (amplitude > 57) // >65 to 70 is ideal.
                {

                    //                    Console.Write(yAxis.ToString());
                    //                    Console.Write("              ");
                    //                    Console.Write(amplitude);
                    //                    Console.Write("              ");

                    if (xAxis > 78 && xAxis < 1282)
                    {
                        Console.Write(xAxis.ToString());
                        Console.Write("              ");
                    }
                    if (NoteTest(1210, 1281, xAxis, "1E22"))
                    {
                        string_1E = 22;
                    }
                    else if (NoteTest(1142, 1209, xAxis, "1E21"))
                    {
                        string_1E = 21;
                    }
                    else if (NoteTest(1078, 1141, xAxis, "1E20"))
                    {
                        string_1E = 20;
                    }
                    else if (NoteTest(1018, 1077, xAxis, "1E19"))
                    {
                        string_1E = 19;
                    }
                    else if (NoteTest(960, 1017, xAxis, "1E18"))
                    {
                        string_1E = 18;
                    }
                    else if (NoteTest(907, 959, xAxis, "1E17 / 2B22"))
                    {
                        string_1E = 17;
                        string_2B = 22;
                    }
                    else if (NoteTest(810, 906, xAxis, "1E16 / 2B21"))
                    {
                        string_1E = 16;
                        string_2B = 21;
                    }
                    else if (NoteTest(761, 809, xAxis, "1E15 / 2B20"))
                    {
                        string_1E = 15;
                        string_2B = 20;
                    }
                    else if (NoteTest(719, 760, xAxis, "1E14 / 2B19"))
                    {
                        string_1E = 14;
                        string_2B = 19;
                    }
                    else if (NoteTest(679, 718, xAxis, "1E13 / 2B18 / 3G22"))
                    {
                        string_1E = 13;
                        string_2B = 18;
                        string_3G = 22;
                    }
                    else if (NoteTest(641, 678, xAxis, "1E12 / 2B17 / 3G21"))
                    {
                        string_1E = 12;
                        string_2B = 17;
                        string_3G = 21;
                    }
                    else if (NoteTest(605, 640, xAxis, "1E11 / 2B16 / 3G20"))
                    {
                        string_1E = 11;
                        string_2B = 16;
                        string_3G = 20;
                    }
                    else if (NoteTest(571, 604, xAxis, "1E10 / 2B15 / 3G19"))
                    {
                        string_1E = 10;
                        string_2B = 15;
                        string_3G = 19;
                    }
                    else if (NoteTest(539, 570, xAxis, "1E9 / 2B14 / 3G18"))
                    {
                        string_1E = 9;
                        string_2B = 14;
                        string_3G = 18;
                    }
                    else if (NoteTest(509, 538, xAxis, "1E8 / 2B13 / 3G17 / 4D22"))
                    {
                        string_1E = 8;
                        string_2B = 13;
                        string_3G = 17;
                        string_4D = 22;
                    }
                    else if (NoteTest(481, 508, xAxis, "1E7 / 2B12 / 3G16 / 4D21"))
                    {
                        string_1E = 7;
                        string_2B = 12;
                        string_3G = 16;
                        string_4D = 21;
                    }
                    else if (NoteTest(454, 480, xAxis, "1E6 / 2B11 / 3G15 / 4D20"))
                    {
                        string_1E = 6;
                        string_2B = 11;
                        string_3G = 15;
                        string_4D = 20;
                    }
                    else if (NoteTest(427, 453, xAxis, "1E5 / 2B10 / 3G14 / 4D19"))
                    {
                        string_1E = 5;
                        string_2B = 10;
                        string_3G = 14;
                        string_4D = 19;
                    }
                    else if (NoteTest(404, 426, xAxis, "1E4 / 2B9 / 3G13 / 4D18"))
                    {
                        string_1E = 4;
                        string_2B = 9;
                        string_3G = 13;
                        string_4D = 18;
                    }
                    else if (NoteTest(382, 403, xAxis, "1E3 / 2B8 / 3G12 / 4D17 / 5A22"))
                    {
                        string_1E = 3;
                        string_2B = 8;
                        string_3G = 12;
                        string_4D = 17;
                        string_5A = 22;
                    }
                    else if (NoteTest(360, 381, xAxis, "1E2 / 2B7 / 3G11 / 4D16 / 5A21"))
                    {
                        string_1E = 2;
                        string_2B = 7;
                        string_3G = 11;
                        string_4D = 16;
                        string_5A = 21;
                    }
                    else if (NoteTest(340, 359, xAxis, "1E1 / 2B6 / 3G10 / 4D15 / 5A20"))
                    {
                        string_1E = 1;
                        string_2B = 6;
                        string_3G = 10;
                        string_4D = 15;
                        string_5A = 20;
                    }
                    else if (NoteTest(321, 339, xAxis, "1E0 / 2B5 / 3G9 / 4D14 / 5A19"))
                    {
                        string_1E = 0;
                        string_2B = 5;
                        string_3G = 9;
                        string_4D = 14;
                        string_5A = 19;
                    }
                    else if (NoteTest(303, 320, xAxis, "2B4 / 3G8 / 4D13 / 5A18"))
                    {
                        string_2B = 4;
                        string_3G = 8;
                        string_4D = 13;
                        string_5A = 18;
                    }
                    else if (NoteTest(286, 302, xAxis, "2B3 / 3G7 / 4D12 / 5A17 / 6E22"))
                    {
                        string_2B = 3;
                        string_3G = 7;
                        string_4D = 12;
                        string_5A = 17;
                        string_6E = 22;
                    }
                    else if (NoteTest(270, 285, xAxis, "2B2 / 3G6 / 4D11 / 5A16 / 6E21"))
                    {
                        string_2B = 2;
                        string_3G = 6;
                        string_4D = 11;
                        string_5A = 16;
                        string_6E = 21;
                    }
                    else if (NoteTest(255, 269, xAxis, "2B1 / 3G5 / 4D10 / 5A15 / 6E20, Middle C"))
                    {
                        string_2B = 1;
                        string_3G = 5;
                        string_4D = 10;
                        string_5A = 15;
                        string_6E = 20;
                    }
                    else if (NoteTest(241, 254, xAxis, "2B0 / 3G4 / 4D9 / 5A14 / 6E19"))
                    {
                        string_2B = 0;
                        string_3G = 4;
                        string_4D = 9;
                        string_5A = 14;
                        string_6E = 19;
                    }
                    else if (NoteTest(228, 240, xAxis, "3G3 / 4D8 / 5A13 / 6E18"))
                    {
                        string_3G = 3;
                        string_4D = 8;
                        string_5A = 13;
                        string_6E = 18;
                    }
                    else if (NoteTest(215, 227, xAxis, "3G2 / 4D7 / 5A12 / 6E17"))
                    {
                        string_3G = 2;
                        string_4D = 7;
                        string_5A = 12;
                        string_6E = 17;
                    }
                    else if (NoteTest(202, 214, xAxis, "3G1 / 4D6 / 5A11 / 6E16"))
                    {
                        string_3G = 1;
                        string_4D = 6;
                        string_5A = 11;
                        string_6E = 16;
                    }
                    else if (NoteTest(191, 201, xAxis, "3G0 / 4D5 / 5A10 / 6E15"))
                    {
                        string_3G = 0;
                        string_4D = 5;
                        string_5A = 10;
                        string_6E = 15;
                    }
                    else if (NoteTest(181, 190, xAxis, "4D4 / 5A9 / 6E14"))
                    {
                        string_4D = 4;
                        string_5A = 9;
                        string_6E = 14;
                    }
                    else if (NoteTest(170, 180, xAxis, "4D3 / 5A8 / 6E13"))
                    {
                        string_4D = 3;
                        string_5A = 8;
                        string_6E = 13;
                    }
                    else if (NoteTest(161, 169, xAxis, "4D2 / 5A7 / 6E12"))
                    {
                        string_4D = 2;
                        string_5A = 7;
                        string_6E = 12;
                    }
                    else if (NoteTest(152, 160, xAxis, "4D1 / 5A6 / 6E11"))
                    {
                        string_4D = 1;
                        string_5A = 6;
                        string_6E = 11;
                    }
                    else if (NoteTest(143, 151, xAxis, "4D0 / 5A5 / 6E10"))
                    {
                        string_4D = 0;
                        string_5A = 5;
                        string_6E = 10;
                    }
                    else if (NoteTest(135, 142, xAxis, "5A4 / 6E9"))
                    {
                        string_5A = 4;
                        string_6E = 9;
                    }
                    else if (NoteTest(128, 134, xAxis, "5A3 / 6E8"))
                    {
                        string_5A = 3;
                        string_6E = 8;
                    }
                    else if (NoteTest(121, 127, xAxis, "5A2 / 6E7"))
                    {
                        string_5A = 2;
                        string_6E = 7;
                    }
                    else if (NoteTest(114, 120, xAxis, "5A1 / 6E6"))
                    {
                        string_5A = 1;
                        string_6E = 6;
                    }
                    else if (NoteTest(108, 113, xAxis, "5A0 / 6E5"))
                    {
                        string_5A = 0;
                        string_6E = 5;
                    }
                    else if (NoteTest(102, 107, xAxis, "6E4"))
                    {
                        string_6E = 4;
                    }
                    else if (NoteTest(95, 101, xAxis, "6E3"))
                    {
                        string_6E = 3;
                    }
                    else if (NoteTest(89, 94, xAxis, "6E2"))
                    {
                        string_6E = 2;
                    }
                    else if (NoteTest(86, 88, xAxis, "6E1"))
                    {
                        string_6E = 1;
                    }
                    else if (NoteTest(79, 85, xAxis, "6E0"))
                    {
                        string_6E = 0;
                    }
                    else
                    {
                        string_1E = -1;
                        string_2B = -1;
                        string_3G = -1;
                        string_4D = -1;
                        string_5A = -1;
                        string_6E = -1;
                    }
                    tab = new GuitarTeachingApplication.Tab(0, string_1E, string_2B, string_3G, string_4D, string_5A, string_6E);
                    GuitarTeachingApplication.MainWindow.setInputTab(tab);
                }                    
            }
        }
    }
}
