
import com.phidgets.*;
import com.phidgets.event.*;

public class RFIDExample
{
	public static final void main(String args[]) throws Exception {
		RFIDPhidget rfid;

		System.out.println(Phidget.getLibraryVersion());

		//
		rfid = new RFIDPhidget();
		rfid.addAttachListener(new AttachListener() {
			public void attached(AttachEvent ae) {
				System.out.println("attachment of " + ae);
			}
		});
		rfid.addDetachListener(new DetachListener() {
			public void detached(DetachEvent ae) {
				System.out.println("detachment of " + ae);
			}
		});
		rfid.addErrorListener(new ErrorListener() {
			public void error(ErrorEvent ee) {
				System.out.println("error event for " + ee);
			}
		});
		rfid.addTagGainListener(new TagGainListener()
		{
			public void tagGained(TagGainEvent oe)
			{
				System.out.println(oe);
			}
		});
		rfid.addTagLossListener(new TagLossListener()
		{
			public void tagLost(TagLossEvent oe)
			{
				System.out.println(oe);
			}
		});
		rfid.addOutputChangeListener(new OutputChangeListener()
		{
			public void outputChanged(OutputChangeEvent oe)
			{
				System.out.println(oe);
			}
		});

		//Open and attach
		rfid.openAny();
		System.out.println("waiting for RFID attachment...");
		rfid.waitForAttachment();

		//Print info
		System.out.println("Serial: " + rfid.getSerialNumber());
		System.out.println("Outputs: " + rfid.getOutputCount());

		// Turn on  light and enable RFID
		rfid.setAntennaOn(true);
		rfid.setLEDOn(true);

		System.out.println("Outputting events.  Input to stop.");
		System.in.read();
		System.out.print("closing...");
		
		//Disable and stop
		rfid.setAntennaOn(false);
		rfid.setLEDOn(false);
		
		rfid.close();
		rfid = null;
		
		System.out.println(" ok");

	}
}
