// TextLCDTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "..\phidget21.h"
#include <windows.h>

HANDLE m_EventHandle;

int __stdcall AttachHandler(CPhidgetHandle LCD, void *userptr)
{
	SetEvent(m_EventHandle);
	printf("Attach handler ran!\n");
	return 0;
}

int __stdcall DetachHandler(CPhidgetHandle LCD, void *userptr)
{
	printf("Detach handler ran!\n");
	return 0;
}

int __stdcall ErrorHandler(CPhidgetHandle LCD, void *userptr, long ErrorCode, void *unknown)
{
	printf("Error handler ran!\n");
	return 0;
}

void display_generic_properties(CPhidgetHandle phid)
{
	long sernum, version;
	const char *deviceptr;
	CPhidget_getDeviceType(phid, &deviceptr);
	CPhidget_getSerialNumber(phid, &sernum);
	CPhidget_getDeviceVersion(phid, &version);

	printf("%s\n", deviceptr);
	printf("Version: %8d SerialNumber: %10d\n", version, sernum);
	return;
}

int test_textlcd()
{
	int result;

	int numRows, numColumns;
	int i;
	CPhidgetTextLCDHandle LCD = 0;
	char myString[10];

	for(i=1;i<9;i++) myString[i]=7+i;
	myString[9]='\0';
	myString[0] = ' ';

	m_EventHandle = CreateEvent(NULL, FALSE, FALSE, NULL);

	printf("ASDF\n");
	CPhidgetTextLCD_create(&LCD);

	CPhidget_set_OnAttach_Handler((CPhidgetHandle)LCD, AttachHandler, NULL);
	CPhidget_set_OnDetach_Handler((CPhidgetHandle)LCD, DetachHandler, NULL);
	CPhidget_set_OnError_Handler((CPhidgetHandle)LCD, ErrorHandler, NULL);

	
	result = CPhidget_open((CPhidgetHandle)LCD, -1);
	if (result) 
	{
		printf ("No TextLCD found...\n");	
		return 0;
	}	
	
	result = WaitForSingleObject(m_EventHandle, 10000); 
	// We wait for up to 1000 milliseconds to get the device

	display_generic_properties((CPhidgetHandle)LCD);

	CPhidgetTextLCD_getNumRows(LCD, &numRows);
	CPhidgetTextLCD_getNumColumns(LCD, &numColumns);
	printf("Rows:%d Columns:%d\n", numRows, numColumns);	

	printf("Backlight result = %d\n", CPhidgetTextLCD_setBacklight(LCD, true));
	printf("CursorOn result = %d\n", CPhidgetTextLCD_setCursorOn(LCD, true));
	printf("CursorBlink result = %d\n", CPhidgetTextLCD_setCursorBlink(LCD, true));
	printf("Contrast result = %d\n", CPhidgetTextLCD_setContrast(LCD, 100));

	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 8, 0x0, 0x8000));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 9, 0x0, 0xFFC00));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 10, 0x0, 0xFFFE0));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 11, 0x0, 0xFFFFF));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 12, 0xF8000, 0xFFFFF));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 13, 0xFFC00, 0xFFFFF));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 14, 0xFFFE0, 0xFFFFF));
	printf("custom character result = %d\n", CPhidgetTextLCD_setCustomCharacter(LCD, 15, 0xFFFFF, 0xFFFFF));

	printf("Result from setDisplayString %d\n", CPhidgetTextLCD_setDisplayString(LCD, 0, "0000000000000"));
	printf("Result from setDisplayString %d\n", CPhidgetTextLCD_setDisplayString(LCD, 1, myString));

	CPhidget_close((CPhidgetHandle)LCD);
	CPhidget_delete((CPhidgetHandle )LCD);

	return 0;
}

int main(int argc, char* argv[])
{
	test_textlcd();
	return 0;
}

