// LEDTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "windows.h"
#include "..\phidget21.h"

HANDLE m_EventHandle;

int __stdcall AttachHandler(CPhidgetHandle IFK, void *userptr)
{
	SetEvent(m_EventHandle);
	printf("Attach handler ran!\n");
	return 0;
}

int __stdcall DetachHandler(CPhidgetHandle IFK, void *userptr)
{
	printf("Detach handler ran!\n");
	return 0;
}

int __stdcall ErrorHandler(CPhidgetHandle IFK, void *userptr, long ErrorCode, void *unknown)
{
	printf("Error handler ran!\n");
	return 0;
}

void display_generic_properties(CPhidgetHandle phid)
{
	long sernum, version;
	const char *deviceptr;
	CPhidget_getDeviceType(phid, &deviceptr);
	CPhidget_getSerialNumber(phid, &sernum);
	CPhidget_getDeviceVersion(phid, &version);

	printf("%s\n", deviceptr);
	printf("Version: %8d SerialNumber: %10d\n", version, sernum);
	return;
}

int test_led()
{
	int result, i;

	CPhidgetLEDHandle led = 0;

	m_EventHandle = CreateEvent(NULL, FALSE, FALSE, NULL);

	CPhidgetLED_create(&led);

	CPhidget_set_OnAttach_Handler((CPhidgetHandle)led, AttachHandler, NULL);
	CPhidget_set_OnDetach_Handler((CPhidgetHandle)led, DetachHandler, NULL);
	CPhidget_set_OnError_Handler((CPhidgetHandle)led, ErrorHandler, NULL);

	result = CPhidget_open((CPhidgetHandle)led, -1);

	if (result) 
	{	
		printf ("No PhidgetLEDs found...\n");	
		return 0;
	}

	result = WaitForSingleObject(m_EventHandle, 10000);
	// We wait for up to 1000 milliseconds to get the device

	display_generic_properties((CPhidgetHandle) led);

	for (i = 0; i<64; i++)
		if (result = CPhidgetLED_setDiscreteLED(led, i,i))
			printf("Error result is %d\n", result);

	CPhidget_close((CPhidgetHandle)led);
	CPhidget_delete((CPhidgetHandle)led);
	return 0;
}

int main(int argc, char* argv[])
{
	test_led();
	return 0;
}

