// InterfacekitTest.cpp : Defines the entry point for the console application.
//


#include "stdafx.h"
#include "..\phidget21.h"

#include <windows.h>

void display_generic_properties(CPhidgetHandle phid)
{
	long sernum, version;
	const char *deviceptr;
	CPhidget_getDeviceType(phid, &deviceptr);
	CPhidget_getSerialNumber(phid, &sernum);
	CPhidget_getDeviceVersion(phid, &version);

	printf("%s\n", deviceptr);
	printf("Version: %8d SerialNumber: %10d\n", version, sernum);
	return;
}

int __stdcall IFK_AttachHandler(CPhidgetHandle IFK, void *userptr)
{
	printf("Attach handler ran!\n");
	return 0;
}

int __stdcall IFK_DetachHandler(CPhidgetHandle IFK, void *userptr)
{
	printf("Detach handler ran!\n");
	return 0;
}

int __stdcall IFK_ErrorHandler(CPhidgetHandle IFK, void *userptr, long ErrorCode, void *unknown)
{
	printf("Attach handler ran!\n");
	return 0;
}

int __stdcall IFK_OutputChangeHandler(CPhidgetInterfaceKitHandle IFK, void *userptr, int Index, int Value)
{
	printf("Output %d is %d\n", Index, Value);
	return 0;
}

int __stdcall IFK_InputChangeHandler(CPhidgetInterfaceKitHandle IFK, void *userptr, int Index, int Value)
{
	printf("Input %d is %d\n", Index, Value);
	return 0;
}

int __stdcall IFK_SensorChangeHandler(CPhidgetInterfaceKitHandle IFK, void *userptr, int Index, int Value)
{
	printf("Sensor %d is %d\n", Index, Value);
	return 0;
}


int test_interfacekit()
{
	int result;
	char *err;

	int numInputs, numOutputs, numSensors;
	int i;
	CPhidgetInterfaceKitHandle IFK = 0;

	CPhidgetInterfaceKit_create(&IFK);

	CPhidgetInterfaceKit_set_OnInputChange_Handler(IFK, IFK_InputChangeHandler, NULL);
	CPhidgetInterfaceKit_set_OnOutputChange_Handler(IFK, IFK_OutputChangeHandler, NULL);
	CPhidgetInterfaceKit_set_OnSensorChange_Handler(IFK, IFK_SensorChangeHandler, NULL);
	CPhidget_set_OnAttach_Handler((CPhidgetHandle)IFK, IFK_AttachHandler, NULL);
	CPhidget_set_OnDetach_Handler((CPhidgetHandle)IFK, IFK_DetachHandler, NULL);
	CPhidget_set_OnError_Handler((CPhidgetHandle)IFK, IFK_ErrorHandler, NULL);

	CPhidget_open((CPhidgetHandle)IFK, -1);

	//Wait for 10 seconds, otherwise exit
	if(result = CPhidget_waitForAttachment((CPhidgetHandle)IFK, 10000))
	{
		CPhidget_getErrorDescription(result, &err);
		printf("Problem waiting for attachment: %s\n", err);
		return 0;
	}

	display_generic_properties((CPhidgetHandle)IFK);

	CPhidgetInterfaceKit_getNumOutputs(IFK, &numOutputs);
	CPhidgetInterfaceKit_getNumInputs(IFK, &numInputs);
	CPhidgetInterfaceKit_getNumSensors(IFK, &numSensors);

	printf("Sensors:%d Inputs:%d Outputs:%d\n", numSensors, numInputs, numOutputs);


	for (i = 0; i<1000; i++)
	{
		CPhidgetInterfaceKit_setOutputState(IFK, 0, true);
		CPhidgetInterfaceKit_setOutputState(IFK, 0, false);	
	}
	CPhidget_close((CPhidgetHandle)IFK);
	CPhidget_delete((CPhidgetHandle)IFK);

	return 0;
}

int main(int argc, char* argv[])
{
	test_interfacekit();
	return 0;
}

