VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form Form1 
   Caption         =   "Weight Sensor - A very simple example"
   ClientHeight    =   1260
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5070
   LinkTopic       =   "Form1"
   ScaleHeight     =   1260
   ScaleWidth      =   5070
   StartUpPosition =   3  'Windows Default
   Begin MSComctlLib.Slider sldrWeight 
      Height          =   615
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   4695
      _ExtentX        =   8281
      _ExtentY        =   1085
      _Version        =   393216
      Max             =   140
      TickFrequency   =   10
   End
   Begin VB.Label Label1 
      Caption         =   "0"
      Height          =   255
      Left            =   3720
      TabIndex        =   2
      Top             =   840
      Width           =   1335
   End
   Begin VB.Label lblMessage 
      Caption         =   "Attach a PhidgetWeightSensor"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   840
      Width           =   3255
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     WeightSensor-Simple
' Author:      Dan Henne
' Date:        August 11, 2004
' Version:     1.0.0
' Description:
' -This simple example controls a slider using the feedback
'  from a PhidgetWeightSensor

Option Explicit
Dim WithEvents WeightSensor As PhidgetWeightSensor
Attribute WeightSensor.VB_VarHelpID = -1
Dim WFilt(0 To 6) As Double
Dim XOut As Double

Private Sub Form_Load()
    Set WeightSensor = New PhidgetWeightSensor        'Get the phidget manager going
    lblMessage.Caption = "Attach a PhidgetWeightSensor"
    sldrWeight.Value = 0
    sldrWeight.Min = 0
    sldrWeight.Max = 140
    sldrWeight.TickFrequency = 10
    WeightSensor.Open
End Sub

'Phidget is ATTACHING
Private Sub WeightSensor_OnAttach()
    lblMessage.Caption = "PhidgetWeightSensor Attached"
    WeightSensor.WeightChangeTrigger = 0.05
End Sub

'Phidget is DETACHING: Clean up
Private Sub WeightSensor_OnDetach()
    lblMessage.Caption = "Attach a PhidgetWeightSensor "
End Sub

Private Sub WeightSensor_OnWeightChange(ByVal Weight As Double)
    Dim I As Integer
    
    ' We are performing a very simple low pass filter here.
    ' You don't have to use this, but for measuring things that
    ' change slowly, it's nice to filter the data a little more.
    XOut = 0
    WFilt(6) = Weight
    For I = 0 To 5
        WFilt(I) = WFilt(I + 1)
        XOut = XOut + WFilt(I)
    Next I
    XOut = XOut / 6

    sldrWeight.Value = XOut
    Label1.Caption = Round(XOut, 3)
End Sub
