VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Temperature Sensor - A very simple example"
   ClientHeight    =   2055
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4500
   LinkTopic       =   "Form1"
   ScaleHeight     =   2055
   ScaleWidth      =   4500
   StartUpPosition =   3  'Windows Default
   Begin VB.Label lblTemperature 
      Caption         =   "-----"
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0.0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Index           =   1
      Left            =   2400
      TabIndex        =   4
      Top             =   600
      Width           =   855
   End
   Begin VB.Label lblTemperature 
      Caption         =   "-----"
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0.0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Index           =   0
      Left            =   2400
      TabIndex        =   3
      Top             =   120
      Width           =   855
   End
   Begin VB.Label Label3 
      Caption         =   "Sensed Temperature : "
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   600
      Width           =   1815
   End
   Begin VB.Label Label2 
      Caption         =   "Ambient Temperature : "
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   1815
   End
   Begin VB.Label lblMessage 
      Caption         =   "Attach a PhidgetTemperatureSensor"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   1680
      Width           =   3855
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     TemperatureSensor-Simple
' Author:      Chester Fitchett
' Date:        Sept 19, 2004
' Version:     1.0.0
' Description:
' -This simple example controls a slider using the feedback
'  from a PhidgetTemperature

Option Explicit
Dim WithEvents TempSensor As PhidgetTemperatureSensor
Attribute TempSensor.VB_VarHelpID = -1
Dim TFilt(0 To 19) As Double
Dim Tout(0 To 1) As Double

Private Sub Form_Load()
    Set TempSensor = New PhidgetTemperatureSensor
    lblMessage.Caption = "Attach a PhidgetTemperatureSensor"
    TempSensor.Open
End Sub

'Phidget is ATTACHING
Private Sub TempSensor_OnAttach()
    Dim I As Integer
    lblMessage.Caption = "PhidgetTemperatureSensor Attached"
    For I = 0 To TempSensor.NumTemperatureInputs - 1
        TempSensor.TemperatureChangeTrigger(I) = 0
    Next I
End Sub

'Phidget is DETACHING: Clean up
Private Sub TempSensor_OnDetach()
    lblMessage.Caption = "Attach a PhidgetTemperatureSensor "
End Sub


Private Sub TempSensor_OnTemperatureChange(ByVal Index As Long, ByVal Temperature As Single)
    Dim I As Integer
    Dim MaxCount As Integer
       
    ' We are performing a very simple low pass filter here.
    ' You don't have to use this, but for measuring things that
    ' change slowly, it's nice to filter the data a little more.
    Tout(Index) = 0
    For I = 0 To 8
        Tout(Index) = Tout(Index) + TFilt(Index * 10 + I)
        TFilt(Index * 10 + I) = TFilt(Index * 10 + I + 1)
    Next
    TFilt(Index * 10 + 9) = Temperature
    Tout(Index) = Tout(Index) + TFilt(Index * 10 + 9)
    Tout(Index) = Tout(Index) / 10

    lblTemperature(Index) = Round(Tout(Index), 3)
End Sub
