VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form Form1 
   Caption         =   "ServoSlider: Example of a PhidgetServo program"
   ClientHeight    =   3255
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5580
   LinkTopic       =   "Form1"
   ScaleHeight     =   3255
   ScaleWidth      =   5580
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame1 
      Caption         =   "Rotate all motors using the slider"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   120
      TabIndex        =   8
      Top             =   120
      Width           =   5415
      Begin MSComctlLib.Slider sldrRotate 
         Height          =   495
         Left            =   270
         TabIndex        =   9
         Top             =   480
         Width           =   4935
         _ExtentX        =   8705
         _ExtentY        =   873
         _Version        =   393216
         Min             =   -23
         Max             =   200
         SelStart        =   90
         TickFrequency   =   20
         Value           =   90
      End
   End
   Begin VB.Label lblSerialNumber 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2415
      TabIndex        =   7
      Top             =   2520
      Width           =   1935
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Serial Number:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   135
      TabIndex        =   6
      Top             =   2520
      Width           =   2175
   End
   Begin VB.Label lblNumMotors 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2415
      TabIndex        =   5
      Top             =   2160
      Width           =   1935
   End
   Begin VB.Label label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Number of Motors:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   135
      TabIndex        =   4
      Top             =   2160
      Width           =   2175
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Status:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   735
      TabIndex        =   3
      Top             =   1440
      Width           =   1575
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Current Angle:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   735
      TabIndex        =   2
      Top             =   1800
      Width           =   1575
   End
   Begin VB.Label lblMessage 
      Caption         =   "x"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2415
      TabIndex        =   1
      Top             =   1440
      Width           =   2415
   End
   Begin VB.Label lblAngle 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2415
      TabIndex        =   0
      Top             =   1800
      Width           =   1935
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     ServoSlider
' Author:      Chester Fitchett
' Date:        Feb 25, 2005
' Version:     1.0.2
' Description:
' -This example:
'    o lets a user interactively adjust the angle of all motors through a slider
'    o displays all the information it can about the PhidgetServo.
'    o is somewhat robust about ignoring other Phidget servos that are attached
'

Option Explicit
Dim WithEvents Servo As PhidgetServo
Attribute Servo.VB_VarHelpID = -1

Private Sub Form_Load()
    Set Servo = New PhidgetServo
    lblMessage.Caption = "Attach a PhidgetServo"
    Frame1.Visible = False
    sldrRotate.Min = -23
    sldrRotate.Max = 231
    sldrRotate.TickFrequency = 20
    Servo.Open
End Sub

'SERVO ATTACHING
Private Sub Servo_OnAttach()
    'Set up the slider
    Frame1.Visible = True
    sldrRotate.Value = 90
    sldrRotate_Scroll 'Will rotate the motors to angle 0

    'Show the current Servo information
    lblMessage.Caption = "PhidgetServo Attached"
    lblNumMotors.Caption = Servo.NumMotors
    lblSerialNumber.Caption = Servo.SerialNumber
End Sub

'SERVO DETACHING: Clean up.
Private Sub PhidgetManager_OnDetach()
    'Show the current Servo information
    lblMessage.Caption = "Attach a PhidgetServo "
    lblNumMotors.Caption = ""
    lblSerialNumber.Caption = ""
    lblAngle.Caption = ""
    Frame1.Visible = False
End Sub

Private Sub sldrRotate_Scroll()
    Dim Index As Long
    For Index = 0 To Servo.NumMotors - 1
        Servo.MotorPosition(Index) = sldrRotate.Value
        lblAngle.Caption = Servo.MotorPosition(Index)
    Next Index
End Sub

