VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form Form1 
   Caption         =   "Phidget Monitor"
   ClientHeight    =   3885
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5535
   LinkTopic       =   "Form1"
   ScaleHeight     =   3885
   ScaleWidth      =   5535
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command1 
      Caption         =   "Get Info on 0"
      Height          =   315
      Left            =   4080
      TabIndex        =   4
      Top             =   2880
      Width           =   1455
   End
   Begin MSComctlLib.ListView lvStatus 
      Height          =   2595
      Left            =   0
      TabIndex        =   0
      Top             =   240
      Width           =   5535
      _ExtentX        =   9763
      _ExtentY        =   4577
      View            =   3
      Sorted          =   -1  'True
      LabelWrap       =   -1  'True
      HideSelection   =   0   'False
      GridLines       =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin VB.Label lblLibraryVersion 
      Height          =   375
      Left            =   120
      TabIndex        =   3
      Top             =   3360
      Width           =   5295
   End
   Begin VB.Label Label1 
      Caption         =   "Library Information"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   0
      TabIndex        =   2
      Top             =   3000
      Width           =   2055
   End
   Begin VB.Label lblStatus 
      Caption         =   "Status"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   735
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Program:     PhidgetMonitor
' Author:      Saul Greenberg
' Date:        October 22, 2001
' Version:     1.1.0
' Description:
' - List all attached phidgets and error messages
' - If a previously seen phidget is detached, it is kept on the list
'   but its attached state is displayed as False
' What it shows you:
' - How to use the PhidgetManager to track devices
' - How to use the PHIDGET.IPhidget object to ask questons about that device

Option Explicit
Private WithEvents PM As PhidgetManager
Attribute PM.VB_VarHelpID = -1

Private Sub Command1_Click()
    Dim Device As String
    Dim Name As String
    Dim tag As String
    Dim serialNumber As Long
    Dim returnval As Long
    
    Device = PM.deviceType(0)
    Name = PM.deviceName(0)
    tag = PM.DeviceTag(0)
    serialNumber = PM.DeviceSerial(0)

    MsgBox Name
End Sub

Private Sub Form_Load()
    
    ' Ugly Hack to show the Library info if now phidgets are attached
    Dim Temp As PhidgetInterfaceKit
    Dim Count
    Set Temp = New PhidgetInterfaceKit
    lblLibraryVersion.Caption = Temp.LibraryVersion

    'Set up the lists where we will display our phidget state
    DisplayInitialize
    
    'Get the phidget manager going
    Set PM = New PhidgetManager
    PM.Start
    Count = PM.Count
End Sub

Private Sub PM_OnAttach(ByVal deviceType As String, ByVal deviceName As String, ByVal serialNumber As Long, ByVal tag As String)
    DisplayDevice deviceType, serialNumber, True
End Sub

Private Sub DisplayInitialize()
    Dim Divisions As Integer
   
    'Initialize the listview and properties (we could do this in the properties window instead)
    lvStatus.Sorted = True
    lvStatus.SortKey = 0
    lvStatus.SortOrder = lvwAscending
    lvStatus.View = lvwReport
    lvStatus.GridLines = True
   
    'Initialize the listview headers and column widths
    Divisions = 5
    lvStatus.ColumnHeaders.Add 1, , "Device Type", 3 * (lvStatus.Width / Divisions)
    lvStatus.ColumnHeaders.Add 2, , "Serial #", 1 * (lvStatus.Width / Divisions)
    lvStatus.ColumnHeaders.Add 3, , "Attached", 1 * (lvStatus.Width / Divisions)
End Sub

'Add or change a row in the listview to describe the phidget state
Private Sub DisplayDevice(deviceType As String, serialNumber As Long, Attached As Boolean)
    Dim L As ListItem
    Dim Found As Boolean
    
    Found = False                        'Is this particular phidget already in the list?
    For Each L In lvStatus.ListItems
        If L.Text & L.SubItems(1) = deviceType & serialNumber Then
            Found = True                 'Yup, it is.
            Exit For
        End If
    Next L
    
    'If this particular phidget is not in the list, add it.
    If Found = False Then
        Set L = lvStatus.ListItems.Add(1, , deviceType)
        L.SubItems(1) = CStr(serialNumber)
        
    End If
    L.SubItems(2) = CStr(Attached)
    L.Bold = Attached  'Bold the phidget if it is attached
End Sub

Private Sub PM_OnDetach(ByVal deviceType As String, ByVal deviceName As String, ByVal serialNumber As Long, ByVal tag As String)
    DisplayDevice deviceType, serialNumber, False
End Sub

