'A reference to the PhidgetNET.dll must be added to new projects in VB.Net
'From the "Project" menu select "Add Reference"
'From the "Add Reference" window select the "Browse" tab
'Browse to the directory you installed the Phidgets library to
'The default is "C:\Program Files\Phidgets"
'Select "PhidgetsNET.dll" and click "OK"
'To view objects that have been added, select the "View" menu
'Select "Object Browser"
'Then expand the PhidgetsNET.dll item

Public Class Form1
    Dim WithEvents IFK As Phidgets.InterfaceKit
    Private input_checkboxes As CheckBox()
    Private sensor_textboxes As TextBox()
 
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'To reduce code complexity we assume that there is one PhidgetInterfacekit
        'attached to the PC before the program is run.
        IFK = New Phidgets.InterfaceKit
        IFK.open()

        'Defaults for text fields
        txtStatus.Text = "Not Connected"

    End Sub
 
    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'If the form closes and the Phidget RFID is attached Close it.
        If IFK.Attached = True Then
            IFK.close()
        End If
    End Sub

    Private Sub ClickInputs(ByVal sender As Object, ByVal e As EventArgs)
        MessageBox.Show("You don't usually click an input " & DirectCast(sender, CheckBox).Tag.ToString)
    End Sub

    Private Sub ClickOutputs(ByVal sender As Object, ByVal e As EventArgs)
        'MessageBox.Show("Clicked was " & DirectCast(sender, CheckBox).CheckState.ToString)
        IFK.outputs(DirectCast(sender, CheckBox).Tag) = DirectCast(sender, CheckBox).CheckState
    End Sub

    Private Sub IFK_Attach1(ByVal sender As Object, ByVal e As Phidgets.Events.AttachEventArgs) Handles IFK.Attach
        'When the Phidget Intefacekit attaches update the form text boxes
        txtStatus.Text = "Connected"
        txtNumOutputs.Text = Str(IFK.outputs.Count)
        txtNumInputs.Text = Str(IFK.inputs.Count)
        txtNumSensors.Text = Str(IFK.sensors.Count)
        txtSerialNumber.Text = Str(IFK.SerialNumber)
        txtVersion.Text = Str(IFK.Version)

        'These statements are used to control the input check boxes later
        ReDim input_checkboxes(IFK.inputs.Count - 1)
        ReDim sensor_textboxes(IFK.sensors.Count - 1)

        'Dynamically create checkboxes for outputs and add the Click event handler
        For i As Integer = 0 To IFK.outputs.Count - 1
            Dim chkOutput As New CheckBox
            chkOutput.Location = New Drawing.Point(20, 170 + i * 20)
            chkOutput.Width = 20
            chkOutput.TabIndex = i
            chkOutput.Text = i.ToString
            chkOutput.Tag = i.ToString
            AddHandler chkOutput.Click, AddressOf ClickOutputs
            Controls.Add(chkOutput)
        Next
        'Dynamically create checkboxes for inputs, add the click event handler and
        'assign the checkbox to input_checkboxes array
        For i As Integer = 0 To IFK.inputs.Count - 1
            Dim chkInput As New CheckBox
            chkInput.Location = New Drawing.Point(110, 170 + i * 20)
            chkInput.Width = 20
            chkInput.TabIndex = i
            chkInput.Tag = i.ToString
            chkInput.Name = i.ToString
            chkInput.Text = chkInput.Tag.ToString
            AddHandler chkInput.Click, AddressOf ClickInputs
            Controls.Add(chkInput)
            input_checkboxes(i) = chkInput
        Next
        'Dynamically add textboxes for sensor values and assign them to an array
        For i As Integer = 0 To IFK.sensors.Count - 1
            Dim txtSensorValue As New TextBox
            txtSensorValue.Location = New Drawing.Point(185, 170 + i * 20)
            txtSensorValue.Width = 30
            txtSensorValue.TabIndex = i
            txtSensorValue.Tag = i.ToString
            txtSensorValue.Name = i.ToString
            Controls.Add(txtSensorValue)
            sensor_textboxes(i) = txtSensorValue
        Next
    End Sub

    Private Sub IFK_Detach1(ByVal sender As Object, ByVal e As Phidgets.Events.DetachEventArgs) Handles IFK.Detach
        txtStatus.Text = "Not Connected"
    End Sub

    Private Sub IFK_Error1(ByVal sender As Object, ByVal e As Phidgets.Events.ErrorEventArgs) Handles IFK.Error
        MessageBox.Show(e.desc)
        Me.Close()
    End Sub

    Private Sub IFK_InputChange1(ByVal sender As Object, ByVal e As Phidgets.Events.InputChangeEventArgs) Handles IFK.InputChange
        input_checkboxes(e.Index).Checked = e.Value
    End Sub

    Private Sub IFK_SensorChange(ByVal sender As Object, ByVal e As Phidgets.Events.SensorChangeEventArgs) Handles IFK.SensorChange
        sensor_textboxes(e.Index).Text = e.Value
    End Sub
End Class


