/*
 * Copyright 2006 Phidgets Inc.  All rights reserved.
 */

package com.phidgets.event;

import com.phidgets.Phidget;

public class ServoPositionChangeEvent
{
	Phidget source;
	int index;
	double value;

	public ServoPositionChangeEvent(Phidget source, int index, double value) {
		this.source = source;
		this.index = index;
		this.value = value;
	}

	public Phidget getSource() {
		return source;
	}

	public int getIndex() {
		return index;
	}

	public double getValue() {
		return value;
	}

	public String toString() {
		return source.toString() + " servo position " + index + " changed to "
		  + value;
	}
}
