/*
 * Copyright 2006 Phidgets Inc.  All rights reserved.
 */

package com.phidgets.event;

import com.phidgets.Phidget;

public class EncoderPositionChangeEvent
{
	Phidget source;
	int index;
	int value;
	int time;

	public EncoderPositionChangeEvent(Phidget source, int index, int time, int value) {
		this.source = source;
		this.index = index;
		this.value = value;
		this.time = time;
	}

	public Phidget getSource() {
		return source;
	}

	public int getIndex() {
		return index;
	}

	public int getValue() {
		return value;
	}

	public int getTime()
	{
		return time;
	}

	public String toString() {
		return source.toString() + " encoder position " + index + " changed to "
		  + value + " Time: " + time;
	}
}
