/*
 * Copyright 2006 Phidgets Inc.  All rights reserved.
 */

package com.phidgets.event;

import com.phidgets.Phidget;

public class AccelerationChangeEvent
{
	Phidget source;
	int index;
	double value;

	public AccelerationChangeEvent(Phidget source, int index, double value) {
		this.source = source;
		this.index = index;
		this.value = value;
	}

	public Phidget getSource() {
		return source;
	}

	public int getIndex() {
		return index;
	}

	public double getValue() {
		return value;
	}

	public String toString() {
		return source.toString() + " Acceleration " + index + " changed to "
		  + value;
	}
}
