/*
 * Copyright 2006 Phidgets Inc.  All rights reserved.
 */

package com.phidgets;
import java.util.Iterator;
import java.util.LinkedList;
import com.phidgets.event.*;
public final class WeightSensorPhidget extends Phidget {
	public WeightSensorPhidget() throws PhidgetException {
		super(create());
	}
	private static native long create() throws PhidgetException;
	public native double getWeight() throws PhidgetException;
	public native void setWeightChangeTrigger(double newVal) throws PhidgetException;
	public native double getWeightChangeTrigger() throws PhidgetException;

	protected final void enableDeviceSpecificEvents (boolean b) {
		enableWeightChangeEvents (b && weightChangeListeners.size () > 0);
	}
	private LinkedList weightChangeListeners = new LinkedList();
	private long nativeWeightChangeHandler = 0;
	public final void addWeightChangeListener(WeightChangeListener l) {
		synchronized (weightChangeListeners) {
			weightChangeListeners.add(l);
			enableWeightChangeEvents(true);
		}
	}
	public final void removeWeightChangeListener(WeightChangeListener l) {
		synchronized (weightChangeListeners) {
			weightChangeListeners.remove(l);
			enableWeightChangeEvents(weightChangeListeners.size() > 0);
		}
	}
	private void fireWeightChange(WeightChangeEvent e) {
		synchronized (weightChangeListeners) {
			for (Iterator it = weightChangeListeners.iterator(); it.hasNext(); )
				((WeightChangeListener)it.next()).weightChanged(e);
		}
	}
	private native void enableWeightChangeEvents(boolean b);
}
