/*
 * Copyright 2006 Phidgets Inc.  All rights reserved.
 */

package com.phidgets;
import java.util.Iterator;
import java.util.LinkedList;
import com.phidgets.event.*;
public final class TemperatureSensorPhidget extends Phidget {
	public TemperatureSensorPhidget() throws PhidgetException {
		super(create());
	}
	private static native long create() throws PhidgetException;
	public native int getSensorCount() throws PhidgetException;
	public native double getTemperature(int index) throws PhidgetException;
	public native void setTemperatureChangeTrigger(int index, double newVal) throws PhidgetException;
	public native double getTemperatureChangeTrigger(int index) throws PhidgetException;

	protected final void enableDeviceSpecificEvents (boolean b) {
		enableTemperatureChangeEvents (b && temperatureChangeListeners.size () > 0);
	}
	private LinkedList temperatureChangeListeners = new LinkedList();
	private long nativeTemperatureChangeHandler = 0;
	public final void addTemperatureChangeListener(TemperatureChangeListener l) {
		synchronized (temperatureChangeListeners) {
			temperatureChangeListeners.add(l);
			enableTemperatureChangeEvents(true);
		}
	}
	public final void removeTemperatureChangeListener(TemperatureChangeListener l) {
		synchronized (temperatureChangeListeners) {
			temperatureChangeListeners.remove(l);
			enableTemperatureChangeEvents(temperatureChangeListeners.size() > 0);
		}
	}
	private void fireTemperatureChange(TemperatureChangeEvent e) {
		synchronized (temperatureChangeListeners) {
			for (Iterator it = temperatureChangeListeners.iterator(); it.hasNext(); )
				((TemperatureChangeListener)it.next()).temperatureChanged(e);
		}
	}
	private native void enableTemperatureChangeEvents(boolean b);
}
