/*
 * Copyright 2006 Phidgets Inc.  All rights reserved.
 */

package com.phidgets;
import java.util.Iterator;
import java.util.LinkedList;
import com.phidgets.event.*;
public final class RFIDPhidget extends Phidget {
	public RFIDPhidget() throws PhidgetException {
		super(create());
	}
	private static native long create() throws PhidgetException;
	public native int getOutputCount() throws PhidgetException;
	public native boolean getOutputState(int index) throws PhidgetException;
	public native void setOutputState(int index, boolean state) throws PhidgetException;
	public native boolean getAntennaOn() throws PhidgetException;
	public native void setAntennaOn(boolean state) throws PhidgetException;
	public native boolean getLEDOn() throws PhidgetException;
	public native void setLEDOn(boolean state) throws PhidgetException;
	public native String getLastTag() throws PhidgetException;

	protected final void enableDeviceSpecificEvents (boolean b) {
		enableTagGainEvents (b && tagGainListeners.size () > 0);
		enableTagLossEvents (b && tagLossListeners.size () > 0);
		enableOutputChangeEvents (b && outputChangeListeners.size () > 0);
	}
	private LinkedList tagGainListeners = new LinkedList();
	private long nativeTagGainHandler = 0;
	public final void addTagGainListener(TagGainListener l) {
		synchronized (tagGainListeners) {
			tagGainListeners.add(l);
			enableTagGainEvents(true);
		}
	}
	public final void removeTagGainListener(TagGainListener l) {
		synchronized (tagGainListeners) {
			tagGainListeners.remove(l);
			enableTagGainEvents(tagGainListeners.size() > 0);
		}
	}
	private void fireTagGain(TagGainEvent e) {
		synchronized (tagGainListeners) {
			for (Iterator it = tagGainListeners.iterator(); it.hasNext(); )
				((TagGainListener)it.next()).tagGained(e);
		}
	}
	private native void enableTagGainEvents(boolean b);
	private LinkedList tagLossListeners = new LinkedList();
	private long nativeTagLossHandler = 0;
	public final void addTagLossListener(TagLossListener l) {
		synchronized (tagLossListeners) {
			tagLossListeners.add(l);
			enableTagLossEvents(true);
		}
	}
	public final void removeTagLossListener(TagLossListener l) {
		synchronized (tagLossListeners) {
			tagLossListeners.remove(l);
			enableTagLossEvents(tagLossListeners.size() > 0);
		}
	}
	private void fireTagLoss(TagLossEvent e) {
		synchronized (tagLossListeners) {
			for (Iterator it = tagLossListeners.iterator(); it.hasNext(); )
				((TagLossListener)it.next()).tagLost(e);
		}
	}
	private native void enableTagLossEvents(boolean b);
	private LinkedList outputChangeListeners = new LinkedList();
	private long nativeOutputChangeHandler = 0;
	public final void addOutputChangeListener(OutputChangeListener l) {
		synchronized (outputChangeListeners) {
			outputChangeListeners.add(l);
			enableOutputChangeEvents(true);
		}
	}
	public final void removeOutputChangeListener(OutputChangeListener l) {
		synchronized (outputChangeListeners) {
			outputChangeListeners.remove(l);
			enableOutputChangeEvents(outputChangeListeners.size() > 0);
		}
	}
	private void fireOutputChange(OutputChangeEvent e) {
		synchronized (outputChangeListeners) {
			for (Iterator it = outputChangeListeners.iterator(); it.hasNext(); )
				((OutputChangeListener)it.next()).outputChanged(e);
		}
	}
	private native void enableOutputChangeEvents(boolean b);
}
