/*
 * Copyright 2006 Phidgets Inc.  All rights reserved.
 */

package com.phidgets;
import java.util.Iterator;
import java.util.LinkedList;
import com.phidgets.event.*;
public final class PHSensorPhidget extends Phidget {
	public PHSensorPhidget() throws PhidgetException {
		super(create());
	}
	private static native long create() throws PhidgetException;
	public native double getPH() throws PhidgetException;
	public native double getPotential() throws PhidgetException;
	public native void setPHChangeTrigger(double newVal) throws PhidgetException;
	public native double getPHChangeTrigger() throws PhidgetException;

	protected final void enableDeviceSpecificEvents (boolean b) {
		enablePHChangeEvents (b && phChangeListeners.size () > 0);
	}
	private LinkedList phChangeListeners = new LinkedList();
	private long nativePHChangeHandler = 0;
	public final void addPHChangeListener(PHChangeListener l) {
		synchronized (phChangeListeners) {
			phChangeListeners.add(l);
			enablePHChangeEvents(true);
		}
	}
	public final void removePHChangeListener(PHChangeListener l) {
		synchronized (phChangeListeners) {
			phChangeListeners.remove(l);
			enablePHChangeEvents(phChangeListeners.size() > 0);
		}
	}
	private void firePHChange(PHChangeEvent e) {
		synchronized (phChangeListeners) {
			for (Iterator it = phChangeListeners.iterator(); it.hasNext(); )
				((PHChangeListener)it.next()).phChanged(e);
		}
	}
	private native void enablePHChangeEvents(boolean b);
}
