/*
 * Copyright 2006 Phidgets Inc.  All rights reserved.
 */

package com.phidgets;
import java.util.Iterator;
import java.util.LinkedList;
import com.phidgets.event.*;
public final class MotorControlPhidget extends Phidget {
	public MotorControlPhidget() throws PhidgetException {
		super(create());
	}
	private static native long create() throws PhidgetException;
	public native int getMotorCount() throws PhidgetException;
	public native int getInputCount() throws PhidgetException;
	public native boolean getInputState(int index) throws PhidgetException;
	public native double getAcceleration(int index) throws PhidgetException;
	public native void setAcceleration(int index, double acceleration) throws PhidgetException;
	public native double getSpeed(int index) throws PhidgetException;
	public native void setSpeed(int index, double speed) throws PhidgetException;

	protected final void enableDeviceSpecificEvents (boolean b) {
		enableMotorVelocityChangeEvents (b && motorVelocityChangeListeners.size () > 0);
		enableCurrentChangeEvents (b && currentChangeListeners.size () > 0);
		enableInputChangeEvents (b && inputChangeListeners.size () > 0);
	}
	private LinkedList motorVelocityChangeListeners = new LinkedList();
	private long nativeMotorVelocityChangeHandler = 0;
	public final void addMotorVelocityChangeListener(MotorVelocityChangeListener l) {
		synchronized (motorVelocityChangeListeners) {
			motorVelocityChangeListeners.add(l);
			enableMotorVelocityChangeEvents(true);
		}
	}
	public final void removeMotorVelocityChangeListener(MotorVelocityChangeListener l) {
		synchronized (motorVelocityChangeListeners) {
			motorVelocityChangeListeners.remove(l);
			enableMotorVelocityChangeEvents(motorVelocityChangeListeners.size() > 0);
		}
	}
	private void fireMotorVelocityChange(MotorVelocityChangeEvent e) {
		synchronized (motorVelocityChangeListeners) {
			for (Iterator it = motorVelocityChangeListeners.iterator(); it.hasNext(); )
				((MotorVelocityChangeListener)it.next()).motorVelocityChanged(e);
		}
	}
	private native void enableMotorVelocityChangeEvents(boolean b);
	private LinkedList currentChangeListeners = new LinkedList();
	private long nativeCurrentChangeHandler = 0;
	public final void addCurrentChangeListener(CurrentChangeListener l) {
		synchronized (currentChangeListeners) {
			currentChangeListeners.add(l);
			enableCurrentChangeEvents(true);
		}
	}
	public final void removeCurrentChangeListener(CurrentChangeListener l) {
		synchronized (currentChangeListeners) {
			currentChangeListeners.remove(l);
			enableCurrentChangeEvents(currentChangeListeners.size() > 0);
		}
	}
	private void fireCurrentChange(CurrentChangeEvent e) {
		synchronized (currentChangeListeners) {
			for (Iterator it = currentChangeListeners.iterator(); it.hasNext(); )
				((CurrentChangeListener)it.next()).currentChanged(e);
		}
	}
	private native void enableCurrentChangeEvents(boolean b);
	private LinkedList inputChangeListeners = new LinkedList();
	private long nativeInputChangeHandler = 0;
	public final void addInputChangeListener(InputChangeListener l) {
		synchronized (inputChangeListeners) {
			inputChangeListeners.add(l);
			enableInputChangeEvents(true);
		}
	}
	public final void removeInputChangeListener(InputChangeListener l) {
		synchronized (inputChangeListeners) {
			inputChangeListeners.remove(l);
			enableInputChangeEvents(inputChangeListeners.size() > 0);
		}
	}
	private void fireInputChange(InputChangeEvent e) {
		synchronized (inputChangeListeners) {
			for (Iterator it = inputChangeListeners.iterator(); it.hasNext(); )
				((InputChangeListener)it.next()).inputChanged(e);
		}
	}
	private native void enableInputChangeEvents(boolean b);
}
