/*
 * Copyright 2006 Phidgets Inc.  All rights reserved.
 */

package com.phidgets;
import java.util.Iterator;
import java.util.LinkedList;
import com.phidgets.event.*;
public final class AdvancedServoPhidget extends Phidget {
	public AdvancedServoPhidget() throws PhidgetException {
		super(create());
	}
	private static native long create() throws PhidgetException;
	public native int getMotorCount() throws PhidgetException;
	public native double getAcceleration(int index) throws PhidgetException;
	public native void setAcceleration(int index, double acceleration) throws PhidgetException;
	public native double getMaxVelocity(int index) throws PhidgetException;
	public native void setMaxVelocity(int index, double velocity) throws PhidgetException;
	public native double getPosition(int index) throws PhidgetException;
	public native void setPosition(int index, double position) throws PhidgetException;
	public native double getCurrent(int index) throws PhidgetException;

	protected final void enableDeviceSpecificEvents (boolean b) {
		enableServoPositionChangeEvents (b && servoPositionChangeListeners.size () > 0);
	}
	private LinkedList servoPositionChangeListeners = new LinkedList();
	private long nativeServoPositionChangeHandler = 0;
	public final void addServoPositionChangeListener(ServoPositionChangeListener l) {
		synchronized (servoPositionChangeListeners) {
			servoPositionChangeListeners.add(l);
			enableServoPositionChangeEvents(true);
		}
	}
	public final void removeServoPositionChangeListener(ServoPositionChangeListener l) {
		synchronized (servoPositionChangeListeners) {
			servoPositionChangeListeners.remove(l);
			enableServoPositionChangeEvents(servoPositionChangeListeners.size() > 0);
		}
	}
	private void fireServoPositionChange(ServoPositionChangeEvent e) {
		synchronized (servoPositionChangeListeners) {
			for (Iterator it = servoPositionChangeListeners.iterator(); it.hasNext(); )
				((ServoPositionChangeListener)it.next()).servoPositionChanged(e);
		}
	}
	private native void enableServoPositionChangeEvents(boolean b);
}
