/*
 * Copyright 2006 Phidgets Inc.  All rights reserved.
 */

package com.phidgets;
import java.util.Iterator;
import java.util.LinkedList;
import com.phidgets.event.*;
public final class AccelerometerPhidget extends Phidget {
	public AccelerometerPhidget() throws PhidgetException {
		super(create());
	}
	private static native long create() throws PhidgetException;
	public native int getAxisCount() throws PhidgetException;
	public native double getAcceleration(int index) throws PhidgetException;
	public native void setAccelerationChangeTrigger(int index, double newVal) throws PhidgetException;
	public native double getAccelerationChangeTrigger(int index) throws PhidgetException;

	protected final void enableDeviceSpecificEvents (boolean b) {
		enableAccelerationChangeEvents (b && accelerationChangeListeners.size () > 0);
	}
	private LinkedList accelerationChangeListeners = new LinkedList();
	private long nativeAccelerationChangeHandler = 0;
	public final void addAccelerationChangeListener(AccelerationChangeListener l) {
		synchronized (accelerationChangeListeners) {
			accelerationChangeListeners.add(l);
			enableAccelerationChangeEvents(true);
		}
	}
	public final void removeAccelerationChangeListener(AccelerationChangeListener l) {
		synchronized (accelerationChangeListeners) {
			accelerationChangeListeners.remove(l);
			enableAccelerationChangeEvents(accelerationChangeListeners.size() > 0);
		}
	}
	private void fireAccelerationChange(AccelerationChangeEvent e) {
		synchronized (accelerationChangeListeners) {
			for (Iterator it = accelerationChangeListeners.iterator(); it.hasNext(); )
				((AccelerationChangeListener)it.next()).accelerationChanged(e);
		}
	}
	private native void enableAccelerationChangeEvents(boolean b);
}
