
import com.phidgets.*;
import com.phidgets.event.*;

public class TextLCDExample
{
	public static final void main(String args[]) throws Exception {
		TextLCDPhidget lcd;

		System.out.println(Phidget.getLibraryVersion());


		lcd = new TextLCDPhidget();
		lcd.addAttachListener(new AttachListener() {
			public void attached(AttachEvent ae) {
				System.out.println("attachment of " + ae);
			}
		});
		lcd.addDetachListener(new DetachListener() {
			public void detached(DetachEvent ae) {
				System.out.println("detachment of " + ae);
			}
		});
		lcd.addErrorListener(new ErrorListener() {
			public void error(ErrorEvent ee) {
				System.out.println("error event for " + ee);
			}
		});

		lcd.openAny();
		System.out.println("waiting for TextLCD attachment...");
		lcd.waitForAttachment();

		System.out.println("Serial: " + lcd.getSerialNumber());
		System.out.println("rows: " + lcd.getRowCount());
		System.out.println("columns: " + lcd.getColumnCount());

		lcd.setDisplayString(0, "Hi There...");

		for (int i = 0; i < 100; i++)
		{
			lcd.setContrast(i);
			Thread.sleep(10);
		}

		lcd.setCustomCharacter(8, 0x0, 0xF8000);
		lcd.setCustomCharacter(9, 0x0, 0xFFC00);
		lcd.setCustomCharacter(10, 0x0, 0xFFFE0);
		lcd.setCustomCharacter(11, 0x0, 0xFFFFF);
		lcd.setCustomCharacter(12, 0xF8000, 0xFFFFF);
		lcd.setCustomCharacter(13, 0xFFC00, 0xFFFFF);
		lcd.setCustomCharacter(14, 0xFFFE0, 0xFFFFF);
		lcd.setCustomCharacter(15, 0xFFFFF, 0xFFFFF);

		lcd.setDisplayString(1, "\010\011\012\013\014\015\016\017"); //Note: representation is octal
		lcd.setBacklight(true);
		lcd.setCursorBlink(true);
		lcd.setCursor(true);

		System.out.print("closing...");
		lcd.close();
		lcd = null;
		System.out.println(" ok");
		if (false) {
			System.out.println("wait for finalization...");
			System.gc();
		}
	}
}
