

import com.phidgets.*;
import com.phidgets.event.*;

public class LEDExample
{
	public static final void main(String args[]) throws Exception {
		LEDPhidget led;

		System.out.println(Phidget.getLibraryVersion());


		led = new LEDPhidget();
		led.addAttachListener(new AttachListener() {
			public void attached(AttachEvent ae) {
				System.out.println("attachment of " + ae);
			}
		});
		led.addDetachListener(new DetachListener() {
			public void detached(DetachEvent ae) {
				System.out.println("detachment of " + ae);
			}
		});
		led.addErrorListener(new ErrorListener() {
			public void error(ErrorEvent ee) {
				System.out.println("error event for " + ee);
			}
		});

		led.openAny();
		System.out.println("waiting for LED attachment...");
		led.waitForAttachment();

		System.out.println("Serial: " + led.getSerialNumber());
		System.out.println("LEDs: " + led.getLEDCount());

		for (int j = 0; j < 10; j++)
		{
			for (int i = 0; i < led.getLEDCount(); i++)
			{
				led.setDiscreteLED(i, 100);
			}
			for (int i = 0; i < led.getLEDCount(); i++)
			{
				led.setDiscreteLED(i, 0);
			}
		}

		System.out.print("closing...");
		led.close();
		led = null;
		System.out.println(" ok");
		if (false) {
			System.out.println("wait for finalization...");
			System.gc();
		}
	}
}
