unit servo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, OleServer,PHIDGETEvents, PHIDGET_TLB ;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Label1: TLabel;
    TrackBar1: TTrackBar;
    PHIDGETIPhidgetServoEvents1: TPHIDGETIPhidgetServoEvents;
    procedure PHIDGETIPhidgetServoEvents1MotorPositionChange(Sender: TObject;
      Index: Integer; NewState: Single);
    procedure PHIDGETIPhidgetServoEvents1Detach(Sender: TObject);
    procedure PHIDGETIPhidgetServoEvents1Attach(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Servo1 : IPhidgetServo;
  MyManager : IPhidgetManager;

implementation

{$R *.dfm}

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  //move servo 1 according to the trackbar position
  Servo1.MotorPosition[0]:=TrackBar1.Position;
  //
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
    Servo1:=CoPhidgetServo.Create;
    PHIDGETIPhidgetServoEvents1.Connect(Servo1);
  label1.Caption := '';
  TrackBar1.Enabled:=FALSE;
  memo1.Clear;
    Servo1.Open(-1);
end;

procedure TForm1.PHIDGETIPhidgetServoEvents1Attach(Sender: TObject);
begin
          memo1.lines.add(Servo1.DeviceType+' Connected. Serial #'+IntToStr(Servo1.SerialNumber));

    //create a new servo object and open the servo, according to its serial

    TrackBar1.Enabled:=True;         // Only allow the trackbar if we're a Servo!

end;

procedure TForm1.PHIDGETIPhidgetServoEvents1Detach(Sender: TObject);
begin
  //disable the trackbar if a servo is disconnected
  memo1.lines.add(Servo1.DeviceType+' Disconnected. Serial #'+inttostr(Servo1.SerialNumber));
  TrackBar1.Enabled:=FALSE;
end;

procedure TForm1.PHIDGETIPhidgetServoEvents1MotorPositionChange(Sender: TObject;
  Index: Integer; NewState: Single);
begin
      label1.Caption := 'Position: ' + floattostr(NewState);
end;

end.
