{ *****************************************************************************
  WARNING: This component file was generated using the EventSinkImp utility.
           The contents of this file will be overwritten everytime EventSinkImp
           is asked to regenerate this sink component.

  NOTE:    When using this component at the same time with the XXX_TLB.pas in
           your Delphi projects, make sure you always put the XXX_TLB unit name
           AFTER this component unit name in the USES clause of the interface
           section of your unit; otherwise you may get interface conflict
           errors from the Delphi compiler.

           EventSinkImp is written by Binh Ly (bly@techvanguards.com)
  *****************************************************************************
  //Sink Classes//
  TPHIDGETIPhidgetManagerEvents
  TPHIDGETIPhidgetServoEvents
  TPHIDGETIPhidgetInterfaceKitEvents
  TPHIDGETIPhidgetRFIDEvents
  TPHIDGETIPhidgetWeightSensorEvents
  TPHIDGETIPhidgetTextLCDEvents
  TPHIDGETIPhidgetMotorControlEvents
  TPHIDGETIPhidgetAdvancedServoEvents
  TPHIDGETIPhidgetLEDEvents
  TPHIDGETIPhidgetEncoderEvents
  TPHIDGETIPhidgetStepperEvents
  TPHIDGETIPhidgetTemperatureSensorEvents
  TPHIDGETIPhidgetAccelerometerEvents
  TPHIDGETIPhidgetTextLEDEvents
}

{$IFDEF VER100}
{$DEFINE D3}
{$ENDIF}

//SinkUnitName//
unit PHIDGETEvents;

interface

uses
  Windows, ActiveX, Classes, ComObj, OleCtrls
  //SinkUses//
  , StdVCL
  , PHIDGET_TLB
  ;

type
  { backward compatibility types }
  {$IFDEF D3}
  OLE_COLOR = TOleColor;
  {$ENDIF}

  TPHIDGETEventsBaseSink = class (TComponent, IUnknown, IDispatch)
  protected
    { IUnknown }
    function QueryInterface(const IID: TGUID; out Obj): HResult; {$IFNDEF D3} override; {$ENDIF} stdcall;
    function _AddRef: Integer; stdcall;
    function _Release: Integer; stdcall;

    { IDispatch }
    function GetIDsOfNames(const IID: TGUID; Names: Pointer;
      NameCount, LocaleID: Integer; DispIDs: Pointer): HResult; virtual; stdcall;
    function GetTypeInfo(Index, LocaleID: Integer; out TypeInfo): HResult; virtual; stdcall;
    function GetTypeInfoCount(out Count: Integer): HResult; virtual; stdcall;
    function Invoke(DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var Params; VarResult, ExcepInfo, ArgErr: Pointer): HResult; virtual; stdcall;
  protected
    FCookie: integer;
    FCP: IConnectionPoint;
    FSinkIID: TGUID;
    FSource: IUnknown;
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; virtual; abstract;
  public
    destructor Destroy; override;
    procedure Connect (const ASource: IUnknown);
    procedure Disconnect;
    property SinkIID: TGUID read FSinkIID write FSinkIID;
    property Source: IUnknown read FSource;
  end;

  //SinkImportsForwards//

  //SinkImports//

  //SinkIntfStart//

  //SinkEventsForwards//
  T_IPhidgetManagerEventsOnAttachEvent = procedure (Sender: TObject; const DeviceType: WideString; const DeviceName: WideString; SerialNumber: Integer; const Tag: WideString) of object;
  T_IPhidgetManagerEventsOnDetachEvent = procedure (Sender: TObject; const DeviceType: WideString; const DeviceName: WideString; SerialNumber: Integer; const Tag: WideString) of object;

  //SinkComponent//
  TPHIDGETIPhidgetManagerEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach(const DeviceType: WideString; const DeviceName: WideString; SerialNumber: Integer; const Tag: WideString); safecall;
    procedure DoOnDetach(const DeviceType: WideString; const DeviceName: WideString; SerialNumber: Integer; const Tag: WideString); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetManagerEventsOnAttachEvent;
    FOnDetach: T_IPhidgetManagerEventsOnDetachEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetManagerEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetManagerEventsOnDetachEvent read FOnDetach write FOnDetach;
  end;


  //SinkEventsForwards//
  T_IPhidgetServoEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetServoEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetServoEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;
  T_IPhidgetServoEventsOnMotorPositionChangeEvent = procedure (Sender: TObject; Index: Integer; NewState: Single) of object;

  //SinkComponent//
  TPHIDGETIPhidgetServoEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
    procedure DoOnMotorPositionChange(Index: Integer; NewState: Single); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetServoEventsOnAttachEvent;
    FOnDetach: T_IPhidgetServoEventsOnDetachEvent;
    FOnError: T_IPhidgetServoEventsOnErrorEvent;
    FOnMotorPositionChange: T_IPhidgetServoEventsOnMotorPositionChangeEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetServoEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetServoEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetServoEventsOnErrorEvent read FOnError write FOnError;
    property OnMotorPositionChange: T_IPhidgetServoEventsOnMotorPositionChangeEvent read FOnMotorPositionChange write FOnMotorPositionChange;
  end;


  //SinkEventsForwards//
  T_IPhidgetInterfaceKitEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetInterfaceKitEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetInterfaceKitEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;
  T_IPhidgetInterfaceKitEventsOnInputChangeEvent = procedure (Sender: TObject; Index: Integer; NewState: WordBool) of object;
  T_IPhidgetInterfaceKitEventsOnSensorChangeEvent = procedure (Sender: TObject; Index: Integer; SensorValue: Integer) of object;
  T_IPhidgetInterfaceKitEventsOnOutputChangeEvent = procedure (Sender: TObject; Index: Integer; NewState: WordBool) of object;

  //SinkComponent//
  TPHIDGETIPhidgetInterfaceKitEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
    procedure DoOnInputChange(Index: Integer; NewState: WordBool); safecall;
    procedure DoOnSensorChange(Index: Integer; SensorValue: Integer); safecall;
    procedure DoOnOutputChange(Index: Integer; NewState: WordBool); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetInterfaceKitEventsOnAttachEvent;
    FOnDetach: T_IPhidgetInterfaceKitEventsOnDetachEvent;
    FOnError: T_IPhidgetInterfaceKitEventsOnErrorEvent;
    FOnInputChange: T_IPhidgetInterfaceKitEventsOnInputChangeEvent;
    FOnSensorChange: T_IPhidgetInterfaceKitEventsOnSensorChangeEvent;
    FOnOutputChange: T_IPhidgetInterfaceKitEventsOnOutputChangeEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetInterfaceKitEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetInterfaceKitEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetInterfaceKitEventsOnErrorEvent read FOnError write FOnError;
    property OnInputChange: T_IPhidgetInterfaceKitEventsOnInputChangeEvent read FOnInputChange write FOnInputChange;
    property OnSensorChange: T_IPhidgetInterfaceKitEventsOnSensorChangeEvent read FOnSensorChange write FOnSensorChange;
    property OnOutputChange: T_IPhidgetInterfaceKitEventsOnOutputChangeEvent read FOnOutputChange write FOnOutputChange;
  end;


  //SinkEventsForwards//
  T_IPhidgetRFIDEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetRFIDEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetRFIDEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;
  T_IPhidgetRFIDEventsOnTagEvent = procedure (Sender: TObject; const TagNumber: WideString) of object;
  T_IPhidgetRFIDEventsOnTagLostEvent = procedure (Sender: TObject; const TagNumber: WideString) of object;
  T_IPhidgetRFIDEventsOnOutputChangeEvent = procedure (Sender: TObject; Index: Integer; NewState: WordBool) of object;

  //SinkComponent//
  TPHIDGETIPhidgetRFIDEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
    procedure DoOnTag(const TagNumber: WideString); safecall;
    procedure DoOnTagLost(const TagNumber: WideString); safecall;
    procedure DoOnOutputChange(Index: Integer; NewState: WordBool); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetRFIDEventsOnAttachEvent;
    FOnDetach: T_IPhidgetRFIDEventsOnDetachEvent;
    FOnError: T_IPhidgetRFIDEventsOnErrorEvent;
    FOnTag: T_IPhidgetRFIDEventsOnTagEvent;
    FOnTagLost: T_IPhidgetRFIDEventsOnTagLostEvent;
    FOnOutputChange: T_IPhidgetRFIDEventsOnOutputChangeEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetRFIDEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetRFIDEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetRFIDEventsOnErrorEvent read FOnError write FOnError;
    property OnTag: T_IPhidgetRFIDEventsOnTagEvent read FOnTag write FOnTag;
    property OnTagLost: T_IPhidgetRFIDEventsOnTagLostEvent read FOnTagLost write FOnTagLost;
    property OnOutputChange: T_IPhidgetRFIDEventsOnOutputChangeEvent read FOnOutputChange write FOnOutputChange;
  end;


  //SinkEventsForwards//
  T_IPhidgetWeightSensorEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetWeightSensorEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetWeightSensorEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;
  T_IPhidgetWeightSensorEventsOnWeightChangeEvent = procedure (Sender: TObject; Weight: Double) of object;

  //SinkComponent//
  TPHIDGETIPhidgetWeightSensorEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
    procedure DoOnWeightChange(Weight: Double); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetWeightSensorEventsOnAttachEvent;
    FOnDetach: T_IPhidgetWeightSensorEventsOnDetachEvent;
    FOnError: T_IPhidgetWeightSensorEventsOnErrorEvent;
    FOnWeightChange: T_IPhidgetWeightSensorEventsOnWeightChangeEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetWeightSensorEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetWeightSensorEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetWeightSensorEventsOnErrorEvent read FOnError write FOnError;
    property OnWeightChange: T_IPhidgetWeightSensorEventsOnWeightChangeEvent read FOnWeightChange write FOnWeightChange;
  end;


  //SinkEventsForwards//
  T_IPhidgetTextLCDEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetTextLCDEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetTextLCDEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;

  //SinkComponent//
  TPHIDGETIPhidgetTextLCDEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetTextLCDEventsOnAttachEvent;
    FOnDetach: T_IPhidgetTextLCDEventsOnDetachEvent;
    FOnError: T_IPhidgetTextLCDEventsOnErrorEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetTextLCDEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetTextLCDEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetTextLCDEventsOnErrorEvent read FOnError write FOnError;
  end;


  //SinkEventsForwards//
  T_IPhidgetMotorControlEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetMotorControlEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetMotorControlEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;
  T_IPhidgetMotorControlEventsOnInputChangeEvent = procedure (Sender: TObject; Index: Integer; NewState: WordBool) of object;
  T_IPhidgetMotorControlEventsOnMotorChangeEvent = procedure (Sender: TObject; Index: Integer; newVal: Double) of object;

  //SinkComponent//
  TPHIDGETIPhidgetMotorControlEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
    procedure DoOnInputChange(Index: Integer; NewState: WordBool); safecall;
    procedure DoOnMotorChange(Index: Integer; newVal: Double); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetMotorControlEventsOnAttachEvent;
    FOnDetach: T_IPhidgetMotorControlEventsOnDetachEvent;
    FOnError: T_IPhidgetMotorControlEventsOnErrorEvent;
    FOnInputChange: T_IPhidgetMotorControlEventsOnInputChangeEvent;
    FOnMotorChange: T_IPhidgetMotorControlEventsOnMotorChangeEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetMotorControlEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetMotorControlEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetMotorControlEventsOnErrorEvent read FOnError write FOnError;
    property OnInputChange: T_IPhidgetMotorControlEventsOnInputChangeEvent read FOnInputChange write FOnInputChange;
    property OnMotorChange: T_IPhidgetMotorControlEventsOnMotorChangeEvent read FOnMotorChange write FOnMotorChange;
  end;


  //SinkEventsForwards//
  T_IPhidgetAdvancedServoEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetAdvancedServoEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetAdvancedServoEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;
  T_IPhidgetAdvancedServoEventsOnPositionChangeEvent = procedure (Sender: TObject; Index: Integer; Position: Single) of object;

  //SinkComponent//
  TPHIDGETIPhidgetAdvancedServoEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
    procedure DoOnPositionChange(Index: Integer; Position: Single); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetAdvancedServoEventsOnAttachEvent;
    FOnDetach: T_IPhidgetAdvancedServoEventsOnDetachEvent;
    FOnError: T_IPhidgetAdvancedServoEventsOnErrorEvent;
    FOnPositionChange: T_IPhidgetAdvancedServoEventsOnPositionChangeEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetAdvancedServoEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetAdvancedServoEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetAdvancedServoEventsOnErrorEvent read FOnError write FOnError;
    property OnPositionChange: T_IPhidgetAdvancedServoEventsOnPositionChangeEvent read FOnPositionChange write FOnPositionChange;
  end;


  //SinkEventsForwards//
  T_IPhidgetLEDEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetLEDEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetLEDEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;

  //SinkComponent//
  TPHIDGETIPhidgetLEDEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetLEDEventsOnAttachEvent;
    FOnDetach: T_IPhidgetLEDEventsOnDetachEvent;
    FOnError: T_IPhidgetLEDEventsOnErrorEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetLEDEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetLEDEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetLEDEventsOnErrorEvent read FOnError write FOnError;
  end;


  //SinkEventsForwards//
  T_IPhidgetEncoderEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetEncoderEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetEncoderEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;
  T_IPhidgetEncoderEventsOnInputChangeEvent = procedure (Sender: TObject; Index: Integer; NewState: WordBool) of object;
  T_IPhidgetEncoderEventsOnPositionChangeEvent = procedure (Sender: TObject; Index: Integer; Time: Integer; EncoderDisplacement: Integer) of object;

  //SinkComponent//
  TPHIDGETIPhidgetEncoderEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
    procedure DoOnInputChange(Index: Integer; NewState: WordBool); safecall;
    procedure DoOnPositionChange(Index: Integer; Time: Integer; EncoderDisplacement: Integer); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetEncoderEventsOnAttachEvent;
    FOnDetach: T_IPhidgetEncoderEventsOnDetachEvent;
    FOnError: T_IPhidgetEncoderEventsOnErrorEvent;
    FOnInputChange: T_IPhidgetEncoderEventsOnInputChangeEvent;
    FOnPositionChange: T_IPhidgetEncoderEventsOnPositionChangeEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetEncoderEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetEncoderEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetEncoderEventsOnErrorEvent read FOnError write FOnError;
    property OnInputChange: T_IPhidgetEncoderEventsOnInputChangeEvent read FOnInputChange write FOnInputChange;
    property OnPositionChange: T_IPhidgetEncoderEventsOnPositionChangeEvent read FOnPositionChange write FOnPositionChange;
  end;


  //SinkEventsForwards//
  T_IPhidgetStepperEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetStepperEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetStepperEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;
  T_IPhidgetStepperEventsOnInputChangeEvent = procedure (Sender: TObject; Index: Integer; NewState: WordBool) of object;
  T_IPhidgetStepperEventsOnPositionChangeEvent = procedure (Sender: TObject; Index: Integer; newVal: Double) of object;

  //SinkComponent//
  TPHIDGETIPhidgetStepperEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
    procedure DoOnInputChange(Index: Integer; NewState: WordBool); safecall;
    procedure DoOnPositionChange(Index: Integer; newVal: Double); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetStepperEventsOnAttachEvent;
    FOnDetach: T_IPhidgetStepperEventsOnDetachEvent;
    FOnError: T_IPhidgetStepperEventsOnErrorEvent;
    FOnInputChange: T_IPhidgetStepperEventsOnInputChangeEvent;
    FOnPositionChange: T_IPhidgetStepperEventsOnPositionChangeEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetStepperEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetStepperEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetStepperEventsOnErrorEvent read FOnError write FOnError;
    property OnInputChange: T_IPhidgetStepperEventsOnInputChangeEvent read FOnInputChange write FOnInputChange;
    property OnPositionChange: T_IPhidgetStepperEventsOnPositionChangeEvent read FOnPositionChange write FOnPositionChange;
  end;


  //SinkEventsForwards//
  T_IPhidgetTemperatureSensorEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetTemperatureSensorEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetTemperatureSensorEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;
  T_IPhidgetTemperatureSensorEventsOnTemperatureChangeEvent = procedure (Sender: TObject; Index: Integer; Temperature: Single) of object;

  //SinkComponent//
  TPHIDGETIPhidgetTemperatureSensorEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
    procedure DoOnTemperatureChange(Index: Integer; Temperature: Single); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetTemperatureSensorEventsOnAttachEvent;
    FOnDetach: T_IPhidgetTemperatureSensorEventsOnDetachEvent;
    FOnError: T_IPhidgetTemperatureSensorEventsOnErrorEvent;
    FOnTemperatureChange: T_IPhidgetTemperatureSensorEventsOnTemperatureChangeEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetTemperatureSensorEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetTemperatureSensorEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetTemperatureSensorEventsOnErrorEvent read FOnError write FOnError;
    property OnTemperatureChange: T_IPhidgetTemperatureSensorEventsOnTemperatureChangeEvent read FOnTemperatureChange write FOnTemperatureChange;
  end;


  //SinkEventsForwards//
  T_IPhidgetAccelerometerEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetAccelerometerEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetAccelerometerEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;
  T_IPhidgetAccelerometerEventsOnAccelerationChangeEvent = procedure (Sender: TObject; Index: Integer; Acceleration: Double) of object;

  //SinkComponent//
  TPHIDGETIPhidgetAccelerometerEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
    procedure DoOnAccelerationChange(Index: Integer; Acceleration: Double); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetAccelerometerEventsOnAttachEvent;
    FOnDetach: T_IPhidgetAccelerometerEventsOnDetachEvent;
    FOnError: T_IPhidgetAccelerometerEventsOnErrorEvent;
    FOnAccelerationChange: T_IPhidgetAccelerometerEventsOnAccelerationChangeEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetAccelerometerEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetAccelerometerEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetAccelerometerEventsOnErrorEvent read FOnError write FOnError;
    property OnAccelerationChange: T_IPhidgetAccelerometerEventsOnAccelerationChangeEvent read FOnAccelerationChange write FOnAccelerationChange;
  end;


  //SinkEventsForwards//
  T_IPhidgetTextLEDEventsOnAttachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetTextLEDEventsOnDetachEvent = procedure (Sender: TObject) of object;
  T_IPhidgetTextLEDEventsOnErrorEvent = procedure (Sender: TObject; const Description: WideString; SCODE: Integer) of object;

  //SinkComponent//
  TPHIDGETIPhidgetTextLEDEvents = class (TPHIDGETEventsBaseSink
    //ISinkInterface//
  )
  protected
    function DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
      VarResult, ExcepInfo, ArgErr: Pointer): HResult; override;

    //ISinkInterfaceMethods//
  public
    { system methods }
    constructor Create (AOwner: TComponent); override;
  protected
    //SinkInterface//
    procedure DoOnAttach; safecall;
    procedure DoOnDetach; safecall;
    procedure DoOnError(const Description: WideString; SCODE: Integer); safecall;
  protected
    //SinkEventsProtected//
    FOnAttach: T_IPhidgetTextLEDEventsOnAttachEvent;
    FOnDetach: T_IPhidgetTextLEDEventsOnDetachEvent;
    FOnError: T_IPhidgetTextLEDEventsOnErrorEvent;
  published
    //SinkEventsPublished//
    property OnAttach: T_IPhidgetTextLEDEventsOnAttachEvent read FOnAttach write FOnAttach;
    property OnDetach: T_IPhidgetTextLEDEventsOnDetachEvent read FOnDetach write FOnDetach;
    property OnError: T_IPhidgetTextLEDEventsOnErrorEvent read FOnError write FOnError;
  end;

  //SinkIntfEnd//

procedure Register;

implementation

uses
  SysUtils;

{ globals }

procedure BuildPositionalDispIds (pDispIds: PDispIdList; const dps: TDispParams);
var
  i: integer;
begin
  Assert (pDispIds <> nil);
  
  { by default, directly arrange in reverse order }
  for i := 0 to dps.cArgs - 1 do
    pDispIds^ [i] := dps.cArgs - 1 - i;

  { check for named args }
  if (dps.cNamedArgs <= 0) then Exit;

  { parse named args }
  for i := 0 to dps.cNamedArgs - 1 do
    pDispIds^ [dps.rgdispidNamedArgs^ [i]] := i;
end;


{ TPHIDGETEventsBaseSink }

function TPHIDGETEventsBaseSink.GetIDsOfNames(const IID: TGUID; Names: Pointer;
  NameCount, LocaleID: Integer; DispIDs: Pointer): HResult;
begin
  Result := E_NOTIMPL;
end;

function TPHIDGETEventsBaseSink.GetTypeInfo(Index, LocaleID: Integer; out TypeInfo): HResult;
begin
  Result := E_NOTIMPL;
  pointer (TypeInfo) := nil;
end;

function TPHIDGETEventsBaseSink.GetTypeInfoCount(out Count: Integer): HResult;
begin
  Result := E_NOTIMPL;
  Count := 0;
end;

function TPHIDGETEventsBaseSink.Invoke(DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var Params; VarResult, ExcepInfo, ArgErr: Pointer): HResult;
var
  dps: TDispParams absolute Params;
  bHasParams: boolean;
  pDispIds: PDispIdList;
  iDispIdsSize: integer;
begin
  { validity checks }
  if (Flags AND DISPATCH_METHOD = 0) then
    raise Exception.Create (
      Format ('%s only supports sinking of method calls!', [ClassName]
    ));

  { build pDispIds array. this maybe a bit of overhead but it allows us to
    sink named-argument calls such as Excel's AppEvents, etc!
  }
  pDispIds := nil;
  iDispIdsSize := 0;
  bHasParams := (dps.cArgs > 0);
  if (bHasParams) then
  begin
    iDispIdsSize := dps.cArgs * SizeOf (TDispId);
    GetMem (pDispIds, iDispIdsSize);
  end;  { if }

  try
    { rearrange dispids properly }
    if (bHasParams) then BuildPositionalDispIds (pDispIds, dps);
    Result := DoInvoke (DispId, IID, LocaleID, Flags, dps, pDispIds, VarResult, ExcepInfo, ArgErr);
  finally
    { free pDispIds array }
    if (bHasParams) then FreeMem (pDispIds, iDispIdsSize);
  end;  { finally }
end;

function TPHIDGETEventsBaseSink.QueryInterface(const IID: TGUID; out Obj): HResult;
begin
  if (GetInterface (IID, Obj)) then
  begin
    Result := S_OK;
    Exit;
  end
  else
    if (IsEqualIID (IID, FSinkIID)) then
      if (GetInterface (IDispatch, Obj)) then
      begin
        Result := S_OK;
        Exit;
      end;
  Result := E_NOINTERFACE;
  pointer (Obj) := nil;
end;

function TPHIDGETEventsBaseSink._AddRef: Integer;
begin
  Result := 2;
end;

function TPHIDGETEventsBaseSink._Release: Integer;
begin
  Result := 1;
end;

destructor TPHIDGETEventsBaseSink.Destroy;
begin
  Disconnect;
  inherited;
end;

procedure TPHIDGETEventsBaseSink.Connect (const ASource: IUnknown);
var
  pcpc: IConnectionPointContainer;
begin
  Assert (ASource <> nil);
  Disconnect;
  try
    OleCheck (ASource.QueryInterface (IConnectionPointContainer, pcpc));
    OleCheck (pcpc.FindConnectionPoint (FSinkIID, FCP));
    OleCheck (FCP.Advise (Self, FCookie));
    FSource := ASource;
  except
    raise Exception.Create (Format ('Unable to connect %s.'#13'%s',
      [Name, Exception (ExceptObject).Message]
    ));
  end;  { finally }
end;

procedure TPHIDGETEventsBaseSink.Disconnect;
begin
  if (FSource = nil) then Exit;
  try
    OleCheck (FCP.Unadvise (FCookie));
    FCP := nil;
    FSource := nil;
  except
    pointer (FCP) := nil;
    pointer (FSource) := nil;
  end;  { except }
end;


//SinkImplStart//

function TPHIDGETIPhidgetManagerEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].bstrval, dps.rgvarg^ [pDispIds^ [2]].lval, dps.rgvarg^ [pDispIds^ [3]].bstrval);
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].bstrval, dps.rgvarg^ [pDispIds^ [2]].lval, dps.rgvarg^ [pDispIds^ [3]].bstrval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetManagerEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetManagerEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetManagerEvents.DoOnAttach(const DeviceType: WideString; const DeviceName: WideString; SerialNumber: Integer; const Tag: WideString);
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self, DeviceType, DeviceName, SerialNumber, Tag);
end;

procedure TPHIDGETIPhidgetManagerEvents.DoOnDetach(const DeviceType: WideString; const DeviceName: WideString; SerialNumber: Integer; const Tag: WideString);
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self, DeviceType, DeviceName, SerialNumber, Tag);
end;



function TPHIDGETIPhidgetServoEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
      4 :
      begin
        DoOnMotorPositionChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].fltval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetServoEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetServoEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetServoEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetServoEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetServoEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;

procedure TPHIDGETIPhidgetServoEvents.DoOnMotorPositionChange(Index: Integer; NewState: Single);
begin
  if not Assigned (OnMotorPositionChange) then System.Exit;
  OnMotorPositionChange (Self, Index, NewState);
end;



function TPHIDGETIPhidgetInterfaceKitEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
      4 :
      begin
        DoOnInputChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].vbool);
        Result := S_OK;
      end;
      5 :
      begin
        DoOnSensorChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
      6 :
      begin
        DoOnOutputChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].vbool);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetInterfaceKitEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetInterfaceKitEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetInterfaceKitEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetInterfaceKitEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetInterfaceKitEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;

procedure TPHIDGETIPhidgetInterfaceKitEvents.DoOnInputChange(Index: Integer; NewState: WordBool);
begin
  if not Assigned (OnInputChange) then System.Exit;
  OnInputChange (Self, Index, NewState);
end;

procedure TPHIDGETIPhidgetInterfaceKitEvents.DoOnSensorChange(Index: Integer; SensorValue: Integer);
begin
  if not Assigned (OnSensorChange) then System.Exit;
  OnSensorChange (Self, Index, SensorValue);
end;

procedure TPHIDGETIPhidgetInterfaceKitEvents.DoOnOutputChange(Index: Integer; NewState: WordBool);
begin
  if not Assigned (OnOutputChange) then System.Exit;
  OnOutputChange (Self, Index, NewState);
end;



function TPHIDGETIPhidgetRFIDEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
      4 :
      begin
        DoOnTag (dps.rgvarg^ [pDispIds^ [0]].bstrval);
        Result := S_OK;
      end;
      5 :
      begin
        DoOnTagLost (dps.rgvarg^ [pDispIds^ [0]].bstrval);
        Result := S_OK;
      end;
      6 :
      begin
        DoOnOutputChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].vbool);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetRFIDEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetRFIDEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetRFIDEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetRFIDEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetRFIDEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;

procedure TPHIDGETIPhidgetRFIDEvents.DoOnTag(const TagNumber: WideString);
begin
  if not Assigned (OnTag) then System.Exit;
  OnTag (Self, TagNumber);
end;

procedure TPHIDGETIPhidgetRFIDEvents.DoOnTagLost(const TagNumber: WideString);
begin
  if not Assigned (OnTagLost) then System.Exit;
  OnTagLost (Self, TagNumber);
end;

procedure TPHIDGETIPhidgetRFIDEvents.DoOnOutputChange(Index: Integer; NewState: WordBool);
begin
  if not Assigned (OnOutputChange) then System.Exit;
  OnOutputChange (Self, Index, NewState);
end;



function TPHIDGETIPhidgetWeightSensorEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
      4 :
      begin
        DoOnWeightChange (dps.rgvarg^ [pDispIds^ [0]].dblval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetWeightSensorEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetWeightSensorEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetWeightSensorEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetWeightSensorEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetWeightSensorEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;

procedure TPHIDGETIPhidgetWeightSensorEvents.DoOnWeightChange(Weight: Double);
begin
  if not Assigned (OnWeightChange) then System.Exit;
  OnWeightChange (Self, Weight);
end;



function TPHIDGETIPhidgetTextLCDEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetTextLCDEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetTextLCDEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetTextLCDEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetTextLCDEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetTextLCDEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;



function TPHIDGETIPhidgetMotorControlEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
      4 :
      begin
        DoOnInputChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].vbool);
        Result := S_OK;
      end;
      5 :
      begin
        DoOnMotorChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].dblval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetMotorControlEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetMotorControlEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetMotorControlEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetMotorControlEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetMotorControlEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;

procedure TPHIDGETIPhidgetMotorControlEvents.DoOnInputChange(Index: Integer; NewState: WordBool);
begin
  if not Assigned (OnInputChange) then System.Exit;
  OnInputChange (Self, Index, NewState);
end;

procedure TPHIDGETIPhidgetMotorControlEvents.DoOnMotorChange(Index: Integer; newVal: Double);
begin
  if not Assigned (OnMotorChange) then System.Exit;
  OnMotorChange (Self, Index, newVal);
end;



function TPHIDGETIPhidgetAdvancedServoEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
      4 :
      begin
        DoOnPositionChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].fltval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetAdvancedServoEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetAdvancedServoEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetAdvancedServoEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetAdvancedServoEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetAdvancedServoEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;

procedure TPHIDGETIPhidgetAdvancedServoEvents.DoOnPositionChange(Index: Integer; Position: Single);
begin
  if not Assigned (OnPositionChange) then System.Exit;
  OnPositionChange (Self, Index, Position);
end;



function TPHIDGETIPhidgetLEDEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetLEDEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetLEDEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetLEDEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetLEDEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetLEDEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;



function TPHIDGETIPhidgetEncoderEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
      4 :
      begin
        DoOnInputChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].vbool);
        Result := S_OK;
      end;
      5 :
      begin
        DoOnPositionChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].lval, dps.rgvarg^ [pDispIds^ [2]].lval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetEncoderEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetEncoderEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetEncoderEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetEncoderEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetEncoderEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;

procedure TPHIDGETIPhidgetEncoderEvents.DoOnInputChange(Index: Integer; NewState: WordBool);
begin
  if not Assigned (OnInputChange) then System.Exit;
  OnInputChange (Self, Index, NewState);
end;

procedure TPHIDGETIPhidgetEncoderEvents.DoOnPositionChange(Index: Integer; Time: Integer; EncoderDisplacement: Integer);
begin
  if not Assigned (OnPositionChange) then System.Exit;
  OnPositionChange (Self, Index, Time, EncoderDisplacement);
end;



function TPHIDGETIPhidgetStepperEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
      4 :
      begin
        DoOnInputChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].vbool);
        Result := S_OK;
      end;
      5 :
      begin
        DoOnPositionChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].dblval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetStepperEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetStepperEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetStepperEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetStepperEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetStepperEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;

procedure TPHIDGETIPhidgetStepperEvents.DoOnInputChange(Index: Integer; NewState: WordBool);
begin
  if not Assigned (OnInputChange) then System.Exit;
  OnInputChange (Self, Index, NewState);
end;

procedure TPHIDGETIPhidgetStepperEvents.DoOnPositionChange(Index: Integer; newVal: Double);
begin
  if not Assigned (OnPositionChange) then System.Exit;
  OnPositionChange (Self, Index, newVal);
end;



function TPHIDGETIPhidgetTemperatureSensorEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
      4 :
      begin
        DoOnTemperatureChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].fltval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetTemperatureSensorEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetTemperatureSensorEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetTemperatureSensorEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetTemperatureSensorEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetTemperatureSensorEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;

procedure TPHIDGETIPhidgetTemperatureSensorEvents.DoOnTemperatureChange(Index: Integer; Temperature: Single);
begin
  if not Assigned (OnTemperatureChange) then System.Exit;
  OnTemperatureChange (Self, Index, Temperature);
end;



function TPHIDGETIPhidgetAccelerometerEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
      4 :
      begin
        DoOnAccelerationChange (dps.rgvarg^ [pDispIds^ [0]].lval, dps.rgvarg^ [pDispIds^ [1]].dblval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetAccelerometerEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetAccelerometerEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetAccelerometerEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetAccelerometerEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetAccelerometerEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;

procedure TPHIDGETIPhidgetAccelerometerEvents.DoOnAccelerationChange(Index: Integer; Acceleration: Double);
begin
  if not Assigned (OnAccelerationChange) then System.Exit;
  OnAccelerationChange (Self, Index, Acceleration);
end;



function TPHIDGETIPhidgetTextLEDEvents.DoInvoke (DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var dps: TDispParams; pDispIds: PDispIdList;
  VarResult, ExcepInfo, ArgErr: Pointer): HResult;
type
  POleVariant = ^OleVariant;
begin
  Result := DISP_E_MEMBERNOTFOUND;

  //SinkInvoke//
    case DispId of
      1 :
      begin
        DoOnAttach ();
        Result := S_OK;
      end;
      2 :
      begin
        DoOnDetach ();
        Result := S_OK;
      end;
      3 :
      begin
        DoOnError (dps.rgvarg^ [pDispIds^ [0]].bstrval, dps.rgvarg^ [pDispIds^ [1]].lval);
        Result := S_OK;
      end;
    end;  { case }
  //SinkInvokeEnd//
end;

constructor TPHIDGETIPhidgetTextLEDEvents.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  //SinkInit//
  FSinkIID := _IPhidgetTextLEDEvents;
end;

//SinkImplementation//
procedure TPHIDGETIPhidgetTextLEDEvents.DoOnAttach;
begin
  if not Assigned (OnAttach) then System.Exit;
  OnAttach (Self);
end;

procedure TPHIDGETIPhidgetTextLEDEvents.DoOnDetach;
begin
  if not Assigned (OnDetach) then System.Exit;
  OnDetach (Self);
end;

procedure TPHIDGETIPhidgetTextLEDEvents.DoOnError(const Description: WideString; SCODE: Integer);
begin
  if not Assigned (OnError) then System.Exit;
  OnError (Self, Description, SCODE);
end;


//SinkImplEnd//

procedure Register;
begin
  //SinkRegisterStart//
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetManagerEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetServoEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetInterfaceKitEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetRFIDEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetWeightSensorEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetTextLCDEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetMotorControlEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetAdvancedServoEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetLEDEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetEncoderEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetStepperEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetTemperatureSensorEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetAccelerometerEvents]);
  RegisterComponents ('ActiveX', [TPHIDGETIPhidgetTextLEDEvents]);
  //SinkRegisterEnd//
end;

end.
