using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Phidgets;
using Phidgets.Events;

namespace phidgetsNETnativeTest
{
    public partial class Form1 : Form
    {
        InterfaceKit ifkit;
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            ifkit = new InterfaceKit();
            ifkit.Attach += new AttachEventHandler(ifkit_Attach);
            ifkit.Detach += new DetachEventHandler(ifkit_Detach);
            ifkit.SensorChange += new SensorChangeEventHandler(ifkit_SensorChange);
            ifkit.InputChange += new InputChangeEventHandler(ifkit_InputChange);
            ifkit.open();
        }

        void ifkit_InputChange(object sender, InputChangeEventArgs e)
        {
            switch (e.Index)
            {
                case 0:
                    inputCheckBox0.Checked = e.Value;
                    break;
                case 1:
                    inputCheckBox1.Checked = e.Value;
                    break;
                case 2:
                    inputCheckBox2.Checked = e.Value;
                    break;
                case 3:
                    inputCheckBox3.Checked = e.Value;
                    break;
                case 4:
                    inputCheckBox4.Checked = e.Value;
                    break;
                case 5:
                    inputCheckBox5.Checked = e.Value;
                    break;
                case 6:
                    inputCheckBox6.Checked = e.Value;
                    break;
                case 7:
                    inputCheckBox7.Checked = e.Value;
                    break;
            }
        }

        void ifkit_SensorChange(object sender, SensorChangeEventArgs e)
        {
            switch (e.Index)
            {
                case 0:
                    AnalogBar0.Value = e.Value;
                    sense0.Text = "" + e.Value;
                    break;
                case 1:
                    AnalogBar1.Value = e.Value;
                    sense1.Text = "" + e.Value;
                    break;
                case 2:
                    AnalogBar2.Value = e.Value;
                    sense2.Text = "" + e.Value;
                    break;
                case 3:
                    AnalogBar3.Value = e.Value;
                    sense3.Text = "" + e.Value;
                    break;
                case 4:
                    AnalogBar4.Value = e.Value;
                    sense4.Text = "" + e.Value;
                    break;
                case 5:
                    AnalogBar5.Value = e.Value;
                    sense5.Text = "" + e.Value;
                    break;
                case 6:
                    AnalogBar6.Value = e.Value;
                    sense6.Text = "" + e.Value;
                    break;
                case 7:
                    AnalogBar7.Value = e.Value;
                    sense7.Text = "" + e.Value;
                    break;
            }
        }

        void ifkit_Detach(object sender, DetachEventArgs e)
        {
            attachedLabel.Text = "Not Attached";
        }

        private void ifkit_Attach(object sender, AttachEventArgs e)
        {
            InterfaceKit phid = (InterfaceKit)sender;
            attachedLabel.Text = "Attached: " + phid.Name;
            serialLabel.Text = " Serial: " + phid.SerialNumber;
            versionLabel.Text = " Version: " + phid.Version;

            ratiometricCheckBox.Checked = phid.ratiometric;
            label1.Text = "I/O: " + phid.sensors.Count + "/" + phid.inputs.Count + "/" + phid.outputs.Count;
        }

        private void outputCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            System.Windows.Forms.CheckBox checkBox = (System.Windows.Forms.CheckBox)sender;
            ifkit.outputs[int.Parse(checkBox.Tag.ToString())] = checkBox.Checked;
        }

        private void ratiometricCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            ifkit.ratiometric = ratiometricCheckBox.Checked;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            ifkit.close();
        }


    }
}

