using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Phidgets;
using Phidgets.Events;

namespace EncoderTest
{
    public partial class Form1 : Form
    {
        Phidgets.Encoder enc;
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            enc = new Phidgets.Encoder();
            enc.Attach += new AttachEventHandler(enc_Attach);
            enc.Detach += new DetachEventHandler(enc_Detach);
            enc.InputChange += new InputChangeEventHandler(enc_InputChange);
            enc.PositionChange += new EncoderPositionChangeEventHandler(enc_PositionChange);
            enc.open();
        }

        void enc_PositionChange(object sender, EncoderPositionChangeEventArgs e)
        {
            switch (e.Index)
            {
                case 0:
                    sense0.Text = "" + enc.encoders[0];
                    AnalogBar0.Value = enc.encoders[0];
                    break;
                case 1:
                    sense1.Text = "" + enc.encoders[1];
                    AnalogBar1.Value = enc.encoders[1];
                    break;
                case 2:
                    sense2.Text = "" + enc.encoders[2];
                    AnalogBar2.Value = enc.encoders[2];
                    break;
                case 3:
                    sense3.Text = "" + enc.encoders[3];
                    AnalogBar3.Value = enc.encoders[3];
                    break;
            }
        }

        void enc_InputChange(object sender, InputChangeEventArgs e)
        {
            switch (e.Index)
            {
                case 0:
                    inputCheckBox0.Checked = e.Value;
                    break;
                case 1:
                    inputCheckBox1.Checked = e.Value;
                    break;
                case 2:
                    inputCheckBox2.Checked = e.Value;
                    break;
                case 3:
                    inputCheckBox3.Checked = e.Value;
                    break;
            }
        }

        void enc_Detach(object sender, DetachEventArgs e)
        {
            attachedLabel.Text = "Not Attached";
        }

        void enc_Attach(object sender, AttachEventArgs e)
        {
            Phidgets.Encoder phid = (Phidgets.Encoder)sender;
            attachedLabel.Text = "Attached: " + phid.Name;
            serialLabel.Text = " Serial: " + phid.SerialNumber;
            versionLabel.Text = " Version: " + phid.Version;

            numEncodersLabel.Text = "Encoders: " + phid.encoders.Count;
            numInputsLabel.Text = "Inputs: " + phid.inputs.Count;
        }
    }
}