using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Phidgets;
using Phidgets.Events;

namespace AccelerometerExample
{
    public partial class Form1 : Form
    {
        Accelerometer accel;
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            accel = new Accelerometer();
            accel.Attach += new AttachEventHandler(accel_Attach);
            accel.Detach += new DetachEventHandler(accel_Detach);
            accel.AccelerationChange += new AccelerationChangeEventHandler(accel_AccelerationChange);
            accel.open();
        }

        void accel_AccelerationChange(object sender, AccelerationChangeEventArgs e)
        {
            switch (e.Index)
            {
                case 0:
                    xaxisLabel.Text = "X-Axis: " + accel.axes[0].Acceleration;
                    break;
                case 1:
                    yaxisLabel.Text = "Y-Axis: " + e.Acceleration;
                    break;
                case 2:
                    zaxisLabel.Text = "Z-Axis: " + e.Acceleration;
                    break;
            }
        }

        void accel_Detach(object sender, DetachEventArgs e)
        {
            if(!accel.Attached)
                attachedLabel.Text = "Not Attached";
        }

        void accel_Attach(object sender, AttachEventArgs e)
        {
            Accelerometer phid = (Accelerometer)sender;
            if (accel.Attached)
                attachedLabel.Text = "Attached: " + phid.Name;
            serialLabel.Text = " Serial: " + phid.SerialNumber;
            versionLabel.Text = " Version: " + phid.Version;

            ioLabel.Text = "Axes: " + phid.axes.Count;
        }
    }
}