
import com.phidgets.*;
import com.phidgets.event.*;

public class OpenIFKitExample
{
	public static final void main(String args[]) throws Exception {
		InterfaceKitPhidget ik;

		System.out.println(Phidget.getLibraryVersion());

		//Create new IFKit and configure
		ik = new InterfaceKitPhidget();
		
		ik.addAttachListener(new AttachListener() {
			public void attached(AttachEvent ae) {
				System.out.println("attachment of " + ae);
			}
		});
		ik.addDetachListener(new DetachListener() {
			public void detached(DetachEvent ae) {
				System.out.println("detachment of " + ae);
			}
		});
		ik.addErrorListener(new ErrorListener() {
			public void error(ErrorEvent ee) {
				System.out.println("error event for " + ee);
			}
		});
		ik.addInputChangeListener(new InputChangeListener() {
			public void inputChanged(InputChangeEvent oe) {
				System.out.println(oe);
			}
		});
		ik.addOutputChangeListener(new OutputChangeListener() {
			public void outputChanged(OutputChangeEvent oe) {
				System.out.println(oe);
			}
		});
		ik.addSensorChangeListener(new SensorChangeListener() {
			public void sensorChanged(SensorChangeEvent se) {
				System.out.println(se);
			}
		});

		//Open device and wait for attachment
		ik.openAny();
		System.out.println("waiting for InterfaceKit attachment...");
		ik.waitForAttachment();
		
		//Finish
		System.out.println("Outputting events.  Input to stop.");
		System.in.read();
		System.out.print("closing...");
		ik.close();
		ik = null;
		
		System.out.println(" ok");
	}
}
