/*
 * Copyright 2006 Phidgets Inc.  All rights reserved.
 */


import com.phidgets.*;
import com.phidgets.event.*;

public class ManagerExample
{
	public static final void main(String args[]) throws Exception {
		Manager man;

		System.out.println(Phidget.getLibraryVersion());

		//Create Manager and configure
		man = new Manager();
		man.addAttachListener(new AttachListener()
		{
			public void attached(AttachEvent ae) {
				System.out.println("attachment of " + ae);
			}
		});
		man.addDetachListener(new DetachListener()
		{
			public void detached(DetachEvent ae) {
				System.out.println("detachment of " + ae);
			}
		});

		//Begin managing
		man.start();

		//Finish up
		System.out.println("Press any key to exit...");
		System.in.read();

		man.close();
		man = null;

		System.out.println(" ok");
	}
}
