import com.phidgets.InterfaceKitPhidget;
import com.phidgets.Phidget;
import com.phidgets.RFIDPhidget;
import com.phidgets.TextLCDPhidget;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import com.phidgets.event.DetachEvent;
import com.phidgets.event.DetachListener;
import com.phidgets.event.ErrorEvent;
import com.phidgets.event.ErrorListener;
import com.phidgets.event.InputChangeEvent;
import com.phidgets.event.InputChangeListener;
import com.phidgets.event.OutputChangeEvent;
import com.phidgets.event.OutputChangeListener;
import com.phidgets.event.SensorChangeEvent;
import com.phidgets.event.SensorChangeListener;
import com.phidgets.event.TagGainEvent;
import com.phidgets.event.TagGainListener;
import com.phidgets.event.TagLossEvent;
import com.phidgets.event.TagLossListener;

//Display the values of the sensor changes and toggle the display with the RFID
public class Demo2 implements SensorChangeListener, TagGainListener, TagLossListener{

	InterfaceKitPhidget ik;
	TextLCDPhidget lcd;
	RFIDPhidget rfid;
		
	public Demo2() throws Exception{
		initInterface();
		initLCD();
		initRFID(); //bind to RFID Reader
	}

	public static void main(String[] args) throws Exception{
		System.out.println(Phidget.getLibraryVersion());
	
		Demo2 demo2 = new Demo2();
	}

	private void initInterface() throws Exception{
		ik = new InterfaceKitPhidget();
		ik.addAttachListener(new AttachListener() {
			public void attached(AttachEvent ae) {
				System.out.println("attachment of " + ae);
			}
		});
		ik.addDetachListener(new DetachListener() {
			public void detached(DetachEvent ae) {
				System.out.println("detachment of " + ae);
			}
		});
		ik.addErrorListener(new ErrorListener() {
			public void error(ErrorEvent ee) {
				System.out.println("error event for " + ee);
			}
		});
		ik.addInputChangeListener(new InputChangeListener() {
			public void inputChanged(InputChangeEvent oe) {
				System.out.println(oe);
			}
		});
		ik.addOutputChangeListener(new OutputChangeListener() {
			public void outputChanged(OutputChangeEvent oe) {
				System.out.println(oe);
			}
		});

		ik.openAny();
		System.out.println("waiting for InterfaceKit attachment...");
		ik.waitForAttachment();
		
		ik.setSensorChangeTrigger(0,50);
		ik.setSensorChangeTrigger(1,50);

	}
	
	private void initLCD() throws Exception {
		
		//create and set handlers
		lcd = new TextLCDPhidget();				

		lcd.addAttachListener(new AttachListener() {
			public void attached(AttachEvent ae) {
				System.out.println("attachment of " + ae);
			}
		});
		lcd.addDetachListener(new DetachListener() {
			public void detached(DetachEvent ae) {
				System.out.println("detachment of " + ae);
			}
		});
		lcd.addErrorListener(new ErrorListener() {
				public void error(ErrorEvent ee) {
				System.out.println("error event for " + ee);
			}
		});

		//Open and ensure attachment
		lcd.openAny();
					
		System.out.println("waiting for TextLCD attachment...");
		lcd.waitForAttachment();

		System.out.println("Serial: " + lcd.getSerialNumber());
		System.out.println("rows: " + lcd.getRowCount());
		System.out.println("columns: " + lcd.getColumnCount());
	}
	
	private void initRFID() throws Exception{
		
		rfid = new RFIDPhidget();
		
		rfid.addAttachListener(new AttachListener() {
			public void attached(AttachEvent ae) {
				System.out.println("attachment of " + ae);
			}
		});
		rfid.addDetachListener(new DetachListener() {
			public void detached(DetachEvent ae) {
				System.out.println("detachment of " + ae);
			}
		});
		rfid.addErrorListener(new ErrorListener() {
			public void error(ErrorEvent ee) {
				System.out.println("error event for " + ee);
			}
		});
		rfid.addOutputChangeListener(new OutputChangeListener()
		{
			public void outputChanged(OutputChangeEvent oe)
			{
				System.out.println(oe);
			}
		});
		
		rfid.addTagGainListener(this);
		rfid.addTagLossListener(this);
		
		//open first available RFIDReader
		rfid.openAny();

		//Print RFID info after attachment
		System.out.println("waiting for RFID attachment...");		
		rfid.waitForAttachment();
		
		System.out.println("Serial: " + rfid.getSerialNumber());
		System.out.println("Outputs: " + rfid.getOutputCount());

		rfid.setAntennaOn(true);
	}

	//What happens when a sensor value changes on IFKit
	public void sensorChanged(SensorChangeEvent arg0) {
		
		try{
			
			if(lcd.getBacklight()){
				if (arg0.getIndex() == 0)
					lcd.setDisplayString(0, Integer.toString(arg0.getValue()));
				else
					lcd.setDisplayString(1, Integer.toString(arg0.getValue()));
			}
		}
		catch(Exception x){}		
	}

	//What happens when RFID tag is read
	public void tagGained(TagGainEvent arg0) {
		try{
			
			ik.addSensorChangeListener(this);
			
			lcd.setBacklight(true);
			lcd.setDisplayString(0, Integer.toString(ik.getSensorValue(0)));
			lcd.setDisplayString(1, Integer.toString(ik.getSensorValue(1)));			
		}
		catch(Exception x){}
	}

	//What happens when RFID tag stops
	public void tagLost(TagLossEvent arg0) {
		try{
			ik.removeSensorChangeListener(this);
			lcd.setBacklight(false);
			lcd.setDisplayString(0, "");
			lcd.setDisplayString(1, "");
		}
		catch(Exception x){}
	}	

}
