import com.phidgets.Phidget;
import com.phidgets.RFIDPhidget;
import com.phidgets.TextLCDPhidget;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import com.phidgets.event.DetachEvent;
import com.phidgets.event.DetachListener;
import com.phidgets.event.ErrorEvent;
import com.phidgets.event.ErrorListener;
import com.phidgets.event.OutputChangeEvent;
import com.phidgets.event.OutputChangeListener;
import com.phidgets.event.TagGainEvent;
import com.phidgets.event.TagGainListener;
import com.phidgets.event.TagLossEvent;
import com.phidgets.event.TagLossListener;

//Read a tag and print it on the LCD
public class Demo1 implements TagGainListener, TagLossListener{

	//members
	RFIDPhidget rfid;
	TextLCDPhidget lcd;

	public Demo1() throws Exception {
		initRFID(); //bind to RFID Reader
		initLCD();	//bind to LCD
	}
	
	public static void main(String[] args) throws Exception {
		System.out.println(Phidget.getLibraryVersion());
		Demo1 d = new Demo1();
	}

	private void initRFID() throws Exception{
	
		rfid = new RFIDPhidget();
		
		rfid.addAttachListener(new AttachListener() {
			public void attached(AttachEvent ae) {
				System.out.println("attachment of " + ae);
			}
		});
		rfid.addDetachListener(new DetachListener() {
			public void detached(DetachEvent ae) {
				System.out.println("detachment of " + ae);
			}
		});
		rfid.addErrorListener(new ErrorListener() {
			public void error(ErrorEvent ee) {
				System.out.println("error event for " + ee);
			}
		});
		rfid.addOutputChangeListener(new OutputChangeListener()
		{
			public void outputChanged(OutputChangeEvent oe)
			{
				System.out.println(oe);
			}
		});
		
		rfid.addTagGainListener(this);
		rfid.addTagLossListener(this);
		
		//open first available RFIDReader
		rfid.openAny();

		//Print RFID info after attachment
		System.out.println("waiting for RFID attachment...");		
		rfid.waitForAttachment();
		
		rfid.setAntennaOn(true);
	}
	
	private void initLCD() throws Exception {
		
		//create and set handlers
		lcd = new TextLCDPhidget();				

		lcd.addAttachListener(new AttachListener() {
			public void attached(AttachEvent ae) {
				System.out.println("attachment of " + ae);
			}
		});
		lcd.addDetachListener(new DetachListener() {
			public void detached(DetachEvent ae) {
				System.out.println("detachment of " + ae);
			}
		});
		lcd.addErrorListener(new ErrorListener() {
				public void error(ErrorEvent ee) {
				System.out.println("error event for " + ee);
			}
		});

		//Open and ensure attachment
		lcd.openAny();
					
		System.out.println("waiting for TextLCD attachment...");
		lcd.waitForAttachment();
	}
	
	//Print the tag read from the display
	public void tagGained(TagGainEvent arg0) {
		try{
			rfid.setLEDOn(true);
			lcd.setBacklight(true);
			
			for (int i = 0; i < arg0.getValue().length(); i++){
				lcd.setDisplayString(0, arg0.getValue().substring(0, i));
				Thread.sleep(100);
			}
		}
		catch(Exception x){
			System.out.println(x.getMessage());
		}
	}

	//Remove the tag from the display
	public void tagLost(TagLossEvent arg0) {
		try{
			rfid.setLEDOn(false);

			for (int i = arg0.getValue().length(); i > -1; i--){
				lcd.setDisplayString(0, arg0.getValue().substring(0, i));
				Thread.sleep(100);
			}

			lcd.setBacklight(false);
		}
		catch(Exception x){}
	}	

}
