% This script demonstare a Modified-CS reconstruction from 
% Randomly undersmapled Fourier samples of a larynx sequence.

clear all
randn('state',0)
rand('state',0)

load larynxsequence



  
N0=size(larynximage);

N=N0(1:2);

seqlen=N0(3);
    
m=prod(N);

%%%%generate n=0.5m sampling mask
%%%%We want to sample more in low frequency regions. genSampling gives more samples in central regions(low frequency regions for fftshifted 2D Fourier transform)
[pdf,val] = genPDF(N,2,0.5,2,0,0);  
[mask1,stat,NN] = genSampling(pdf,100,10);
mask1=fftshift(mask1);            
 
%%%%%generate n=0.16m sampling mask
%%%%%genSampling only can generate the required mask for n>=0.25m samples.
%%%%%for n<0.25m, we can multiply another mask whose distribution is only generated on
%%%%%the half central regions.
[pdf,val] = genPDF(N,2,0.25,2,0,0);
[mask2,stat,NN] = genSampling(pdf,100,10);
mask2=fftshift(mask2);
 
maskreduce=ones(N);            %for n<0.25m mask 

[pdf,val] = genPDF(N/2,2,0.3,2,0,0);   %Change the samples for maskreduce to reduce samples for mask2
[maskreduce(N(1)/4+1:N(1)/4*3,N(2)/4+1:N(2)/4*3),stat,NN] = genSampling(pdf,100,10);
maskreduce=fftshift(maskreduce);
mask2=mask2.*maskreduce;

AFr= dftmtx(N(1))/sqrt(N(1));

%%%%%generate wavelet transform matrix
L=2;                             %Decomposition level
dwtmode('per'); 
X=eye(N);
W=zeros(N);                      %wavelet transform matrix for 2D transform
for p=1:N(1)
       [W(:,p),L2] = wavedec(X(:,p),L,'db4'); % wavelet base is Daubecies 4
end


%%%%%define measurement matrices using function handle 

%%%% z is the wavelet coefficient, W is wavelet matrix, mask1 is sampling
%%%% mask. Measurement matrix is Partial Fourier matrix times inverse Wavelet matrix.
%A1 is to do inverse 2D wavelet on z first and generate 2D
%%%% undersasmpled Fourier transform by applying mask1.
A1 = @(z) Fr(z, W, mask1);        %A1

%%%% A1' which is an inverse operation of A1
At1 = @(z) Frt(z, W, mask1);      %A1'

A2 = @(z) Fr(z, W, mask2);        %A2

At2 = @(z) Frt(z, W, mask2);      %A2'


for seq=1:seqlen


     larynxseq(:,seq)=reshape(W*larynximage(:,:,seq)*W',prod(N),1);
   
end

%%%%%geneate measurements,at t=1 using n0 measurements,at t>1 using n
%%%%%measurements
for seq=1:seqlen
    
    if seq==1
         y{seq}=A1(larynxseq(:,seq));
    else
         y{seq}=A2(larynxseq(:,seq));
    end
end
% 
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% %%Run CS

for seq=1:seqlen
    
        
       if seq==1
           A=A1;
           At=At1;
           mask=mask1;
       else
           A=A2;
           At=At2;
           mask=mask2;
       end
        
       %%%%Initial estimation
         x0=At(y{seq});
         
       %%%%Do CS
         x = l1eq_pd(x0, A,At, y{seq}, 1e-3,25,1e-10,800); 
         
         xhatcs(:,seq)=x;  %Reconstructed Wavelet Coeff.
         
         xhatcsimage(:,:,seq)=W'*reshape(xhatcs(:,seq),N)*W; %Reconstructed image
         
             
    %%%%Compute rMSE       
    error_cs(seq)=norm(xhatcs(:,seq)-larynxseq(:,seq))/norm(larynxseq(:,seq))
end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%%Run Modified-CS
thresholdmodcs=10;                         %Threshold for modified-CS to obtain support


%%%%%Compute rMSE
for seq=1:seqlen
        if seq==1
           A=A1;
           At=At1;
           mask=mask1;
           x0= xhatcs(:,seq); % Initial estimate for t=1 is CS reconstruction at t=1;
           
       else
           A=A2;
           At=At2;
           mask=mask2;
           x0=xhatmodcs(:,seq-1); %Intial estimate for t>1 is ModCS reconstruction at t-1
           
        end
       
       T=find(abs(x0)>thresholdmodcs);  %Kown part of support
       
        P=ones(length(x0),1);   %P is a vector used as a parameter to set known support

        P(T)=0;                 %P_{T}=0  P_{T^c}=1;
        
        %%%%Run Modified CS function
        x = l1eqmodcs_large(x0, A,At, y{seq}, P,mask,1e-3,20,1e-9,1200); 
        
        xhatmodcs(:,seq)=x;  %Reconstructed Wavelet Coeff.
         
        xhatmodcsimage(:,:,seq)=W'*reshape(xhatmodcs(:,seq),N)*W; %Reconstructed image
        
        
        %%%%Compute rMSE 
        error_modcs(seq)=norm(xhatmodcs(:,seq)-larynxseq(:,seq))/norm(larynxseq(:,seq))
        
end


