%%%%%%%%%%%%%%This is a demo of cardiac sequence%%%%%
%%%%%The simulated sequence is sparse in wavelet domain and |Nt|=0.10m,|delta_t|<0.01m 
%%%%%Before running the code, you need to install cvx software
%%%%%http://www.stanford.edu/~boyd/cvx/
clear
randn('state',0);
load cardiacsequence

%%%%This stored cardiac data contain 1D reshaped wavelet coefficients and original 2D image domain data,
m=size(cardiacseq,1);         %size of each frame
seqlen=size(cardiacseq,2);    %length of the sequence
N=[sqrt(m) sqrt(m)];

%%%%%generate wavelet transform matrix
L=2;                             %Decomposition level
dwtmode('per'); 
X=eye(N);
W=zeros(N);                      %wavelet transform matrix for 2D transform
for p=1:N(1)
       [W(:,p),L2] = wavedec(X(:,p),L,'db4'); % wavelet base is Daubecies 4
end

W1D=kron(W,W);   %1D transform wavelet matrix 



%%%%%%%%Generate Gaussian with wavelet measurement matrix%% 

A1=randn(round(0.5*m),m);  %Gaussian matrix with n=0.5m measurements for the first frame
A1 = orth(A1')'*W1D';                  %Measurement matrix=Gaussian+wavelet


A2=randn(round(0.19*m),m); %Gaussian matrix with n=0.19m measurements for the t>1 frames 
A2 = orth(A2')'*W1D';                 %Measurement matrix=Gaussian+wavelet




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%For the sparsified cardiac sequence%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%generate measurements%%
for seq=1:seqlen
    
    if seq==1
         y{seq}=A1*sparsecardiacseq(:,seq);
    else
         y{seq}=A2*sparsecardiacseq(:,seq);
    end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%Run CS
xhatcs=simplecs_sequential(A1,A2,y);

%%%%%Compute rMSE
for seq=1:seqlen

    error_cs(seq)=norm(xhatcs(:,seq)-sparsecardiacseq(:,seq))/norm(sparsecardiacseq(:,seq));
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%Run Modified-CS
thresholdmodcs=1;                         %Threshold for modified-CS to obtain support
xhatmodcs=Modifiedcs_sequential(A1,A2,y,thresholdmodcs);

%%%%%Compute rMSE
for seq=1:seqlen

    error_modcs(seq)=norm(xhatmodcs(:,seq)-sparsecardiacseq(:,seq))/norm(sparsecardiacseq(:,seq));
end

%%%%%For the true non-sparsified cardiac sequence
% %%%%%%%%%%%%%%%%%%%%%%%%%generate measurements%%
for seq=1:seqlen
    
    if seq==1
         y{seq}=A1*cardiacseq(:,seq);
    else
         y{seq}=A2*cardiacseq(:,seq);
    end
end
% 
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% %%Run CS
xhatcscomp=simplecs_sequential(A1,A2,y);

%%%%%Compute rMSE
for seq=1:seqlen

    error_cscomp(seq)=norm(xhatcscomp(:,seq)-cardiacseq(:,seq))/norm(cardiacseq(:,seq));
end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%%Run Modified-CS
thresholdmodcscomp=20;                         %Threshold for modified-CS to obtain support
xhatmodcscomp=Modifiedcs_sequential(A1,A2,y,thresholdmodcscomp);

%%%%%Compute rMSE
for seq=1:seqlen

    error_modcscomp(seq)=norm(xhatmodcscomp(:,seq)-cardiacseq(:,seq))/norm(cardiacseq(:,seq));
end




