%%%%%%%%%%%%%%%%%%%%%%%Modified-CS%%%%%%%%%%
function [xhat]=Modifedcs_sequential(A1,A2,y,thresholdmodcs)           
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%A1 is measurement matrix for the first frame, A2 is for t>1 frames, y
%%%%%is the measured signal sequence, thresholdmodcs is the threshold to
%%%%%obtain the support

seqlen=length(y);   %length of the sequence

m=size(A1,2);       %size of the data

%%%%%%%%%%%%%%%Initial: Do CS for first frame%%%%
%%% min ||x||_1 s.t. y=Ax
cvx_begin
                  
        variable x(m); 
    
        minimize( norm(x,1) ) ;
    
        subject to
    
                A1*x == y{1};
           
cvx_end 

%%%%x is the reconstruction by CS 
T=find(abs(x)>thresholdmodcs);  % Find the support for first frame

for seq=1:seqlen
    
    if seq==1
        
        A=A1;
        
    else 
        A=A2;   % For t>1 frames, measurements quantity is reduced.
    end

   Tc=eye(m);
   
   Tc(T,T)=0;  % make x on set T to be 0
   
%%%%%Do modified-CS%%%%%%
%%%%%min ||x_{Tc}||_1  s.t. yt=Ax
%%%%%Equivalent form: min||Tc*x||_1,s.t. yt=Ax

    cvx_begin
                  
        variable x(m); 
    
        minimize( norm(Tc*x,1) ) ;
    
        subject to
    
                A*x == y{seq};
           
    cvx_end 
    
    xhat(:,seq)=x;  %Reconstructed sequence
    
    T=find(abs(x)>thresholdmodcs);   %Update the support
    
end
            