%To run the code: runsims_final,
%set run_kfcs = 1 to run kfcs, genie kf, edit save command as desired
%set run_cs = 1 to run regularcs, regularcs_no_noise, edit save command
%data saved in different files: see save command

%If you use this code, please cite:
%N. Vaswani, Kalman Filtered Compressed Sensing, ICIP 2008

randn('state',0); rand('state',0); disp('random state 0 on')

%set parameters
global n
global m
global tot
global lambdap
global S

tot = 80 %130 %100 %130
m = 256;    n = 72;
Sav =  16 ; %8 16 25; % round( n/log2(m/n) ) %S1 = S - 2;
cc = 1; %10 %multiply 'sigma' and 'a' by 'cc'
sigma0 =  cc* (1/3)*sqrt(Sav/n)
sigsys = 1;
siginit = 3;
lambdap = 4 %4 %beta = 2; lambdap = sqrt( (1+beta)*2*log2(m) ); prob_lb = 1 - 1/( sqrt(pi*log2(m))*m^beta )

%t2 = 5;

Agen = (1/sqrt(n)) * randn(n,m);
A = zeros(size(Agen));
for col = 1:m
    A(:,col) = Agen(:,col)/norm( Agen(:,col) );
end
R = (sigma0^2)*eye(n);
Q = (sigsys^2)*eye(m); %F = eye(m);
Pi0 = (siginit^2)*eye(m);

run_cs = 0;
run_kfcs = 1;

for ct = 1: 100 %[2,22,71]
    gendata_full
    if (ct > 17)
        if run_kfcs
            %[x_upd_lscs,T_hat_lscs,x_upd_csres] = lscs_full(y,Pi0,A,Q,R);
            %[x_upd_lscs_nodelete,T_hat_lscs_nodelete,x_upd_csres_nodelete] = lscs_full_nodelete(y,Pi0,A,Q,R);
            % [x_upd,T_hat] = kfcs_full(y,Pi0,A,Q,R);
            % [x_upd_nodelete,T_hat_nodelete] = kfcs_full_nodelete(y,Pi0,A,Q,R);
            [x_upd_kfcsls_nodelete,T_hat_kfcsls_nodelete] = kfcsls_full_nodelete(y,Pi0,A,Q,R);
            [x_upd_kfcsls,T_hat_kfcsls] = kfcsls_full(y,Pi0,A,Q,R);
            %kfcs_full %cskf_auto_T1unknown% [x_upd,T_hat,x1_upd] = cskf_auto_T1unknown(y,Pi0,A,Q,R);

            for t = 1:tot
                % err_csres(ct,t) = norm( x(:,t)-x_upd_csres(:,t) )^2;
                % err_lscs(ct,t) = norm( x(:,t)-x_upd_lscs(:,t) )^2;
                % err_lscs_nodelete(ct,t) = norm( x(:,t)-x_upd_lscs_nodelete(:,t) )^2;
                % err_csres_nodelete(ct,t) = norm( x(:,t)-x_upd_csres_nodelete(:,t) )^2;
                %   err(ct,t) = norm( x(:,t)-x_upd(:,t) )^2;
                %  err_nodelete(ct,t) = norm( x(:,t)-x_upd_nodelete(:,t) )^2;
                err_kfcsls_nodelete(ct,t) = norm( x(:,t)-x_upd_kfcsls_nodelete(:,t) )^2;
                err_kfcsls(ct,t) = norm( x(:,t)-x_upd_kfcsls(:,t) )^2;
                energy(ct,t) = norm( x(:,t) )^2;
            end
            %        disp(err(ct,:));
            % not_detected(ct) = length(setdiff(T,T_hat))
            %extra_detected(ct) = length(setdiff(T_hat,T))

            [x_upd_genie] = geniekf_full(y,Pi0,A,Q,R,Tt);
            for t = 1:tot
                err_genie(ct,t) = norm( x(:,t)-x_upd_genie(:,t) )^2;
            end
            save(['temp0_kfcsls_',num2str(ct)])%kfcs3
            %save(['temp_kfcsls_',num2str(ct)])%kfcs3
        end
        disp(ct)
    end

    if run_cs
        [x_upd_regularcs_nonoise,T_hat] = regularcs_no_noise(y,Pi0,A,Q,R); %[x_upd] = regularcs(y,Pi0,A,Q,R);
        for t = 1:tot
            err_regularcs_nonoise(ct,t) = norm( x(:,t)-x_upd_regularcs_nonoise(:,t) )^2;
        end
        disp(err_regularcs_nonoise(ct,:))
        not_detected_regularcs_nonoise(ct) = length(setdiff(T,T_hat))

        [x_upd_regularcs,T_hat] = regularcs(y,Pi0,A,Q,R); %[x_upd] = regularcs(y,Pi0,A,Q,R);
        for t = 1:tot
            err_regularcs(ct,t) = norm( x(:,t)-x_upd_regularcs(:,t) )^2;
        end
        disp(err_regularcs(ct,:))
        not_detected_regularcs(ct) = length(setdiff(T,T_hat))
        save(['temp_cs_',num2str(ct)])%kfcs3
        disp(ct)
    end
end

sim=1;
if sim==0
    set(0,'defaultaxesfontsize',18)
    finct = 100;
    load(['temp_cs_',num2str(finct)])
    load(['temp_kfcs_',num2str(finct)])
    plot(mean(err_genie(1:finct,:),1),'k')
    plot(mean(err_regularcs_nonoise(1:finct,:),1),'r-*')
    plot(mean(err(1:finct,:),1),'b-s')
    xlabel('time, t \rightarrow','FontSize',18)
    ylabel('normalized MSE \rightarrow','FontSize',18)
end
